/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ErrorResponse
extends RuntimeException {
    private final String errorMessage;
    private final int statusCode;

    public ErrorResponse(String errorMessage, int statusCode) {
        super(errorMessage);
        this.errorMessage = errorMessage;
        this.statusCode = statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isAlreadyOpenInstance() {
        return this.errorMessage != null && this.errorMessage.toLowerCase().contains("already has an open shop instance");
    }

    public boolean shopNotFound() {
        return this.errorMessage != null && this.errorMessage.toLowerCase().contains("shop not found");
    }

    public boolean isShopSessionNotFound() {
        return this.errorMessage != null && this.errorMessage.toLowerCase().contains("instance not found");
    }

    public boolean isSessionExpired() {
        return this.errorMessage != null && this.errorMessage.toLowerCase().contains("expired");
    }

    public boolean isEmptyCart() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("empty cart") || this.errorMessage.toLowerCase().contains("no items") || this.errorMessage.toLowerCase().contains("nothing to purchase"));
    }

    public boolean isPermissionError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("permission") || this.errorMessage.toLowerCase().contains("not allowed") || this.errorMessage.toLowerCase().contains("unauthorized"));
    }

    public boolean isMaintenanceError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("maintenance") || this.errorMessage.toLowerCase().contains("temporarily unavailable") || this.errorMessage.toLowerCase().contains("down for maintenance"));
    }

    public boolean isRateLimitError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("rate limit") || this.errorMessage.toLowerCase().contains("too many requests") || this.errorMessage.toLowerCase().contains("try again later"));
    }

    public boolean isInvalidPurchaseError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("invalid purchase") || this.errorMessage.toLowerCase().contains("invalid item") || this.errorMessage.toLowerCase().contains("item not available"));
    }

    public boolean isPaymentError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("payment") || this.errorMessage.toLowerCase().contains("transaction failed") || this.errorMessage.toLowerCase().contains("insufficient funds"));
    }

    public boolean isTimeoutError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("timeout") || this.errorMessage.toLowerCase().contains("timed out") || this.errorMessage.toLowerCase().contains("connection timed out"));
    }

    public boolean isNetworkError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("network") || this.errorMessage.toLowerCase().contains("connection") || this.errorMessage.toLowerCase().contains("unreachable"));
    }

    public boolean isTfaError() {
        return this.errorMessage != null && (this.errorMessage.toLowerCase().contains("tfa") || this.errorMessage.toLowerCase().contains("two-factor") || this.errorMessage.toLowerCase().contains("verification code"));
    }

    public String getUserFriendlyTitle() {
        if (this.isAlreadyOpenInstance()) {
            return "Active Session Exists";
        }
        if (this.shopNotFound()) {
            return "Shop Not Found";
        }
        if (this.isShopSessionNotFound()) {
            return "Session Not Found";
        }
        if (this.isSessionExpired()) {
            return "Session Expired";
        }
        if (this.isEmptyCart()) {
            return "Empty Cart";
        }
        if (this.isPermissionError()) {
            return "Permission Denied";
        }
        if (this.isMaintenanceError()) {
            return "Server Maintenance";
        }
        if (this.isRateLimitError()) {
            return "Rate Limited";
        }
        if (this.isInvalidPurchaseError()) {
            return "Invalid Purchase";
        }
        if (this.isPaymentError()) {
            return "Payment Error";
        }
        if (this.isTimeoutError()) {
            return "Connection Timeout";
        }
        if (this.isNetworkError()) {
            return "Network Error";
        }
        if (this.isTfaError()) {
            return "Verification Code Error";
        }
        return "Shop Error";
    }

    public Component getUserFriendlyMessage() {
        if (this.isAlreadyOpenInstance()) {
            return Component.m_237113_((String)"You already have an active shop session. Please finish or cancel your current session before starting a new one.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.shopNotFound()) {
            return Component.m_237113_((String)"The requested shop could not be found. Please check the shop name and try again.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isShopSessionNotFound()) {
            return Component.m_237113_((String)"Your shop session was not found. It may have expired or been closed.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isSessionExpired()) {
            return Component.m_237113_((String)"Your shop session has expired. Please start a new session.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isEmptyCart()) {
            return Component.m_237113_((String)"Your shopping cart is empty. You need to add items to your cart before checking out.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isPermissionError()) {
            return Component.m_237113_((String)"You don't have permission to perform this action.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isMaintenanceError()) {
            return Component.m_237113_((String)"The shop server is currently under maintenance. Please try again later.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isRateLimitError()) {
            return Component.m_237113_((String)"You've made too many requests. Please wait a moment before trying again.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isInvalidPurchaseError()) {
            return Component.m_237113_((String)"Your purchase contains invalid or unavailable items.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isPaymentError()) {
            return Component.m_237113_((String)"There was an issue processing your payment. The transaction could not be completed.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isTimeoutError()) {
            return Component.m_237113_((String)"The request timed out while connecting to the shop server.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isNetworkError()) {
            return Component.m_237113_((String)"A network error occurred while communicating with the shop server.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        if (this.isTfaError()) {
            return Component.m_237113_((String)"The verification code provided is incorrect or has expired.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        }
        return Component.m_237113_((String)("Shop error: " + this.errorMessage)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
    }

    public Component getHelpText() {
        if (this.isAlreadyOpenInstance()) {
            return Component.m_237113_((String)"If you can't find your active session, for it to expire automatically, which takes at most 15 minutes.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.shopNotFound()) {
            return Component.m_237113_((String)"Check the shop name and make sure it exists.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isShopSessionNotFound()) {
            return Component.m_237113_((String)"Please start a new shop session.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isSessionExpired()) {
            return Component.m_237113_((String)"Shop sessions expire after a period of inactivity.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isEmptyCart()) {
            return Component.m_237113_((String)"Return to the shop website and add some items to your cart before checking out.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isPermissionError()) {
            return Component.m_237113_((String)"Contact a server administrator if you believe you should have access.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isMaintenanceError()) {
            return Component.m_237113_((String)"The shop server is being updated. Please check back in a few minutes.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isRateLimitError()) {
            return Component.m_237113_((String)"Rate limits help protect the server. Wait a minute before trying again.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isInvalidPurchaseError()) {
            return Component.m_237113_((String)"Some items may be out of stock or no longer available. Try adjusting your cart.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isPaymentError()) {
            return Component.m_237113_((String)"Check your payment details or try using a different payment method.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isTimeoutError()) {
            return Component.m_237113_((String)"The shop server may be experiencing high traffic. Please try again later.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isNetworkError()) {
            return Component.m_237113_((String)"Check your internet connection and try again. If the problem persists, the server may be down.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        if (this.isTfaError()) {
            return Component.m_237113_((String)"Make sure you're using the most recent verification code. Try starting a new shop session.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        }
        return Component.m_237113_((String)"Please try again later or contact an administrator.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
    }
}

