/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import info.rusty.webshoplink.ErrorResponse;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class UIUtils {
    public static Component createShopBorder(String title, boolean isHeader) {
        StringBuilder border = new StringBuilder();
        int totalLength = 50;
        if (isHeader) {
            if (title.length() > totalLength - 4) {
                title = title.substring(0, totalLength - 4);
            }
            int titleLength = title.length();
            int padding = (totalLength - titleLength - 2) / 2;
            border.append("=".repeat(padding));
            if (!title.isEmpty()) {
                border.append(" ").append(title).append(" ");
            }
            border.append("=".repeat(Math.max(0, totalLength - padding - titleLength - 2)));
        } else {
            border.append("=".repeat(totalLength));
        }
        return Component.m_237113_((String)border.toString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
    }

    public static void displayErrorMessage(ServerPlayer player, ErrorResponse error) {
        MutableComponent spacerComponent = Component.m_237113_((String)"");
        Component headerComponent = UIUtils.createShopBorder(error.getUserFriendlyTitle(), true);
        Component errorComponent = error.getUserFriendlyMessage();
        Component helpComponent = error.getHelpText();
        Component footerComponent = UIUtils.createShopBorder("", false);
        player.m_213846_((Component)spacerComponent);
        player.m_213846_(headerComponent);
        player.m_213846_(errorComponent);
        player.m_213846_(helpComponent);
        player.m_213846_(footerComponent);
        player.m_213846_((Component)spacerComponent);
    }

    public static void displayConnectionError(ServerPlayer player, String errorMessage) {
        MutableComponent spacerComponent = Component.m_237113_((String)"");
        Component headerComponent = UIUtils.createShopBorder("Connection Error", true);
        MutableComponent errorComponent = Component.m_237113_((String)errorMessage).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED));
        MutableComponent helpComponent = Component.m_237113_((String)"Please check your connection and try again later.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        Component footerComponent = UIUtils.createShopBorder("", false);
        player.m_213846_((Component)spacerComponent);
        player.m_213846_(headerComponent);
        player.m_213846_((Component)errorComponent);
        player.m_213846_((Component)helpComponent);
        player.m_213846_(footerComponent);
        player.m_213846_((Component)spacerComponent);
    }

    public static void displaySuccessMessage(ServerPlayer player, String title, String message) {
        MutableComponent spacerComponent = Component.m_237113_((String)"");
        Component headerComponent = UIUtils.createShopBorder(title, true);
        MutableComponent successComponent = Component.m_237113_((String)message).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
        Component footerComponent = UIUtils.createShopBorder("", false);
        player.m_213846_((Component)spacerComponent);
        player.m_213846_(headerComponent);
        player.m_213846_((Component)successComponent);
        player.m_213846_(footerComponent);
        player.m_213846_((Component)spacerComponent);
    }

    public static void displayWarningMessage(ServerPlayer player, String title, String message, String helpText) {
        MutableComponent spacerComponent = Component.m_237113_((String)"");
        Component headerComponent = UIUtils.createShopBorder(title, true);
        MutableComponent warningComponent = Component.m_237113_((String)message).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD));
        MutableComponent helpComponent = Component.m_237113_((String)helpText).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW));
        Component footerComponent = UIUtils.createShopBorder("", false);
        player.m_213846_((Component)spacerComponent);
        player.m_213846_(headerComponent);
        player.m_213846_((Component)warningComponent);
        player.m_213846_((Component)helpComponent);
        player.m_213846_(footerComponent);
        player.m_213846_((Component)spacerComponent);
    }
}

