/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.JsonObject;
import info.rusty.webshoplink.Config;
import info.rusty.webshoplink.DataTypes;
import info.rusty.webshoplink.DebugLogger;
import info.rusty.webshoplink.NbtDebugUtils;
import info.rusty.webshoplink.NbtSerializer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;

public class InventoryManager {
    public static DataTypes.InventorySnapshot captureInventory(Player player) {
        int i;
        Inventory inventory = player.m_150109_();
        int mainSize = inventory.m_6643_() - inventory.f_35975_.size() - inventory.f_35976_.size();
        ItemStack[] mainInventory = new ItemStack[mainSize];
        ItemStack[] armorInventory = new ItemStack[inventory.f_35975_.size()];
        ItemStack[] offhandInventory = new ItemStack[inventory.f_35976_.size()];
        ItemStack[] enderChest = new ItemStack[player.m_36327_().m_6643_()];
        for (i = 0; i < mainSize; ++i) {
            mainInventory[i] = inventory.m_8020_(i).m_41777_();
            if (inventory.m_8020_(i).m_41619_() || !inventory.m_8020_(i).m_41782_()) continue;
            NbtDebugUtils.logItemStackNbt(inventory.m_8020_(i), "Main inventory slot " + i);
        }
        for (i = 0; i < inventory.f_35975_.size(); ++i) {
            armorInventory[i] = ((ItemStack)inventory.f_35975_.get(i)).m_41777_();
            if (((ItemStack)inventory.f_35975_.get(i)).m_41619_() || !((ItemStack)inventory.f_35975_.get(i)).m_41782_()) continue;
            NbtDebugUtils.logItemStackNbt((ItemStack)inventory.f_35975_.get(i), "Armor slot " + i);
        }
        for (i = 0; i < inventory.f_35976_.size(); ++i) {
            offhandInventory[i] = ((ItemStack)inventory.f_35976_.get(i)).m_41777_();
            if (((ItemStack)inventory.f_35976_.get(i)).m_41619_() || !((ItemStack)inventory.f_35976_.get(i)).m_41782_()) continue;
            NbtDebugUtils.logItemStackNbt((ItemStack)inventory.f_35976_.get(i), "Offhand slot " + i);
        }
        for (i = 0; i < player.m_36327_().m_6643_(); ++i) {
            enderChest[i] = player.m_36327_().m_8020_(i).m_41777_();
            if (player.m_36327_().m_8020_(i).m_41619_() || !player.m_36327_().m_8020_(i).m_41782_()) continue;
            NbtDebugUtils.logItemStackNbt(player.m_36327_().m_8020_(i), "Ender chest slot " + i);
        }
        return new DataTypes.InventorySnapshot(mainInventory, armorInventory, offhandInventory, enderChest);
    }

    public static boolean inventoriesMatch(DataTypes.InventorySnapshot snapshot, DataTypes.InventorySnapshot current) {
        int i;
        if (snapshot.getMainInventory().length != current.getMainInventory().length) {
            return false;
        }
        for (i = 0; i < snapshot.getMainInventory().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getMainInventory()[i], (ItemStack)current.getMainInventory()[i])) continue;
            return false;
        }
        if (snapshot.getArmorInventory().length != current.getArmorInventory().length) {
            return false;
        }
        for (i = 0; i < snapshot.getArmorInventory().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getArmorInventory()[i], (ItemStack)current.getArmorInventory()[i])) continue;
            return false;
        }
        if (snapshot.getOffhandInventory().length != current.getOffhandInventory().length) {
            return false;
        }
        for (i = 0; i < snapshot.getOffhandInventory().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getOffhandInventory()[i], (ItemStack)current.getOffhandInventory()[i])) continue;
            return false;
        }
        if (snapshot.getEnderChest().length != current.getEnderChest().length) {
            return false;
        }
        for (i = 0; i < snapshot.getEnderChest().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getEnderChest()[i], (ItemStack)current.getEnderChest()[i])) continue;
            return false;
        }
        return true;
    }

    public static void applyNewInventory(ServerPlayer player, DataTypes.InventoryData newInventory) {
        DebugLogger.log("Applying new inventory to player: " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        Map<Integer, DataTypes.ItemData> items = newInventory.getItems();
        for (int i = 0; i < newInventory.getSize(); ++i) {
            DataTypes.ItemData item = items.get(i);
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            InventoryManager.logItemComparison(currentStack, item, "Inventory", i);
            if (item != null) {
                boolean shouldUpdate = false;
                ItemStack newItemStack = item.getItemStackData();
                if (currentStack.m_41619_()) {
                    shouldUpdate = !newItemStack.m_41619_();
                } else {
                    String currentItemId = BuiltInRegistries.f_257033_.m_7981_((Object)currentStack.m_41720_()).toString();
                    if (!currentItemId.equals(item.getItemId())) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41613_() != item.getCount().intValue()) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41782_() && item.getNbt() == null || !currentStack.m_41782_() && item.getNbt() != null) {
                        shouldUpdate = true;
                        DebugLogger.log("NBT mismatch: one has NBT, other doesn't", Config.DebugVerbosity.DEFAULT);
                    } else if (currentStack.m_41782_() && item.getNbt() != null) {
                        JsonObject currentNbtJson = (JsonObject)NbtSerializer.serializeNbt(currentStack.m_41783_());
                        boolean bl = shouldUpdate = !currentNbtJson.equals((Object)item.getNbt());
                        if (shouldUpdate) {
                            DebugLogger.log("NBT mismatch detected between current and new item", Config.DebugVerbosity.DEFAULT);
                        }
                    }
                }
                if (!shouldUpdate) continue;
                player.m_150109_().m_6836_(i, newItemStack);
                DebugLogger.log("Updated slot " + i + " to " + item.getItemId() + " x" + item.getCount(), Config.DebugVerbosity.DEFAULT);
                continue;
            }
            if (currentStack.m_41619_()) continue;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            DebugLogger.log("Cleared slot " + i, Config.DebugVerbosity.DEFAULT);
        }
    }

    public static void applyNewEchest(ServerPlayer player, DataTypes.ContainerData newEchest) {
        DebugLogger.log("Applying new E-Chest to player: " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        Map<Integer, DataTypes.ItemData> items = newEchest.getItems();
        for (int i = 0; i < newEchest.getSize(); ++i) {
            DataTypes.ItemData item = items.get(i);
            ItemStack currentStack = player.m_36327_().m_8020_(i);
            InventoryManager.logItemComparison(currentStack, item, "E-Chest", i);
            if (item != null) {
                boolean shouldUpdate = false;
                ItemStack newItemStack = item.getItemStackData();
                if (currentStack.m_41619_()) {
                    shouldUpdate = !newItemStack.m_41619_();
                } else {
                    String currentItemId = BuiltInRegistries.f_257033_.m_7981_((Object)currentStack.m_41720_()).toString();
                    if (!currentItemId.equals(item.getItemId())) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41613_() != item.getCount().intValue()) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41782_() && item.getNbt() == null || !currentStack.m_41782_() && item.getNbt() != null) {
                        shouldUpdate = true;
                        DebugLogger.log("E-Chest NBT mismatch: one has NBT, other doesn't", Config.DebugVerbosity.DEFAULT);
                    } else if (currentStack.m_41782_() && item.getNbt() != null) {
                        JsonObject currentNbtJson = (JsonObject)NbtSerializer.serializeNbt(currentStack.m_41783_());
                        boolean bl = shouldUpdate = !currentNbtJson.equals((Object)item.getNbt());
                        if (shouldUpdate) {
                            DebugLogger.log("E-Chest NBT mismatch detected between current and new item", Config.DebugVerbosity.DEFAULT);
                        }
                    }
                }
                if (!shouldUpdate) continue;
                player.m_36327_().m_6836_(i, newItemStack);
                DebugLogger.log("Updated ender chest slot " + i + " to " + item.getItemId() + " x" + item.getCount(), Config.DebugVerbosity.DEFAULT);
                continue;
            }
            if (currentStack.m_41619_()) continue;
            player.m_36327_().m_6836_(i, ItemStack.f_41583_);
            DebugLogger.log("Cleared ender chest slot " + i, Config.DebugVerbosity.DEFAULT);
        }
    }

    public static DataTypes.InventoryDiff generateInventoryDiff(DataTypes.InventorySnapshot original, DataTypes.InventoryData newInventory) {
        return InventoryManager.generateInventoryDiff(original, newInventory, null);
    }

    public static DataTypes.InventoryDiff generateInventoryDiff(DataTypes.InventorySnapshot original, DataTypes.InventoryData newInventory, DataTypes.ContainerData newEchest) {
        Object itemKey;
        DebugLogger.log("Generating inventory diff", Config.DebugVerbosity.MINIMAL);
        DataTypes.InventoryDiff diff = new DataTypes.InventoryDiff();
        Map<Integer, DataTypes.ItemData> newItems = newInventory.getItems();
        HashMap<String, Integer> originalItemCounts = new HashMap<String, Integer>();
        for (int i = 0; i < original.getMainInventory().length; ++i) {
            ItemStack stack = original.getMainInventory()[i];
            if (stack.m_41619_()) continue;
            String itemKey2 = InventoryManager.getItemKey(stack);
            originalItemCounts.put(itemKey2, originalItemCounts.getOrDefault(itemKey2, 0) + stack.m_41613_());
        }
        for (ItemStack stack : original.getArmorInventory()) {
            if (stack.m_41619_()) continue;
            itemKey = InventoryManager.getItemKey(stack);
            originalItemCounts.put((String)itemKey, originalItemCounts.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        for (ItemStack stack : original.getOffhandInventory()) {
            if (stack.m_41619_()) continue;
            itemKey = InventoryManager.getItemKey(stack);
            originalItemCounts.put((String)itemKey, originalItemCounts.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        for (ItemStack stack : original.getEnderChest()) {
            if (stack.m_41619_()) continue;
            itemKey = InventoryManager.getItemKey(stack);
            originalItemCounts.put((String)itemKey, originalItemCounts.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        HashMap<String, Integer> newItemCounts = new HashMap<String, Integer>();
        for (int i = 0; i < newInventory.getSize(); ++i) {
            DataTypes.ItemData itemData = newItems.get(i);
            if (itemData == null) continue;
            Object itemKey3 = itemData.getItemId();
            if (itemData.getNbt() != null) {
                itemKey3 = (String)itemKey3 + ":" + itemData.getNbt().hashCode();
                DebugLogger.log("Generated new item key for " + (String)itemKey3 + " with NBT hash: " + itemData.getNbt().hashCode(), Config.DebugVerbosity.ALL);
            }
            newItemCounts.put((String)itemKey3, newItemCounts.getOrDefault(itemKey3, 0) + itemData.getCount());
        }
        if (newEchest != null) {
            Map<Integer, DataTypes.ItemData> newEchestItems = newEchest.getItems();
            for (int i = 0; i < newEchest.getSize(); ++i) {
                DataTypes.ItemData itemData = newEchestItems.get(i);
                if (itemData == null) continue;
                itemKey = itemData.getItemId();
                if (itemData.getNbt() != null) {
                    itemKey = (String)itemKey + ":" + itemData.getNbt().hashCode();
                    DebugLogger.log("Generated new echest item key for " + (String)itemKey + " with NBT hash: " + itemData.getNbt().hashCode(), Config.DebugVerbosity.ALL);
                }
                newItemCounts.put((String)itemKey, newItemCounts.getOrDefault(itemKey, 0) + itemData.getCount());
            }
        }
        HashSet allItems = new HashSet();
        allItems.addAll(originalItemCounts.keySet());
        allItems.addAll(newItemCounts.keySet());
        for (Object itemKey3 : allItems) {
            int originalCount = originalItemCounts.getOrDefault(itemKey3, 0);
            int newCount = newItemCounts.getOrDefault(itemKey3, 0);
            int diff_count = newCount - originalCount;
            if (diff_count == 0) continue;
            Object itemId = itemKey3;
            if (((String)itemKey3).contains(":nbt")) {
                itemId = ((String)itemKey3).substring(0, ((String)itemKey3).indexOf(":nbt"));
            }
            if (diff_count > 0) {
                diff.addItem((String)itemId, diff_count);
                continue;
            }
            diff.removeItem((String)itemId, -diff_count);
        }
        return diff;
    }

    private static String getItemKey(ItemStack stack) {
        Object itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        if (stack.m_41782_()) {
            JsonObject nbtJson = (JsonObject)NbtSerializer.serializeNbt(stack.m_41783_());
            DebugLogger.log("Generated item key for " + (String)itemKey + " with NBT: " + String.valueOf(nbtJson), Config.DebugVerbosity.ALL);
            itemKey = (String)itemKey + ":" + nbtJson.hashCode();
        }
        return itemKey;
    }

    public static Map<String, Integer> removeMoneyItems(Player player) {
        String itemId;
        ItemStack stack;
        int i;
        int totalRemoved = 0;
        HashMap<String, Integer> removedItems = new HashMap<String, Integer>();
        Inventory inventory = player.m_150109_();
        PlayerEnderChestContainer echest = player.m_36327_();
        DebugLogger.log("Checking for money items to remove from player: " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        for (i = 0; i < inventory.m_6643_(); ++i) {
            stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !Config.moneyItems.contains(stack.m_41720_())) continue;
            itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
            DebugLogger.log("Removing money item: " + stack.m_41720_().m_41466_().getString() + " x" + stack.m_41613_() + " from Inventory slot " + i, Config.DebugVerbosity.DEFAULT);
            totalRemoved += stack.m_41613_();
            removedItems.put(itemId, removedItems.getOrDefault(itemId, 0) + stack.m_41613_());
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        for (i = 0; i < echest.m_6643_(); ++i) {
            stack = echest.m_8020_(i);
            if (stack.m_41619_() || !Config.moneyItems.contains(stack.m_41720_())) continue;
            itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
            DebugLogger.log("Removing money item: " + stack.m_41720_().m_41466_().getString() + " x" + stack.m_41613_() + " from E-Chest slot " + i, Config.DebugVerbosity.DEFAULT);
            totalRemoved += stack.m_41613_();
            removedItems.put(itemId, removedItems.getOrDefault(itemId, 0) + stack.m_41613_());
            echest.m_6836_(i, ItemStack.f_41583_);
        }
        DebugLogger.log("Removed " + totalRemoved + " money items from player " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        return removedItems;
    }

    public static void logItemComparison(ItemStack current, DataTypes.ItemData itemData, String slotType, int slotIndex) {
        if (current.m_41619_() && itemData == null) {
            return;
        }
        if (current.m_41619_()) {
            DebugLogger.log(slotType + " slot " + slotIndex + ": Current is empty, new item is " + itemData.getItemId() + " x" + itemData.getCount(), Config.DebugVerbosity.DEFAULT);
            if (itemData.getNbt() != null) {
                DebugLogger.log("New item has NBT: " + String.valueOf(itemData.getNbt()), Config.DebugVerbosity.DEFAULT);
                NbtDebugUtils.logJsonNbt(itemData.getNbt(), "New item NBT");
            }
            return;
        }
        if (itemData == null) {
            String currentId = BuiltInRegistries.f_257033_.m_7981_((Object)current.m_41720_()).toString();
            DebugLogger.log(slotType + " slot " + slotIndex + ": Current is " + currentId + " x" + current.m_41613_() + ", new is empty", Config.DebugVerbosity.DEFAULT);
            if (current.m_41782_()) {
                NbtDebugUtils.logItemStackNbt(current, "Current item being removed");
            }
            return;
        }
        String currentId = BuiltInRegistries.f_257033_.m_7981_((Object)current.m_41720_()).toString();
        DebugLogger.log(slotType + " slot " + slotIndex + ": Comparing items", Config.DebugVerbosity.DEFAULT);
        DebugLogger.log("Current: " + currentId + " x" + current.m_41613_(), Config.DebugVerbosity.DEFAULT);
        DebugLogger.log("New: " + itemData.getItemId() + " x" + itemData.getCount(), Config.DebugVerbosity.DEFAULT);
        if (!currentId.equals(itemData.getItemId())) {
            DebugLogger.log("Item types are different", Config.DebugVerbosity.DEFAULT);
            return;
        }
        if (current.m_41613_() != itemData.getCount().intValue()) {
            DebugLogger.log("Item counts are different", Config.DebugVerbosity.DEFAULT);
        }
        if (current.m_41782_() && itemData.getNbt() != null) {
            DebugLogger.log("Both items have NBT data, comparing...", Config.DebugVerbosity.DEFAULT);
            NbtDebugUtils.logItemStackNbt(current, "Current item");
            NbtDebugUtils.logJsonNbt(itemData.getNbt(), "New item from API");
            JsonObject currentNbtJson = (JsonObject)NbtSerializer.serializeNbt(current.m_41783_());
            boolean nbtMatch = currentNbtJson.equals((Object)itemData.getNbt());
            if (nbtMatch) {
                DebugLogger.log("NBT data matches!", Config.DebugVerbosity.DEFAULT);
            } else {
                DebugLogger.log("NBT data differs!", Config.DebugVerbosity.DEFAULT);
                ItemStack testStack = current.m_41777_();
                try {
                    CompoundTag testNbt = NbtSerializer.CompoundTagAdapter.parseJsonToCompoundTag(itemData.getNbt());
                    testStack.m_41751_(testNbt);
                    NbtDebugUtils.logItemStackNbt(testStack, "Test applying new NBT");
                    boolean wouldMatch = testStack.m_41783_().equals((Object)current.m_41783_());
                    DebugLogger.log("After applying new NBT data, items would " + (wouldMatch ? "MATCH" : "STILL DIFFER"), Config.DebugVerbosity.DEFAULT);
                }
                catch (Exception e) {
                    DebugLogger.logError("Failed to apply test NBT: " + e.getMessage(), e);
                }
            }
        } else if (current.m_41782_()) {
            DebugLogger.log("Current item has NBT but new item doesn't", Config.DebugVerbosity.DEFAULT);
            NbtDebugUtils.logItemStackNbt(current, "Current item");
        } else if (itemData.getNbt() != null) {
            DebugLogger.log("New item has NBT but current doesn't", Config.DebugVerbosity.DEFAULT);
            NbtDebugUtils.logJsonNbt(itemData.getNbt(), "New item NBT");
        } else {
            DebugLogger.log("Neither item has NBT data", Config.DebugVerbosity.DEFAULT);
        }
    }

    public static String getInventoryDifferences(DataTypes.InventorySnapshot snapshot, DataTypes.InventorySnapshot current) {
        int i;
        StringBuilder differences = new StringBuilder();
        boolean hasDifferences = false;
        if (snapshot.getMainInventory().length != current.getMainInventory().length) {
            differences.append("Main inventory size changed. ");
            hasDifferences = true;
        } else {
            for (i = 0; i < snapshot.getMainInventory().length; ++i) {
                if (ItemStack.m_41728_((ItemStack)snapshot.getMainInventory()[i], (ItemStack)current.getMainInventory()[i])) continue;
                differences.append("Item in slot ").append(i).append(" changed. ");
                hasDifferences = true;
            }
        }
        if (snapshot.getArmorInventory().length != current.getArmorInventory().length) {
            differences.append("Armor inventory size changed. ");
            hasDifferences = true;
        } else {
            for (i = 0; i < snapshot.getArmorInventory().length; ++i) {
                if (ItemStack.m_41728_((ItemStack)snapshot.getArmorInventory()[i], (ItemStack)current.getArmorInventory()[i])) continue;
                differences.append("Armor in slot ").append(i).append(" changed. ");
                hasDifferences = true;
            }
        }
        if (snapshot.getOffhandInventory().length != current.getOffhandInventory().length) {
            differences.append("Offhand inventory size changed. ");
            hasDifferences = true;
        } else {
            for (i = 0; i < snapshot.getOffhandInventory().length; ++i) {
                if (ItemStack.m_41728_((ItemStack)snapshot.getOffhandInventory()[i], (ItemStack)current.getOffhandInventory()[i])) continue;
                differences.append("Offhand item changed. ");
                hasDifferences = true;
            }
        }
        return hasDifferences ? differences.toString() : null;
    }
}

