/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="webshoplink", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<String> API_BASE_URL = BUILDER.comment("Base URL for the shop API").define("apiBaseUrl", (Object)"http://localhost:8080/api/shop");
    private static final ForgeConfigSpec.ConfigValue<String> SHOP_ENDPOINT = BUILDER.comment("Endpoint for initiating shop processes").define("shopEndpoint", (Object)"/initiate");
    private static final ForgeConfigSpec.ConfigValue<String> SHOP_CANCEL_ENDPOINT = BUILDER.comment("Endpoint for cancelling shop processes").define("shopCancelEndpoint", (Object)"/{uuid}/cancel");
    private static final ForgeConfigSpec.ConfigValue<String> SHOP_CHECKOUT_ENDPOINT = BUILDER.comment("Endpoint for checking out shop processes").define("shopCheckoutEndpoint", (Object)"/{uuid}/checkout");
    private static final ForgeConfigSpec.ConfigValue<String> SHOP_APPLIED_ENDPOINT = BUILDER.comment("Endpoint for marking shop processes as applied").define("shopAppliedEndpoint", (Object)"/{uuid}/setApplied");
    private static final ForgeConfigSpec.BooleanValue DEBUG_ENABLED = BUILDER.comment("Enable debug logging").define("debugEnabled", false);
    private static final ForgeConfigSpec.EnumValue<DebugVerbosity> DEBUG_VERBOSITY = BUILDER.comment("Debug verbosity level: MINIMAL (basic info), DEFAULT (standard info), ALL (detailed info including inventory contents)").defineEnum("debugVerbosity", (Enum)DebugVerbosity.DEFAULT);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static String apiBaseUrl;
    public static String shopEndpoint;
    public static String shopCancelEndpoint;
    public static String shopCheckoutEndpoint;
    public static String shopAppliedEndpoint;
    public static Set<Item> moneyItems;
    public static boolean debugEnabled;
    public static DebugVerbosity debugVerbosity;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.m_135820_((String)(itemName = (String)obj)));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        apiBaseUrl = (String)API_BASE_URL.get();
        shopEndpoint = (String)SHOP_ENDPOINT.get();
        shopCancelEndpoint = (String)SHOP_CANCEL_ENDPOINT.get();
        shopCheckoutEndpoint = (String)SHOP_CHECKOUT_ENDPOINT.get();
        shopAppliedEndpoint = (String)SHOP_APPLIED_ENDPOINT.get();
        debugEnabled = (Boolean)DEBUG_ENABLED.get();
        debugVerbosity = (DebugVerbosity)((Object)DEBUG_VERBOSITY.get());
    }

    public static enum DebugVerbosity {
        MINIMAL,
        DEFAULT,
        ALL;

    }
}

