/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import info.rusty.webshoplink.Config;
import info.rusty.webshoplink.DebugLogger;
import info.rusty.webshoplink.NbtDebugUtils;
import info.rusty.webshoplink.NbtSerializer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;

public class DataTypes {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static class InventoryChange {
        private final String itemId;
        private final int count;
        private final String formattedName;

        public InventoryChange(String itemId, int count) {
            this.itemId = itemId;
            this.count = count;
            this.formattedName = InventoryChange.formatItemId(itemId);
        }

        public String getItemId() {
            return this.itemId;
        }

        public int getCount() {
            return this.count;
        }

        public String getFormattedName() {
            return this.formattedName;
        }

        public static String formatItemId(String itemId) {
            String displayName = itemId;
            if (displayName.contains(":")) {
                displayName = displayName.substring(displayName.indexOf(":") + 1);
            }
            String[] parts = displayName.split("_");
            StringBuilder formatted = new StringBuilder();
            for (String part : parts) {
                if (part.isEmpty()) continue;
                formatted.append(Character.toUpperCase(part.charAt(0)));
                formatted.append(part.substring(1));
                formatted.append(" ");
            }
            return formatted.toString().trim();
        }
    }

    public static class InventoryDiff {
        private final List<InventoryChange> added = new ArrayList<InventoryChange>();
        private final List<InventoryChange> removed = new ArrayList<InventoryChange>();

        public List<InventoryChange> getAdded() {
            return this.added;
        }

        public List<InventoryChange> getRemoved() {
            return this.removed;
        }

        public void addItem(String itemId, int count) {
            if (count > 0) {
                this.added.add(new InventoryChange(itemId, count));
            }
        }

        public void removeItem(String itemId, int count) {
            if (count > 0) {
                this.removed.add(new InventoryChange(itemId, count));
            }
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }
    }

    public static class ItemData {
        private String itemId;
        private Integer count;
        private JsonObject nbt;

        public String getItemId() {
            return this.itemId;
        }

        public Integer getCount() {
            return this.count;
        }

        public JsonObject getNbt() {
            return this.nbt;
        }

        public ItemStack getItemStackData() {
            try {
                String[] parts = this.itemId.split(":", 2);
                if (parts.length != 2) {
                    LOGGER.error("Invalid item ID format: {}", (Object)this.itemId);
                    return ItemStack.f_41583_;
                }
                ResourceLocation resourceLocation = new ResourceLocation(parts[0], parts[1]);
                Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(resourceLocation);
                if (item == Items.f_41852_) {
                    LOGGER.error("Could not find item with ID: {}", (Object)this.itemId);
                    return ItemStack.f_41583_;
                }
                ItemStack stack = new ItemStack((ItemLike)item, this.count != null ? this.count : 1);
                if (this.nbt != null) {
                    try {
                        DebugLogger.log("Converting NBT JSON to CompoundTag for item " + this.itemId, Config.DebugVerbosity.DEFAULT);
                        NbtDebugUtils.logJsonNbt(this.nbt, "Pre-conversion NBT JSON");
                        CompoundTag nbtData = NbtSerializer.CompoundTagAdapter.parseJsonToCompoundTag(this.nbt);
                        stack.m_41751_(nbtData);
                        DebugLogger.log("Applied NBT data to item " + this.itemId + ": " + String.valueOf(nbtData), Config.DebugVerbosity.DEFAULT);
                        NbtDebugUtils.logItemStackNbt(stack, "Post-application ItemStack");
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse NBT data for item {}: {}", (Object)this.itemId, (Object)e.getMessage());
                        e.printStackTrace();
                    }
                }
                return stack;
            }
            catch (Exception e) {
                LOGGER.error("Error creating ItemStack from ItemData: {}", (Object)e.getMessage());
                return ItemStack.f_41583_;
            }
        }
    }

    public static class ContainerData {
        private Integer size;
        private Map<Integer, ItemData> items;

        public Integer getSize() {
            return this.size;
        }

        public Map<Integer, ItemData> getItems() {
            return this.items;
        }

        public ItemData getItem(Integer index) {
            return this.items.get(index);
        }
    }

    public static class InventoryData {
        private Integer size;
        private Map<Integer, ItemData> items;

        public Integer getSize() {
            return this.size;
        }

        public Map<Integer, ItemData> getItems() {
            return this.items;
        }

        public ItemData getItem(Integer index) {
            return this.items.get(index);
        }
    }

    public static class InventoryList {
        private InventoryData inventory;
        private ContainerData echest;

        public InventoryData getInventoryData() {
            return this.inventory;
        }

        public ContainerData getEnderChestData() {
            return this.echest;
        }

        public void setInventoryFromPlayer(Inventory playerInventory) {
            if (playerInventory == null) {
                return;
            }
            this.inventory = new InventoryData();
            HashMap<Integer, ItemData> itemMap = new HashMap<Integer, ItemData>();
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack stack = playerInventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                ItemData itemData = this.createItemData(stack);
                itemMap.put(i, itemData);
            }
            this.inventory.size = playerInventory.m_6643_();
            this.inventory.items = itemMap;
        }

        public void setEchestFromPlayer(Container playerEchest) {
            if (playerEchest == null) {
                return;
            }
            this.echest = new ContainerData();
            HashMap<Integer, ItemData> itemMap = new HashMap<Integer, ItemData>();
            for (int i = 0; i < playerEchest.m_6643_(); ++i) {
                ItemStack stack = playerEchest.m_8020_(i);
                if (stack.m_41619_()) continue;
                ItemData itemData = this.createItemData(stack);
                itemMap.put(i, itemData);
            }
            this.echest.size = playerEchest.m_6643_();
            this.echest.items = itemMap;
        }

        private ItemData createItemData(ItemStack stack) {
            ItemData itemData;
            block5: {
                itemData = new ItemData();
                try {
                    Field itemIdField = ItemData.class.getDeclaredField("itemId");
                    Field countField = ItemData.class.getDeclaredField("count");
                    Field nbtField = ItemData.class.getDeclaredField("nbt");
                    itemIdField.setAccessible(true);
                    countField.setAccessible(true);
                    nbtField.setAccessible(true);
                    ResourceLocation itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
                    itemIdField.set(itemData, itemKey.toString());
                    countField.set(itemData, stack.m_41613_());
                    if (!stack.m_41782_()) break block5;
                    DebugLogger.log("Serializing NBT for item " + itemKey.toString(), Config.DebugVerbosity.DEFAULT);
                    NbtDebugUtils.logItemStackNbt(stack, "Original item before serialization");
                    JsonObject nbtJson = (JsonObject)NbtSerializer.serializeNbt(stack.m_41783_());
                    nbtField.set(itemData, nbtJson);
                    DebugLogger.log("Serialized NBT to JSON for item " + itemKey.toString(), Config.DebugVerbosity.DEFAULT);
                    NbtDebugUtils.logJsonNbt(nbtJson, "Serialized NBT JSON");
                    try {
                        CompoundTag roundTrip = NbtSerializer.CompoundTagAdapter.parseJsonToCompoundTag(nbtJson);
                        boolean tagsEqual = roundTrip.equals((Object)stack.m_41783_());
                        DebugLogger.log("Round-trip NBT conversion test: " + (tagsEqual ? "PASSED" : "FAILED"), Config.DebugVerbosity.DEFAULT);
                        if (!tagsEqual) {
                            DebugLogger.log("Original tag: " + String.valueOf(stack.m_41783_()), Config.DebugVerbosity.DEFAULT);
                            DebugLogger.log("Round-trip tag: " + String.valueOf(roundTrip), Config.DebugVerbosity.DEFAULT);
                        }
                    }
                    catch (Exception e) {
                        DebugLogger.logError("Failed round-trip NBT test: " + e.getMessage(), e);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error creating ItemData from ItemStack", (Throwable)e);
                }
            }
            return itemData;
        }
    }

    public static class ShopResponse {
        private String uuid;
        private String link;
        private String twoFactorCode;
        private String errorMessage;

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getTwoFactorCode() {
            return this.twoFactorCode;
        }

        public void setTwoFactorCode(String twoFactorCode) {
            this.twoFactorCode = twoFactorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public boolean hasError() {
            return this.errorMessage != null && !this.errorMessage.isEmpty();
        }
    }

    public static class ShopProcess {
        private final UUID playerId;
        private final UUID processId;
        private final InventorySnapshot originalInventory;
        private final String shopLabel;
        private String webLink;
        private String twoFactorCode;
        private InventoryData newInventory;
        private ContainerData newEchest;

        public ShopProcess(UUID playerId, UUID processId, InventorySnapshot originalInventory, String shopLabel) {
            this.playerId = playerId;
            this.processId = processId;
            this.originalInventory = originalInventory;
            this.shopLabel = shopLabel;
        }

        public UUID getPlayerId() {
            return this.playerId;
        }

        public UUID getProcessId() {
            return this.processId;
        }

        public InventorySnapshot getOriginalInventory() {
            return this.originalInventory;
        }

        public String getShopLabel() {
            return this.shopLabel;
        }

        public String getWebLink() {
            return this.webLink;
        }

        public void setWebLink(String webLink) {
            this.webLink = webLink;
        }

        public String getTwoFactorCode() {
            return this.twoFactorCode;
        }

        public void setTwoFactorCode(String twoFactorCode) {
            this.twoFactorCode = twoFactorCode;
        }

        public InventoryData getNewInventory() {
            return this.newInventory;
        }

        public void setNewInventory(InventoryData newInventory) {
            this.newInventory = newInventory;
        }

        public void setNewEchest(ContainerData newEchest) {
            this.newEchest = newEchest;
        }

        public ContainerData getNewEchest() {
            return this.newEchest;
        }
    }

    public static class InventorySnapshot {
        private final ItemStack[] mainInventory;
        private final ItemStack[] armorInventory;
        private final ItemStack[] offhandInventory;
        private final ItemStack[] enderChest;

        public InventorySnapshot(ItemStack[] mainInventory, ItemStack[] armorInventory, ItemStack[] offhandInventory, ItemStack[] enderChest) {
            this.mainInventory = mainInventory;
            this.armorInventory = armorInventory;
            this.offhandInventory = offhandInventory;
            this.enderChest = enderChest;
        }

        public ItemStack[] getMainInventory() {
            return this.mainInventory;
        }

        public ItemStack[] getArmorInventory() {
            return this.armorInventory;
        }

        public ItemStack[] getOffhandInventory() {
            return this.offhandInventory;
        }

        public ItemStack[] getEnderChest() {
            return this.enderChest;
        }
    }
}

