/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import info.rusty.webshoplink.Config;
import info.rusty.webshoplink.DataTypes;
import info.rusty.webshoplink.DebugLogger;
import info.rusty.webshoplink.NbtSerializer;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.CompoundTag;
import org.slf4j.Logger;

public class ApiService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CompoundTag.class, (Object)new NbtSerializer.CompoundTagAdapter()).create();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();

    public static CompletableFuture<DataTypes.ShopResponse> initiateShop(UUID playerId, String playerName, String shopSlug, DataTypes.InventoryList inventories) {
        DebugLogger.log("Player " + playerName + " started shop session", Config.DebugVerbosity.MINIMAL);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("playerId", playerId.toString());
        payload.put("shopSlug", shopSlug);
        payload.put("inventories", inventories);
        String jsonPayload = GSON.toJson(payload);
        DebugLogger.log("Sending API request to: " + Config.apiBaseUrl + Config.shopEndpoint, Config.DebugVerbosity.DEFAULT);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(Config.apiBaseUrl + Config.shopEndpoint)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
        return ((CompletableFuture)HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                DebugLogger.log("Received successful response: " + (String)response.body(), Config.DebugVerbosity.DEFAULT);
                DataTypes.ShopResponse shopResponse = (DataTypes.ShopResponse)GSON.fromJson((String)response.body(), DataTypes.ShopResponse.class);
                DebugLogger.log("Shop session initiated", Config.DebugVerbosity.MINIMAL);
                DebugLogger.log("Session UUID from server: " + shopResponse.getUuid(), Config.DebugVerbosity.DEFAULT);
                return shopResponse;
            }
            String errorMsg = "Error from shop API: " + response.statusCode() + " - " + (String)response.body();
            DebugLogger.logError(errorMsg, null);
            throw new RuntimeException("API error: " + response.statusCode());
        })).exceptionally(ex -> {
            DebugLogger.logError("Exception during API call", ex);
            throw new RuntimeException("API communication error", (Throwable)ex);
        });
    }

    public static CompletableFuture<DataTypes.InventoryList> finishShop(UUID processId, String playerName, String twoFactorCode) {
        DebugLogger.log("Player " + playerName + " checking out shop session", Config.DebugVerbosity.MINIMAL);
        DebugLogger.log("Player " + playerName + " checking out shop session: " + String.valueOf(processId) + " with code: " + twoFactorCode, Config.DebugVerbosity.DEFAULT);
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("tfaCode", twoFactorCode);
        String jsonPayload = GSON.toJson(payload);
        String endpoint = Config.apiBaseUrl + Config.shopCheckoutEndpoint.replace("{uuid}", processId.toString());
        DebugLogger.log("Sending checkout request to: " + endpoint, Config.DebugVerbosity.DEFAULT);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endpoint)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
        return ((CompletableFuture)HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() == 200) {
                DebugLogger.log("Received shop finish response: " + (String)response.body(), Config.DebugVerbosity.ALL);
                return (DataTypes.InventoryList)GSON.fromJson((String)response.body(), DataTypes.InventoryList.class);
            }
            String errorMsg = "Error from shop finish API: " + response.statusCode() + " - " + (String)response.body();
            DebugLogger.logError(errorMsg, null);
            throw new RuntimeException("API error: " + response.statusCode());
        })).exceptionally(ex -> {
            DebugLogger.logError("Exception during checkout API call", ex);
            throw new RuntimeException("API communication error", (Throwable)ex);
        });
    }

    public static CompletableFuture<Boolean> notifyChangesApplied(UUID processId, String twoFactorCode) {
        DebugLogger.log("Notifying server that changes were applied", Config.DebugVerbosity.MINIMAL);
        DebugLogger.log("Notifying server that changes for session " + String.valueOf(processId) + " were applied with code: " + twoFactorCode, Config.DebugVerbosity.DEFAULT);
        HashMap<String, String> payload = new HashMap<String, String>();
        payload.put("tfaCode", twoFactorCode);
        String jsonPayload = GSON.toJson(payload);
        String endpoint = Config.apiBaseUrl + Config.shopAppliedEndpoint.replace("{uuid}", processId.toString());
        DebugLogger.log("Sending notification to: " + endpoint, Config.DebugVerbosity.DEFAULT);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endpoint)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonPayload)).build();
        return ((CompletableFuture)HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() != 200) {
                DebugLogger.logError("Error notifying changes applied: " + response.statusCode() + " - " + (String)response.body(), null);
                return false;
            }
            DebugLogger.log("Successfully notified changes applied, response: " + (String)response.body(), Config.DebugVerbosity.DEFAULT);
            try {
                Map responseMap = (Map)GSON.fromJson((String)response.body(), Map.class);
                String message = (String)responseMap.get("message");
                if ("Shop instance marked as applied".equals(message)) {
                    DebugLogger.log("Server confirmed changes were applied", Config.DebugVerbosity.MINIMAL);
                    return true;
                }
                DebugLogger.logError("Unexpected response message: " + message, null);
                return false;
            }
            catch (Exception e) {
                DebugLogger.logError("Error parsing response: " + (String)response.body(), e);
                return false;
            }
        })).exceptionally(ex -> {
            DebugLogger.logError("Exception during notification API call", ex);
            return false;
        });
    }
}

