/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import info.rusty.webshoplink.Config;
import info.rusty.webshoplink.DataTypes;
import info.rusty.webshoplink.DebugLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;

public class InventoryManager {
    public static DataTypes.InventorySnapshot captureInventory(Player player) {
        int i;
        Inventory inventory = player.m_150109_();
        int mainSize = inventory.m_6643_() - inventory.f_35975_.size() - inventory.f_35976_.size();
        ItemStack[] mainInventory = new ItemStack[mainSize];
        ItemStack[] armorInventory = new ItemStack[inventory.f_35975_.size()];
        ItemStack[] offhandInventory = new ItemStack[inventory.f_35976_.size()];
        ItemStack[] enderChest = new ItemStack[player.m_36327_().m_6643_()];
        for (i = 0; i < mainSize; ++i) {
            mainInventory[i] = inventory.m_8020_(i).m_41777_();
        }
        for (i = 0; i < inventory.f_35975_.size(); ++i) {
            armorInventory[i] = ((ItemStack)inventory.f_35975_.get(i)).m_41777_();
        }
        for (i = 0; i < inventory.f_35976_.size(); ++i) {
            offhandInventory[i] = ((ItemStack)inventory.f_35976_.get(i)).m_41777_();
        }
        for (i = 0; i < player.m_36327_().m_6643_(); ++i) {
            enderChest[i] = player.m_36327_().m_8020_(i).m_41777_();
        }
        return new DataTypes.InventorySnapshot(mainInventory, armorInventory, offhandInventory, enderChest);
    }

    public static boolean inventoriesMatch(DataTypes.InventorySnapshot snapshot, DataTypes.InventorySnapshot current) {
        int i;
        if (snapshot.getMainInventory().length != current.getMainInventory().length) {
            return false;
        }
        for (i = 0; i < snapshot.getMainInventory().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getMainInventory()[i], (ItemStack)current.getMainInventory()[i])) continue;
            return false;
        }
        if (snapshot.getArmorInventory().length != current.getArmorInventory().length) {
            return false;
        }
        for (i = 0; i < snapshot.getArmorInventory().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getArmorInventory()[i], (ItemStack)current.getArmorInventory()[i])) continue;
            return false;
        }
        if (snapshot.getOffhandInventory().length != current.getOffhandInventory().length) {
            return false;
        }
        for (i = 0; i < snapshot.getOffhandInventory().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getOffhandInventory()[i], (ItemStack)current.getOffhandInventory()[i])) continue;
            return false;
        }
        if (snapshot.getEnderChest().length != current.getEnderChest().length) {
            return false;
        }
        for (i = 0; i < snapshot.getEnderChest().length; ++i) {
            if (ItemStack.m_41728_((ItemStack)snapshot.getEnderChest()[i], (ItemStack)current.getEnderChest()[i])) continue;
            return false;
        }
        return true;
    }

    public static void applyNewInventory(ServerPlayer player, DataTypes.InventoryData newInventory) {
        DebugLogger.log("Applying new inventory to player: " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        Map<Integer, DataTypes.ItemData> items = newInventory.getItems();
        for (int i = 0; i < newInventory.getSize(); ++i) {
            DataTypes.ItemData item = items.get(i);
            ItemStack currentStack = player.m_150109_().m_8020_(i);
            if (item != null) {
                boolean shouldUpdate = false;
                ItemStack newItemStack = item.getItemStackData();
                if (currentStack.m_41619_()) {
                    shouldUpdate = !newItemStack.m_41619_();
                } else {
                    String currentItemId = BuiltInRegistries.f_257033_.m_7981_((Object)currentStack.m_41720_()).toString();
                    if (!currentItemId.equals(item.getItemId())) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41613_() != item.getCount().intValue()) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41782_() && item.getNbt() == null || !currentStack.m_41782_() && item.getNbt() != null || currentStack.m_41782_() && item.getNbt() != null && !currentStack.m_41783_().toString().equals(item.getNbt())) {
                        shouldUpdate = true;
                    }
                }
                if (!shouldUpdate) continue;
                player.m_150109_().m_6836_(i, newItemStack);
                DebugLogger.log("Updated slot " + i + " to " + item.getItemId() + " x" + item.getCount(), Config.DebugVerbosity.DEFAULT);
                continue;
            }
            if (currentStack.m_41619_()) continue;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            DebugLogger.log("Cleared slot " + i, Config.DebugVerbosity.DEFAULT);
        }
    }

    public static void applyNewEchest(ServerPlayer player, DataTypes.ContainerData newEchest) {
        DebugLogger.log("Applying new E-Chest to player: " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        Map<Integer, DataTypes.ItemData> items = newEchest.getItems();
        for (int i = 0; i < newEchest.getSize(); ++i) {
            DataTypes.ItemData item = items.get(i);
            ItemStack currentStack = player.m_36327_().m_8020_(i);
            if (item != null) {
                boolean shouldUpdate = false;
                ItemStack newItemStack = item.getItemStackData();
                if (currentStack.m_41619_()) {
                    shouldUpdate = !newItemStack.m_41619_();
                } else {
                    String currentItemId = BuiltInRegistries.f_257033_.m_7981_((Object)currentStack.m_41720_()).toString();
                    if (!currentItemId.equals(item.getItemId())) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41613_() != item.getCount().intValue()) {
                        shouldUpdate = true;
                    } else if (currentStack.m_41782_() && item.getNbt() == null || !currentStack.m_41782_() && item.getNbt() != null || currentStack.m_41782_() && item.getNbt() != null && !currentStack.m_41783_().toString().equals(item.getNbt())) {
                        shouldUpdate = true;
                    }
                }
                if (!shouldUpdate) continue;
                player.m_36327_().m_6836_(i, newItemStack);
                DebugLogger.log("Updated ender chest slot " + i + " to " + item.getItemId() + " x" + item.getCount(), Config.DebugVerbosity.DEFAULT);
                continue;
            }
            if (currentStack.m_41619_()) continue;
            player.m_36327_().m_6836_(i, ItemStack.f_41583_);
            DebugLogger.log("Cleared ender chest slot " + i, Config.DebugVerbosity.DEFAULT);
        }
    }

    public static DataTypes.InventoryDiff generateInventoryDiff(DataTypes.InventorySnapshot original, DataTypes.InventoryData newInventory) {
        return InventoryManager.generateInventoryDiff(original, newInventory, null);
    }

    public static DataTypes.InventoryDiff generateInventoryDiff(DataTypes.InventorySnapshot original, DataTypes.InventoryData newInventory, DataTypes.ContainerData newEchest) {
        Object itemKey;
        DebugLogger.log("Generating inventory diff", Config.DebugVerbosity.MINIMAL);
        DataTypes.InventoryDiff diff = new DataTypes.InventoryDiff();
        Map<Integer, DataTypes.ItemData> newItems = newInventory.getItems();
        HashMap<String, Integer> originalItemCounts = new HashMap<String, Integer>();
        for (int i = 0; i < original.getMainInventory().length; ++i) {
            ItemStack stack = original.getMainInventory()[i];
            if (stack.m_41619_()) continue;
            String itemKey2 = InventoryManager.getItemKey(stack);
            originalItemCounts.put(itemKey2, originalItemCounts.getOrDefault(itemKey2, 0) + stack.m_41613_());
        }
        for (ItemStack stack : original.getArmorInventory()) {
            if (stack.m_41619_()) continue;
            itemKey = InventoryManager.getItemKey(stack);
            originalItemCounts.put((String)itemKey, originalItemCounts.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        for (ItemStack stack : original.getOffhandInventory()) {
            if (stack.m_41619_()) continue;
            itemKey = InventoryManager.getItemKey(stack);
            originalItemCounts.put((String)itemKey, originalItemCounts.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        for (ItemStack stack : original.getEnderChest()) {
            if (stack.m_41619_()) continue;
            itemKey = InventoryManager.getItemKey(stack);
            originalItemCounts.put((String)itemKey, originalItemCounts.getOrDefault(itemKey, 0) + stack.m_41613_());
        }
        HashMap<String, Integer> newItemCounts = new HashMap<String, Integer>();
        for (int i = 0; i < newInventory.getSize(); ++i) {
            DataTypes.ItemData itemData = newItems.get(i);
            if (itemData == null) continue;
            Object itemKey3 = itemData.getItemId();
            if (itemData.getNbt() != null && !itemData.getNbt().isEmpty()) {
                itemKey3 = (String)itemKey3 + ":" + itemData.getNbt();
            }
            newItemCounts.put((String)itemKey3, newItemCounts.getOrDefault(itemKey3, 0) + itemData.getCount());
        }
        if (newEchest != null) {
            Map<Integer, DataTypes.ItemData> newEchestItems = newEchest.getItems();
            for (int i = 0; i < newEchest.getSize(); ++i) {
                DataTypes.ItemData itemData = newEchestItems.get(i);
                if (itemData == null) continue;
                itemKey = itemData.getItemId();
                if (itemData.getNbt() != null && !itemData.getNbt().isEmpty()) {
                    itemKey = (String)itemKey + ":" + itemData.getNbt();
                }
                newItemCounts.put((String)itemKey, newItemCounts.getOrDefault(itemKey, 0) + itemData.getCount());
            }
        }
        HashSet allItems = new HashSet();
        allItems.addAll(originalItemCounts.keySet());
        allItems.addAll(newItemCounts.keySet());
        for (Object itemKey3 : allItems) {
            int originalCount = originalItemCounts.getOrDefault(itemKey3, 0);
            int newCount = newItemCounts.getOrDefault(itemKey3, 0);
            int diff_count = newCount - originalCount;
            if (diff_count == 0) continue;
            Object itemId = itemKey3;
            if (((String)itemKey3).contains(":nbt")) {
                itemId = ((String)itemKey3).substring(0, ((String)itemKey3).indexOf(":nbt"));
            }
            if (diff_count > 0) {
                diff.addItem((String)itemId, diff_count);
                continue;
            }
            diff.removeItem((String)itemId, -diff_count);
        }
        return diff;
    }

    private static String getItemKey(ItemStack stack) {
        Object itemKey = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        if (stack.m_41782_()) {
            itemKey = (String)itemKey + ":" + stack.m_41783_().toString();
        }
        return itemKey;
    }

    public static int removeMoneyItems(Player player) {
        ItemStack stack;
        int i;
        int removed = 0;
        Inventory inventory = player.m_150109_();
        PlayerEnderChestContainer echest = player.m_36327_();
        DebugLogger.log("Checking for money items to remove from player: " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        for (i = 0; i < inventory.m_6643_(); ++i) {
            stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !Config.moneyItems.contains(stack.m_41720_())) continue;
            DebugLogger.log("Removing money item: " + stack.m_41720_().m_41466_().getString() + " x" + stack.m_41613_() + " from Inventory slot " + i, Config.DebugVerbosity.DEFAULT);
            removed += stack.m_41613_();
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
        for (i = 0; i < echest.m_6643_(); ++i) {
            stack = echest.m_8020_(i);
            if (stack.m_41619_() || !Config.moneyItems.contains(stack.m_41720_())) continue;
            DebugLogger.log("Removing money item: " + stack.m_41720_().m_41466_().getString() + " x" + stack.m_41613_() + " from E-Chest slot " + i, Config.DebugVerbosity.DEFAULT);
            removed += stack.m_41613_();
            echest.m_6836_(i, ItemStack.f_41583_);
        }
        DebugLogger.log("Removed " + removed + " money items from player " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        return removed;
    }
}

