/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import info.rusty.webshoplink.Config;
import info.rusty.webshoplink.DebugLogger;
import info.rusty.webshoplink.NbtSerializer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class NbtDebugUtils {
    private static final Gson PRETTY_GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(CompoundTag.class, (Object)new NbtSerializer.CompoundTagAdapter()).create();

    public static void logNbtDetails(CompoundTag tag, String label) {
        if (tag == null) {
            DebugLogger.log(label + " NBT: null", Config.DebugVerbosity.DEFAULT);
            return;
        }
        DebugLogger.log(label + " Original NBT: " + tag.toString(), Config.DebugVerbosity.DEFAULT);
        JsonElement jsonElement = NbtSerializer.serializeNbt(tag);
        String prettyJson = PRETTY_GSON.toJson(jsonElement);
        DebugLogger.log(label + " JSON representation:\n" + prettyJson, Config.DebugVerbosity.DEFAULT);
        DebugLogger.log(label + " NBT keys: " + String.valueOf(tag.m_128431_()), Config.DebugVerbosity.DEFAULT);
    }

    public static void logItemStackNbt(ItemStack stack, String label) {
        if (stack == null || stack.m_41619_()) {
            DebugLogger.log(label + ": Empty or null ItemStack", Config.DebugVerbosity.DEFAULT);
            return;
        }
        String itemId = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString();
        DebugLogger.log(label + ": Item ID = " + itemId + ", Count = " + stack.m_41613_(), Config.DebugVerbosity.DEFAULT);
        if (stack.m_41782_()) {
            NbtDebugUtils.logNbtDetails(stack.m_41783_(), label);
        } else {
            DebugLogger.log(label + ": No NBT data", Config.DebugVerbosity.DEFAULT);
        }
    }

    public static void logJsonNbt(JsonObject nbt, String label) {
        if (nbt == null) {
            DebugLogger.log(label + " NBT JSON: null", Config.DebugVerbosity.DEFAULT);
            return;
        }
        String prettyJson = PRETTY_GSON.toJson((JsonElement)nbt);
        DebugLogger.log(label + " NBT JSON:\n" + prettyJson, Config.DebugVerbosity.DEFAULT);
        DebugLogger.log(label + " NBT JSON keys: " + String.valueOf(nbt.keySet()), Config.DebugVerbosity.DEFAULT);
        try {
            CompoundTag tag = NbtSerializer.CompoundTagAdapter.parseJsonToCompoundTag(nbt);
            DebugLogger.log(label + " Converted back to NBT: " + tag.toString(), Config.DebugVerbosity.DEFAULT);
            DebugLogger.log(label + " Converted NBT keys: " + String.valueOf(tag.m_128431_()), Config.DebugVerbosity.DEFAULT);
            JsonObject reconvertedJson = (JsonObject)NbtSerializer.serializeNbt(tag);
            boolean isEqual = nbt.equals((Object)reconvertedJson);
            DebugLogger.log(label + " Round-trip conversion test: " + (isEqual ? "CONSISTENT" : "INCONSISTENT"), Config.DebugVerbosity.DEFAULT);
            if (!isEqual) {
                DebugLogger.log(label + " Original and reconverted JSON differ. This might be the source of NBT loss.", Config.DebugVerbosity.DEFAULT);
                String reconvertedPretty = PRETTY_GSON.toJson((JsonElement)reconvertedJson);
                DebugLogger.log(label + " Reconverted JSON:\n" + reconvertedPretty, Config.DebugVerbosity.ALL);
            }
        }
        catch (Exception e) {
            DebugLogger.logError(label + " Failed to convert JSON to NBT: " + e.getMessage(), e);
        }
    }
}

