/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtSerializer {
    public static JsonElement serializeNbt(CompoundTag tag) {
        if (tag == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        Set keys = tag.m_128431_();
        for (String key : keys) {
            Tag value = tag.m_128423_(key);
            jsonObject.add(key, NbtSerializer.serializeNbtValue(value));
        }
        return jsonObject;
    }

    private static JsonElement serializeNbtValue(Tag tag) {
        if (tag instanceof CompoundTag) {
            return NbtSerializer.serializeNbt((CompoundTag)tag);
        }
        if (tag instanceof ListTag) {
            return NbtSerializer.serializeNbtList((ListTag)tag);
        }
        if (tag instanceof StringTag) {
            return new JsonPrimitive(((StringTag)tag).m_7916_());
        }
        if (tag instanceof IntTag) {
            return new JsonPrimitive((Number)((IntTag)tag).m_7047_());
        }
        if (tag instanceof LongTag) {
            return new JsonPrimitive((Number)((LongTag)tag).m_7046_());
        }
        if (tag instanceof DoubleTag) {
            return new JsonPrimitive((Number)((DoubleTag)tag).m_7061_());
        }
        if (tag instanceof FloatTag) {
            return new JsonPrimitive((Number)Float.valueOf(((FloatTag)tag).m_7057_()));
        }
        if (tag instanceof ShortTag) {
            return new JsonPrimitive((Number)((ShortTag)tag).m_7053_());
        }
        if (tag instanceof ByteTag) {
            return new JsonPrimitive((Number)((ByteTag)tag).m_7063_());
        }
        if (tag instanceof ByteArrayTag) {
            byte[] array = ((ByteArrayTag)tag).m_128227_();
            JsonArray jsonArray = new JsonArray();
            for (byte b : array) {
                jsonArray.add((Number)b);
            }
            return jsonArray;
        }
        if (tag instanceof IntArrayTag) {
            int[] array = ((IntArrayTag)tag).m_128648_();
            JsonArray jsonArray = new JsonArray();
            for (int i : array) {
                jsonArray.add((Number)i);
            }
            return jsonArray;
        }
        if (tag instanceof LongArrayTag) {
            long[] array = ((LongArrayTag)tag).m_128851_();
            JsonArray jsonArray = new JsonArray();
            for (long l : array) {
                jsonArray.add((Number)l);
            }
            return jsonArray;
        }
        return new JsonPrimitive(tag.toString());
    }

    private static JsonArray serializeNbtList(ListTag listTag) {
        JsonArray jsonArray = new JsonArray();
        for (int i = 0; i < listTag.size(); ++i) {
            Tag element = listTag.get(i);
            jsonArray.add(NbtSerializer.serializeNbtValue(element));
        }
        return jsonArray;
    }

    public static class CompoundTagAdapter
    implements JsonSerializer<CompoundTag>,
    JsonDeserializer<CompoundTag> {
        public JsonElement serialize(CompoundTag tag, Type typeOfSrc, JsonSerializationContext context) {
            return NbtSerializer.serializeNbt(tag);
        }

        public CompoundTag deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                return CompoundTagAdapter.parseJsonToCompoundTag(json.getAsJsonObject());
            }
            throw new JsonParseException("Expected JsonObject for CompoundTag, got: " + String.valueOf(json));
        }

        public static CompoundTag parseJsonToCompoundTag(JsonObject jsonObject) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonObject()) {
                    tag.m_128365_(key, (Tag)CompoundTagAdapter.parseJsonToCompoundTag(value.getAsJsonObject()));
                    continue;
                }
                if (value.isJsonArray()) {
                    tag.m_128365_(key, (Tag)CompoundTagAdapter.parseJsonToListTag(value.getAsJsonArray()));
                    continue;
                }
                if (!value.isJsonPrimitive()) continue;
                JsonPrimitive primitive = value.getAsJsonPrimitive();
                if (primitive.isString()) {
                    tag.m_128359_(key, primitive.getAsString());
                    continue;
                }
                if (primitive.isNumber()) {
                    Number number = primitive.getAsNumber();
                    if (number.toString().contains(".")) {
                        tag.m_128347_(key, number.doubleValue());
                        continue;
                    }
                    long longValue = number.longValue();
                    if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                        tag.m_128405_(key, number.intValue());
                        continue;
                    }
                    tag.m_128356_(key, longValue);
                    continue;
                }
                if (!primitive.isBoolean()) continue;
                tag.m_128379_(key, primitive.getAsBoolean());
            }
            return tag;
        }

        public static ListTag parseJsonToListTag(JsonArray jsonArray) {
            if (jsonArray.size() == 0) {
                return new ListTag();
            }
            ListTag listTag = new ListTag();
            for (JsonElement element : jsonArray) {
                if (element.isJsonObject()) {
                    listTag.add((Object)CompoundTagAdapter.parseJsonToCompoundTag(element.getAsJsonObject()));
                    continue;
                }
                if (element.isJsonArray()) {
                    listTag.add((Object)CompoundTagAdapter.parseJsonToListTag(element.getAsJsonArray()));
                    continue;
                }
                if (!element.isJsonPrimitive()) continue;
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isString()) {
                    listTag.add((Object)StringTag.m_129297_((String)primitive.getAsString()));
                    continue;
                }
                if (primitive.isNumber()) {
                    Number number = primitive.getAsNumber();
                    if (number.toString().contains(".")) {
                        listTag.add((Object)DoubleTag.m_128500_((double)number.doubleValue()));
                        continue;
                    }
                    long longValue = number.longValue();
                    if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                        listTag.add((Object)IntTag.m_128679_((int)number.intValue()));
                        continue;
                    }
                    listTag.add((Object)LongTag.m_128882_((long)longValue));
                    continue;
                }
                if (!primitive.isBoolean()) continue;
                listTag.add((Object)ByteTag.m_128266_((byte)(primitive.getAsBoolean() ? (byte)1 : 0)));
            }
            return listTag;
        }
    }
}

