/*
 * Decompiled with CFR 0.152.
 */
package info.rusty.webshoplink;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import info.rusty.webshoplink.ApiService;
import info.rusty.webshoplink.Config;
import info.rusty.webshoplink.DataTypes;
import info.rusty.webshoplink.DebugLogger;
import info.rusty.webshoplink.InventoryManager;
import info.rusty.webshoplink.UIUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class ShopCommands {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, DataTypes.ShopProcess> ACTIVE_SHOP_PROCESSES = new ConcurrentHashMap<UUID, DataTypes.ShopProcess>();

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        LOGGER.info("Registering shop commands");
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shop").requires(source -> source.m_6761_(0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).executes(context -> ShopCommands.executeShopCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"), "Trader"))).then(Commands.m_82129_((String)"label", (ArgumentType)StringArgumentType.greedyString()).executes(context -> ShopCommands.executeShopCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"label"))))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"shopFinish").requires(source -> source.m_6761_(0))).then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> ShopCommands.executeShopFinishCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"uuid")))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"confirmFinish").requires(source -> source.m_6761_(0))).then(Commands.m_82129_((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(context -> ShopCommands.executeConfirmFinishCommand((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"uuid")))));
    }

    private static int executeShopCommand(CommandSourceStack source, String shopSlug, String shopLabel) {
        String finalShopLabel;
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (shopLabel.length() > 40) {
            finalShopLabel = shopLabel.substring(0, 40);
            DebugLogger.log("Shop label truncated to 40 characters for player " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
        } else {
            finalShopLabel = shopLabel;
        }
        DebugLogger.log("Player " + player.m_7755_().getString() + " executed shop command with slug: " + shopSlug + ", label: " + finalShopLabel, Config.DebugVerbosity.MINIMAL);
        DataTypes.InventorySnapshot inventorySnapshot = InventoryManager.captureInventory((Player)player);
        DataTypes.InventoryList inventories = new DataTypes.InventoryList();
        inventories.setInventoryFromPlayer(player.m_150109_());
        inventories.setEchestFromPlayer((Container)player.m_36327_());
        DebugLogger.log("Captured inventory for player " + player.m_7755_().getString() + ": " + GSON.toJson((Object)inventories, DataTypes.InventoryList.class), Config.DebugVerbosity.ALL);
        ((CompletableFuture)ApiService.initiateShop(player.m_20148_(), player.m_7755_().getString(), shopSlug, inventories).thenAccept(shopResponse -> {
            try {
                UUID processId = UUID.fromString(shopResponse.getUuid());
                DataTypes.ShopProcess shopProcess = new DataTypes.ShopProcess(player.m_20148_(), processId, inventorySnapshot, finalShopLabel);
                ACTIVE_SHOP_PROCESSES.put(processId, shopProcess);
                shopProcess.setWebLink(shopResponse.getLink());
                shopProcess.setTwoFactorCode(shopResponse.getTwoFactorCode());
                Component headerComponent = UIUtils.createShopBorder(shopProcess.getShopLabel(), true);
                Component footerComponent = UIUtils.createShopBorder("", false);
                MutableComponent spacerComponent = Component.m_237113_((String)"");
                MutableComponent openShopComponent = Component.m_237113_((String)"1. ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)">>>> Open Shop <<<<").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, shopResponse.getLink())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Open the shop in your browser")))));
                MutableComponent instructionsComponent = Component.m_237113_((String)"2. Make your Purchases in the Browser").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
                MutableComponent finishComponent = Component.m_237113_((String)"3. ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)">>>> Finish Trade <<<<").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/shopFinish " + shopResponse.getUuid())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to complete purchase")))));
                player.m_213846_((Component)spacerComponent);
                player.m_213846_(headerComponent);
                player.m_213846_((Component)openShopComponent);
                player.m_213846_((Component)instructionsComponent);
                player.m_213846_((Component)finishComponent);
                player.m_213846_(footerComponent);
                player.m_213846_((Component)spacerComponent);
                int removedItems = InventoryManager.removeMoneyItems((Player)player);
                if (removedItems > 0) {
                    player.m_213846_((Component)Component.m_237113_((String)("Removed " + removedItems + " money items from your Inventory and Ender Chest.")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
                    DebugLogger.log("Removed " + removedItems + " money items from player " + player.m_7755_().getString());
                }
            }
            catch (Exception e) {
                DebugLogger.logError("Error processing shop response", e);
                player.m_213846_((Component)Component.m_237113_((String)"Error processing shop response. Please try again later."));
            }
        })).exceptionally(e -> {
            DebugLogger.logError("Error connecting to shop API", e);
            player.m_213846_((Component)Component.m_237113_((String)"Error connecting to shop. Please try again later."));
            return null;
        });
        return 1;
    }

    private static int executeShopFinishCommand(CommandSourceStack source, String uuidString) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        try {
            UUID processId = UUID.fromString(uuidString);
            DataTypes.ShopProcess shopProcess = ACTIVE_SHOP_PROCESSES.get(processId);
            DebugLogger.log("Player " + player.m_7755_().getString() + " executing shopFinish command for process: " + String.valueOf(processId), Config.DebugVerbosity.MINIMAL);
            if (shopProcess == null || !shopProcess.getPlayerId().equals(player.m_20148_())) {
                DebugLogger.log("No active shopping process found for player " + player.m_7755_().getString() + " with ID: " + String.valueOf(processId));
                player.m_213846_((Component)Component.m_237113_((String)"No active shopping process found for that ID."));
                return 0;
            }
            ((CompletableFuture)ApiService.finishShop(processId, player.m_7755_().getString(), shopProcess.getTwoFactorCode()).thenAccept(newInventoryList -> {
                try {
                    DataTypes.InventoryData inventoryData = newInventoryList.getInventoryData();
                    DataTypes.ContainerData echestData = newInventoryList.getEnderChestData();
                    if (inventoryData == null) {
                        DebugLogger.logError("Failed to parse inventory data from response", null);
                        player.m_213846_((Component)Component.m_237113_((String)"Error processing shop finish response. Please try again later."));
                        return;
                    }
                    shopProcess.setNewInventory(inventoryData);
                    shopProcess.setNewEchest(echestData);
                    DebugLogger.log("Successfully stored new inventory for player " + player.m_7755_().getString() + ", process: " + String.valueOf(processId));
                    MutableComponent spacerComponent = Component.m_237113_((String)"");
                    Component headerComponent = UIUtils.createShopBorder("Confirm Checkout", true);
                    Component footerComponent = UIUtils.createShopBorder("", false);
                    MutableComponent confirmComponent = Component.m_237113_((String)">>>> ").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)"Confirm and Apply Changes").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/confirmFinish " + String.valueOf(processId))).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to confirm purchase"))))).m_7220_((Component)Component.m_237113_((String)" <<<<").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
                    player.m_213846_(headerComponent);
                    player.m_213846_((Component)confirmComponent);
                    player.m_213846_(footerComponent);
                    player.m_213846_((Component)spacerComponent);
                }
                catch (Exception e) {
                    DebugLogger.logError("Error processing shop finish response", e);
                    player.m_213846_((Component)Component.m_237113_((String)"Error processing shop finish response. Please try again later."));
                }
            })).exceptionally(e -> {
                DebugLogger.logError("Error connecting to shop finish API", e);
                player.m_213846_((Component)Component.m_237113_((String)"Error connecting to shop. Please try again later."));
                return null;
            });
        }
        catch (IllegalArgumentException e2) {
            DebugLogger.logError("Invalid UUID format in shopFinish command: " + uuidString, e2);
            player.m_213846_((Component)Component.m_237113_((String)"Invalid UUID format. Please use the UUID provided in the shop link."));
            return 0;
        }
        return 1;
    }

    private static int executeConfirmFinishCommand(CommandSourceStack source, String uuidString) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        try {
            UUID processId = UUID.fromString(uuidString);
            DataTypes.ShopProcess shopProcess = ACTIVE_SHOP_PROCESSES.get(processId);
            DebugLogger.log("Player " + player.m_7755_().getString() + " confirming shop process: " + String.valueOf(processId));
            if (shopProcess == null || !shopProcess.getPlayerId().equals(player.m_20148_())) {
                DebugLogger.log("No active shopping process found for player " + player.m_7755_().getString() + " with ID: " + String.valueOf(processId));
                player.m_213846_((Component)Component.m_237113_((String)"No active shopping process found with that ID."));
                return 0;
            }
            if (!InventoryManager.inventoriesMatch(shopProcess.getOriginalInventory(), InventoryManager.captureInventory((Player)player))) {
                DebugLogger.log("Inventory changed for player " + player.m_7755_().getString() + ", purchase cancelled", Config.DebugVerbosity.MINIMAL);
                player.m_213846_((Component)Component.m_237113_((String)"Your inventory has changed since starting the shop process. Purchase cancelled."));
                ACTIVE_SHOP_PROCESSES.remove(processId);
                return 0;
            }
            ((CompletableFuture)ApiService.notifyChangesApplied(processId, shopProcess.getTwoFactorCode()).thenAccept(success -> {
                if (success.booleanValue()) {
                    InventoryManager.applyNewInventory(player, shopProcess.getNewInventory());
                    InventoryManager.applyNewEchest(player, shopProcess.getNewEchest());
                    DebugLogger.log("Applied inventory changes to player " + player.m_7755_().getString(), Config.DebugVerbosity.MINIMAL);
                    DebugLogger.log("Applied inventory changes from session " + String.valueOf(processId) + " to player " + player.m_7755_().getString());
                    MutableComponent spacerComponent = Component.m_237113_((String)"");
                    Component headerComponent = UIUtils.createShopBorder(shopProcess.getShopLabel(), true);
                    MutableComponent successComponent = Component.m_237113_((String)"Purchase completed successfully!").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN));
                    Component footerComponent = UIUtils.createShopBorder("", false);
                    player.m_213846_((Component)spacerComponent);
                    player.m_213846_(headerComponent);
                    player.m_213846_((Component)successComponent);
                    player.m_213846_(footerComponent);
                    player.m_213846_((Component)spacerComponent);
                    DebugLogger.log("Purchase completed successfully for player " + player.m_7755_().getString() + ", process: " + String.valueOf(processId), Config.DebugVerbosity.MINIMAL);
                    ACTIVE_SHOP_PROCESSES.remove(processId);
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Purchase verification failed. Please try again later.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                    DebugLogger.logError("API verification failed for process: " + String.valueOf(processId), null);
                }
            })).exceptionally(e -> {
                DebugLogger.logError("Error notifying API of applied changes", e);
                player.m_213846_((Component)Component.m_237113_((String)"Error completing purchase. Please try again later.").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                return null;
            });
        }
        catch (IllegalArgumentException e2) {
            DebugLogger.logError("Invalid UUID format in confirmFinish command: " + uuidString, e2);
            player.m_213846_((Component)Component.m_237113_((String)"Invalid UUID format. Please use the UUID provided in the shop link."));
            return 0;
        }
        return 1;
    }
}

