/*
 * Decompiled with CFR 0.152.
 */
package com.KanasakiTechnologics.CreateFactory.content;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public class FactoryTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return FactoryTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static <T> TagKey<T> minecraftTag(Registry<T> registry, String path) {
        return FactoryTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)path));
    }

    public static <T> TagKey<T> modTag(Registry<T> registry, String path) {
        return FactoryTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"createfactory", (String)path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return FactoryTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return FactoryTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Item> minecraftItemTag(String path) {
        return FactoryTags.minecraftTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return FactoryTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static TagKey<Block> modBlockTag(String path) {
        return FactoryTags.modTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> modItemTag(String path) {
        return FactoryTags.modTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> modFluidTag(String path) {
        return FactoryTags.modTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        BlockTags.init();
    }

    public static enum BlockTags {
        CREATE_WRENCH_PICKUP(NameSpace.CREATE, "wrench_pickup"),
        COLORED_GLASS(NameSpace.MOD, "colored_glass"),
        COLOURED_CONCRETE(NameSpace.MOD, "colored_concrete");

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private BlockTags() {
            this(NameSpace.MOD);
        }

        private BlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private BlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private BlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? this.name().toLowerCase() : path));
            this.tag = optional ? FactoryTags.optionalTag(BuiltInRegistries.BLOCK, id) : net.minecraft.tags.BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean is(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean is(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.is((blockItem = (BlockItem)item).getBlock());
        }

        public boolean is(ItemLike item) {
            BlockItem blockItem;
            return item instanceof BlockItem && this.is((blockItem = (BlockItem)item).getBlock());
        }

        public boolean is(BlockState state) {
            return state.is(this.tag);
        }

        public boolean is(TagKey<Block> tag) {
            return tag == this.tag;
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("createfactory", false, true),
        COMMON("c"),
        CREATE("create"),
        NEOFORGE("neoforge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

