/*
 * Decompiled with CFR 0.152.
 */
package com.KanasakiTechnologics.CreateFactory.datagen;

import com.KanasakiTechnologics.CreateFactory.datagen.FactoryBlockStateProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.FactoryBlockTagProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.FactoryItemStateProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.FactoryLootTableProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.FactoryRecipeProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.create.FactoryCompactingProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.create.FactoryMixingProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.create.FactoryPolishingProvider;
import com.KanasakiTechnologics.CreateFactory.datagen.create.FactorySequenceAssemblyProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="createfactory", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new FactoryItemStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new FactoryBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new FactoryRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new FactoryPolishingProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new FactorySequenceAssemblyProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new FactoryMixingProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new FactoryCompactingProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(FactoryLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        FactoryBlockTagProvider blockTagsProvider = new FactoryBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
    }
}

