/*
 * Decompiled with CFR 0.152.
 */
package com.madu59;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.madu59.PickUpWarning;
import com.madu59.PickUpWarningUtils;
import com.madu59.config.SettingsManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5218;
import net.minecraft.class_5348;
import net.minecraft.class_642;
import net.minecraft.class_7923;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class FreshLootHighlightClient
implements ClientModInitializer {
    private static final class_310 CLIENT = class_310.method_1551();
    public static List<Integer> freshSlots = new ArrayList<Integer>();
    public static List<PickUpWarning> pickUpMessages = new ArrayList<PickUpWarning>();
    public static String serverId = "NoWorldOrServer";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static List<class_2960> alreadyFound = new ArrayList<class_2960>();
    public static List<class_2960> foundForTheFirstTime = new ArrayList<class_2960>();

    public void onInitializeClient() {
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.CHAT, (class_2960)class_2960.method_60655((String)"fresh-loot-highlight", (String)"pick_up_warning_hud"), FreshLootHighlightClient::render);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            class_642 info;
            serverId = CLIENT.method_1576() == null ? ((info = CLIENT.method_1558()) != null ? info.field_3761.replace(":", "_") : "unknown_server") : CLIENT.method_1576().method_27050(class_5218.field_24188).getParent().getFileName().toString();
            FreshLootHighlightClient.loadAlreadyFound();
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            class_1661 inv = client.field_1724.method_31548();
            if (inv == null) {
                return;
            }
            if (freshSlots.contains(inv.method_67532())) {
                freshSlots.remove((Object)inv.method_67532());
                foundForTheFirstTime.remove(class_7923.field_41178.method_10221((Object)inv.method_7391().method_7909()));
            }
            if (freshSlots.contains(36)) {
                freshSlots.remove((Object)36);
            }
            Iterator<Integer> slotsIterator = freshSlots.iterator();
            while (slotsIterator.hasNext()) {
                int slotId = slotsIterator.next();
                if (!inv.method_5438(slotId).method_7960() && slotId != -1) continue;
                slotsIterator.remove();
            }
            Iterator<PickUpWarning> messagesIterator = pickUpMessages.iterator();
            int delay = PickUpWarningUtils.getDelay(SettingsManager.PICKUP_WARNING_TIMEOUT.getValueAsString());
            while (messagesIterator.hasNext()) {
                if (FreshLootHighlightClient.CLIENT.field_1705.method_1738() <= delay + messagesIterator.next().creationTick) continue;
                messagesIterator.remove();
            }
        });
    }

    public static void onPickUpEvent(class_1799 pickedUpItemStack) {
        if (FreshLootHighlightClient.CLIENT.field_1724 == null) {
            return;
        }
        class_1661 inv = FreshLootHighlightClient.CLIENT.field_1724.method_31548();
        int count = pickedUpItemStack.method_7947();
        class_1792 item = pickedUpItemStack.method_7909();
        if (Boolean.TRUE.equals(SettingsManager.ENABLE_PICKUP_WARNING.getValue())) {
            pickUpMessages = PickUpWarningUtils.AddOrEditMessage(pickedUpItemStack, pickUpMessages);
        }
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7909() != pickedUpItemStack.method_7909() || (count -= stack.method_7914() - stack.method_7947()) >= 0) continue;
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (alreadyFound.contains(itemId) && Boolean.TRUE.equals(SettingsManager.ENABLE_SLOT_HIGHLIGHTER.getValue())) {
            freshSlots.add(inv.method_7376());
        } else if (!Boolean.FALSE.equals(SettingsManager.ENABLE_SLOT_HIGHLIGHTER.getValue())) {
            alreadyFound.add(itemId);
            freshSlots.add(inv.method_7376());
            foundForTheFirstTime.add(itemId);
            FreshLootHighlightClient.saveAlreadyFound();
        }
    }

    private static void render(class_332 context, class_9779 tickCounter) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int entryX = 0;
        int entryY = 0;
        int tileSizeY = 11;
        boolean isAlignedLeft = false;
        String position = SettingsManager.PICKUP_WARNING_HUD_POSITION.getValueAsString();
        if (position.equals("BOTTOM_RIGHT")) {
            entryY = context.method_51443() - tileSizeY * pickUpMessages.size();
        }
        if (position.equals("BOTTOM_RIGHT") || position.equals("TOP_RIGHT")) {
            isAlignedLeft = true;
        }
        for (PickUpWarning pickUpWarning : pickUpMessages) {
            int entryWidth = textRenderer.method_27525((class_5348)pickUpWarning.message);
            class_2960 textureId = pickUpWarning.textureId;
            boolean showItem = (Boolean)SettingsManager.PICKUP_WARNING_HUD_SHOW_ITEM.getValue();
            if (showItem && textureId == null) {
                textureId = PickUpWarningUtils.getItemTexture(pickUpWarning.item);
            }
            entryX = isAlignedLeft ? context.method_51421() - entryWidth : 0;
            context.method_25294(entryX, entryY, entryX + entryWidth + (showItem ? 11 : 0), entryY + tileSizeY, -1728053248);
            if (showItem) {
                context.method_25290(class_10799.field_56883, textureId, entryX + 2, entryY + 2, 0.0f, 0.0f, 7, 7, 7, 7);
            }
            class_2561 class_25612 = pickUpWarning.message;
            int n = entryX + (showItem ? 11 : 0);
            Objects.requireNonNull(textRenderer);
            context.method_51439(textRenderer, class_25612, n, entryY + (tileSizeY - 9) / 2 + 1, -1, false);
            entryY += tileSizeY;
        }
    }

    public static void saveAlreadyFound() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve(serverId).resolve("fresh-loot-highlight.json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                GSON.toJson(alreadyFound.stream().map(class_2960::toString).toList(), (Appendable)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadAlreadyFound() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve(serverId).resolve("fresh-loot-highlight.json");
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Type listType = new TypeToken<List<String>>(){}.getType();
            List raw = (List)GSON.fromJson((Reader)reader, listType);
            alreadyFound = new ArrayList<class_2960>(raw.stream().map(class_2960::method_60654).toList());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

