/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59;

import fr.madu59.NarratorUtils;
import fr.madu59.PickUpWarning;
import fr.madu59.config.SettingsManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class PickUpWarningUtils {
    private static final String[] POSSIBLE_PATHS = new String[]{"textures/item/%s.png", "textures/block/%s.png", "textures/block/%s_front.png", "textures/block/%s_empty.png", "textures/block/%s_side.png", "textures/block/%s_top.png"};
    private static final Map<String, String> CONVERTION_LAYER_MAP = Map.ofEntries(Map.entry("wood", "log"), Map.entry("oak", "oak_planks"), Map.entry("pale_oak", "pale_oak_planks"), Map.entry("spruce", "spruce_planks"), Map.entry("birch", "birch_planks"), Map.entry("jungle", "jungle_planks"), Map.entry("acacia", "acacia_planks"), Map.entry("dark_oak", "dark_oak_planks"), Map.entry("mangrove", "mangrove_planks"), Map.entry("cherry", "cherry_planks"), Map.entry("bamboo", "bamboo_planks"), Map.entry("crimson", "crimson_planks"), Map.entry("warped", "warped_planks"), Map.entry("moss", "moss_block"));
    private static final class_2960 NULL_IDENTIFIER = class_2960.method_60654((String)"null");
    private static final Set<class_2960> dynamicTextures = new HashSet<class_2960>();

    public static class_2561 createMessage(class_1799 itemStack) {
        return PickUpWarningUtils.createMessage(itemStack.method_7909().method_63680(), itemStack.method_7947(), false);
    }

    public static class_2561 createMessage(class_1792 item, int count) {
        return PickUpWarningUtils.createMessage(item.method_63680(), count, false);
    }

    public static class_2561 createMessage(class_2561 name, int count) {
        return PickUpWarningUtils.createMessage(name, count, false);
    }

    public static class_2561 createMessage(class_2561 name, int count, boolean forceLong) {
        if (forceLong || SettingsManager.PICKUP_WARNING_STYLE.getValueAsString().equals("Long")) {
            return class_2561.method_43471((String)"fresh-loot-highlight.picked-up-message").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count))).method_27693(" ").method_10852(name);
        }
        return class_2561.method_43470((String)"> ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(count))).method_27693(" ").method_10852(name);
    }

    public static List<PickUpWarning> AddOrEditMessage(class_1799 itemStack, List<PickUpWarning> messages) {
        int count = itemStack.method_7947();
        class_2561 name = itemStack.method_63693();
        class_1792 item = itemStack.method_7909();
        if (!SettingsManager.ENABLE_PICKUP_WARNING_GROUPING.getValueAsString().equals("Never")) {
            int id = 0;
            int maxDelay = PickUpWarningUtils.getDelay(SettingsManager.ENABLE_PICKUP_WARNING_GROUPING.getValueAsString());
            for (PickUpWarning warning : messages) {
                if (PickUpWarningUtils.isMessageOfSameItem(warning, name) && class_310.method_1551().field_1705.method_1738() < warning.creationTick + maxDelay) {
                    messages.remove(id);
                    messages.add(new PickUpWarning(item, count += PickUpWarningUtils.extractCountFromMessage(warning.message)));
                    if (Boolean.TRUE.equals(SettingsManager.ENABLE_PICK_UP_WARNING_NARRATOR.getValue())) {
                        NarratorUtils.narrate(PickUpWarningUtils.createMessage(item.method_63680(), count, true));
                    }
                    return messages;
                }
                ++id;
            }
        }
        messages.add(new PickUpWarning(item, count));
        if (Boolean.TRUE.equals(SettingsManager.ENABLE_PICK_UP_WARNING_NARRATOR.getValue())) {
            NarratorUtils.narrate(PickUpWarningUtils.createMessage(item.method_63680(), count, true));
        }
        return messages;
    }

    public static boolean isMessageOfSameItem(PickUpWarning warning, class_2561 itemName) {
        List siblings = warning.message.method_10855();
        return siblings.size() == 3 && siblings.getLast() == itemName;
    }

    public static int extractCountFromMessage(class_2561 message) {
        List siblings = message.method_10855();
        return Integer.parseInt(((class_2561)siblings.get(0)).getString());
    }

    public static int getDelay(String setting) {
        int maxDelay = 200;
        if (setting.equals("5s")) {
            maxDelay = 100;
        } else if (setting.equals("3s")) {
            maxDelay = 60;
        }
        return maxDelay;
    }

    public static class_2960 getItemTexture(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        class_2960 iconId = PickUpWarningUtils.tryToFind2DTexture(itemId);
        if (iconId != NULL_IDENTIFIER) {
            return iconId;
        }
        String itemType = PickUpWarningUtils.getItemType(itemId);
        String itemMaterial = PickUpWarningUtils.getItemMaterial(itemId);
        String convertedItemType = PickUpWarningUtils.convertionLayer(itemType);
        iconId = PickUpWarningUtils.tryToFind2DTexture("minecraft", itemMaterial + "_side");
        if (iconId != NULL_IDENTIFIER) {
            return iconId;
        }
        iconId = PickUpWarningUtils.tryToFind2DTexture("minecraft", itemMaterial + "_top");
        if (iconId != NULL_IDENTIFIER) {
            return iconId;
        }
        iconId = PickUpWarningUtils.tryToFind2DTexture("minecraft", itemMaterial + "_" + convertedItemType);
        if (iconId != NULL_IDENTIFIER) {
            return iconId;
        }
        iconId = PickUpWarningUtils.tryToFind2DTexture("minecraft", (itemMaterial = PickUpWarningUtils.convertionLayer(itemMaterial, convertedItemType)) + "_" + convertedItemType);
        if (iconId != NULL_IDENTIFIER) {
            return iconId;
        }
        class_2960 registeredId = class_2960.method_60655((String)"fresh-loot-highlight", (String)("dynamic/" + itemMaterial + "_" + convertedItemType + ".png"));
        if (dynamicTextures.contains(registeredId)) {
            return registeredId;
        }
        iconId = PickUpWarningUtils.generateIconFromMask(itemId, itemMaterial, convertedItemType);
        if (iconId != NULL_IDENTIFIER) {
            return iconId;
        }
        System.out.println("Could not find texture for " + itemId.toString() + " (tried material: " + itemMaterial + ", type: " + itemType + ")");
        return NULL_IDENTIFIER;
    }

    public static String getItemType(class_2960 itemId) {
        String path = itemId.method_12832();
        String[] parts = path.split("_");
        return parts[parts.length - 1];
    }

    public static String getItemMaterial(class_2960 itemId) {
        String path = itemId.method_12832();
        String[] parts = path.split("_");
        if (parts.length <= 1) {
            return path;
        }
        int size = parts.length - 1;
        int start = 0;
        if (Arrays.stream(parts).anyMatch("gate"::equals) || Arrays.stream(parts).anyMatch("pressure"::equals)) {
            --size;
        }
        if (parts[0].equals("waxed")) {
            start = 1;
        }
        return String.join((CharSequence)"_", Arrays.copyOfRange(parts, start, size));
    }

    public static String convertionLayer(String str) {
        if (CONVERTION_LAYER_MAP.containsKey(str)) {
            return CONVERTION_LAYER_MAP.get(str);
        }
        return str;
    }

    public static String convertionLayer(String str, String type) {
        if (CONVERTION_LAYER_MAP.containsKey(str)) {
            return CONVERTION_LAYER_MAP.get(str);
        }
        if (type.equals("carpet") && !str.equals("moss")) {
            return str + "_wool";
        }
        return str;
    }

    public static class_2960 generateIconFromMask(class_2960 itemId, String material, String type) {
        try {
            class_3300 rm = class_310.method_1551().method_1478();
            class_2960 materialTexture = class_2960.method_60655((String)itemId.method_12836(), (String)("textures/block/" + material + ".png"));
            class_1011 icon = class_1011.method_4309((InputStream)rm.getResourceOrThrow(materialTexture).method_14482());
            class_2960 maskId = class_2960.method_60655((String)"fresh-loot-highlight", (String)("textures/mask/" + type + ".png"));
            class_1011 mask = class_1011.method_4309((InputStream)rm.getResourceOrThrow(maskId).method_14482());
            for (int y = 0; y < icon.method_4323(); ++y) {
                for (int x = 0; x < icon.method_4307(); ++x) {
                    int pixelColor = icon.method_61940(x, y);
                    int a = pixelColor >> 24 & 0xFF;
                    int r = pixelColor >> 16 & 0xFF;
                    int g = pixelColor >> 8 & 0xFF;
                    int b = pixelColor & 0xFF;
                    int maskColor = mask.method_61940(x, y);
                    float maskAlpha = (float)(maskColor >> 24 & 0xFF) / 255.0f;
                    if ((double)maskAlpha > 0.1) {
                        icon.method_4305(x, y, a << 24 | b << 16 | g << 8 | r);
                        continue;
                    }
                    icon.method_4305(x, y, 0);
                }
            }
            class_2960 resultId = class_2960.method_60655((String)"fresh-loot-highlight", (String)("dynamic/" + material + "_" + type + ".png"));
            dynamicTextures.add(resultId);
            class_310.method_1551().method_1531().method_4616(resultId, (class_1044)new class_1043(() -> resultId.toString(), icon));
            return resultId;
        }
        catch (IOException ignored) {
            return NULL_IDENTIFIER;
        }
    }

    public static class_2960 tryToFind2DTexture(class_2960 itemId) {
        return PickUpWarningUtils.tryToFind2DTexture(itemId.method_12836(), itemId.method_12832(), POSSIBLE_PATHS);
    }

    public static class_2960 tryToFind2DTexture(String namespace, String path) {
        return PickUpWarningUtils.tryToFind2DTexture(namespace, path, POSSIBLE_PATHS);
    }

    public static class_2960 tryToFind2DTexture(String namespace, String path, String[] possiblePaths) {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        for (String pathPattern : possiblePaths) {
            class_2960 textureId = class_2960.method_60655((String)namespace, (String)String.format(pathPattern, path));
            try {
                resourceManager.getResourceOrThrow(textureId);
                return textureId;
            }
            catch (IOException iOException) {
            }
        }
        return NULL_IDENTIFIER;
    }
}

