/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.config;

import fr.madu59.config.SettingsManager;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;

@Environment(value=EnvType.CLIENT)
public class Option {
    public String id;
    public String name;
    public String description;
    public Object value;
    public Object defaultValue;
    public List<Object> possibleValues;

    public Option(String id, String name, String description, Object value, Object defaultValue, List<Object> possibleValues) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.value = value;
        this.defaultValue = defaultValue;
        this.possibleValues = possibleValues;
        SettingsManager.ALL_OPTIONS.add(this);
    }

    public void resetToDefault() {
        this.value = this.defaultValue;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
    }

    public Object getValue() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return class_1074.method_4662((String)this.name, (Object[])new Object[0]);
    }

    public String getDescription() {
        return class_1074.method_4662((String)this.description, (Object[])new Object[0]);
    }

    public List<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public String getValueAsTranslatedString() {
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean boolValue = (Boolean)object;
            return boolValue != false ? class_1074.method_4662((String)"fresh-loot-highlight.config.enabled", (Object[])new Object[0]) : class_1074.method_4662((String)"fresh-loot-highlight.config.disabled", (Object[])new Object[0]);
        }
        return class_1074.method_4662((String)this.value.toString(), (Object[])new Object[0]);
    }

    public String getValueAsString() {
        Object object = this.value;
        if (object instanceof Boolean) {
            Boolean boolValue = (Boolean)object;
            return boolValue != false ? "Enabled" : "Disabled";
        }
        return this.value.toString();
    }

    public int getValueAsIndex() {
        return this.possibleValues.indexOf(this.value);
    }

    public void setToNextValue() {
        if (this.possibleValues != null && !this.possibleValues.isEmpty()) {
            int currentIndex = this.possibleValues.indexOf(this.value);
            int nextIndex = (currentIndex + 1) % this.possibleValues.size();
            this.value = this.possibleValues.get(nextIndex);
        }
    }

    public void setPossibleValues(List<Object> possibleValues) {
        this.possibleValues = possibleValues;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

