/*
 * Decompiled with CFR 0.152.
 */
package fr.madu59.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import fr.madu59.config.Option;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    public static List<Option> ALL_OPTIONS = new ArrayList<Option>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("fresh-loot-highlight.json");
    public static Option ENABLE_PICKUP_WARNING = SettingsManager.loadOptionWithDefaults("ENABLE_PICKUP_WARNING", "fresh-loot-highlight.config.enable_pickup_warning", "fresh-loot-highlight.config.enable_pickup_warning_desc", true, true, List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
    public static Option ENABLE_PICKUP_WARNING_GROUPING = SettingsManager.loadOptionWithDefaults("ENABLE_PICKUP_WARNING_GROUPING", "fresh-loot-highlight.config.enable_pickup_warning_grouping", "fresh-loot-highlight.config.enable_pickup_warning_grouping_desc", "10s", "10s", List.of("10s", "5s", "3s", "Never"));
    public static Option PICKUP_WARNING_TIMEOUT = SettingsManager.loadOptionWithDefaults("PICKUP_WARNING_TIMEOUT", "fresh-loot-highlight.config.pickup_warning_timeout", "fresh-loot-highlight.config.pickup_warning_timeout_desc", "10s", "10s", List.of("10s", "5s", "3s"));
    public static Option PICKUP_WARNING_STYLE = SettingsManager.loadOptionWithDefaults("PICKUP_WARNING_HUD_STYLE", "fresh-loot-highlight.config.pickup_warning_hud_style", "fresh-loot-highlight.config.pickup_warning_hud_style_desc", "Default", "Default", List.of("Default", "Long"));
    public static Option PICKUP_WARNING_HUD_POSITION = SettingsManager.loadOptionWithDefaults("PICKUP_WARNING_HUD_POSITION", "fresh-loot-highlight.config.pickup_warning_hud_position", "fresh-loot-highlight.config.pickup_warning_hud_position_desc", "TOP_LEFT", "TOP_LEFT", List.of("TOP_LEFT", "TOP_RIGHT", "BOTTOM_RIGHT"));
    public static Option PICKUP_WARNING_HUD_SHOW_ITEM = SettingsManager.loadOptionWithDefaults("PICKUP_WARNING_HUD_SHOW_ITEM", "fresh-loot-highlight.config.pickup_warning_hud_show_item", "fresh-loot-highlight.config.pickup_warning_hud_show_item_desc", true, true, List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
    public static Option ENABLE_SLOT_HIGHLIGHTER = SettingsManager.loadOptionWithDefaults("ENABLE_SLOT_HIGHLIGHTER", "fresh-loot-highlight.config.enable_slot_highlighter", "fresh-loot-highlight.config.enable_slot_highlighter_desc", true, true, List.of(Boolean.valueOf(true), "Only if never seen before", Boolean.valueOf(false)));
    public static Option ENABLE_PICK_UP_WARNING_NARRATOR = SettingsManager.loadOptionWithDefaults("ENABLE_PICK_UP_WARNING_NARRATOR", "fresh-loot-highlight.config.enable_pick_up_warning_narrator", "fresh-loot-highlight.config.enable_pick_up_warning_narrator_desc", true, true, List.of(Boolean.valueOf(true), Boolean.valueOf(false)));

    public static List<String> getAllOptionsId() {
        ArrayList<String> list = new ArrayList<String>();
        for (Option option : ALL_OPTIONS) {
            list.add(option.getId());
        }
        return list;
    }

    public static boolean setOptionValue(String optionId, Object value) {
        for (Option option : ALL_OPTIONS) {
            if (!option.getId().equalsIgnoreCase(optionId)) continue;
            int index = option.getPossibleValues().stream().map(Object::toString).collect(Collectors.toList()).indexOf((String)value);
            if (option.getPossibleValues().contains(value)) {
                option.setValue(value);
                return true;
            }
            if (index == -1) continue;
            option.setValue(option.getPossibleValues().get(index));
            return true;
        }
        return false;
    }

    public static List<String> getOptionPossibleValues(String optionId) {
        for (Option option : ALL_OPTIONS) {
            if (!option.getId().equalsIgnoreCase(optionId)) continue;
            return option.getPossibleValues().stream().map(Object::toString).collect(Collectors.toList());
        }
        return null;
    }

    public static int getRGBColorFromSetting(String colorName) {
        int[] colors = SettingsManager.getColorFromSetting(colorName);
        return colors[2] + colors[1] * 256 + colors[0] * 256 * 256 + -16777216;
    }

    public static float[] convertColorToFloat(int[] colors) {
        float red = (float)colors[0] / 255.0f;
        float green = (float)colors[1] / 255.0f;
        float blue = (float)colors[2] / 255.0f;
        return new float[]{red, green, blue};
    }

    public static float convertAlphaToFloat(int alpha) {
        float alphaFloat = (float)alpha / 255.0f;
        return alphaFloat;
    }

    public static int[] getColorFromSetting(String colorName) {
        int red = 0;
        int green = 0;
        int blue = 0;
        switch (colorName) {
            case "Red": {
                red = 255;
                break;
            }
            case "Green": {
                green = 255;
                break;
            }
            case "Blue": {
                blue = 255;
                break;
            }
            case "Yellow": {
                red = 255;
                green = 255;
                break;
            }
            case "Cyan": {
                green = 255;
                blue = 255;
                break;
            }
            case "Magenta": {
                red = 255;
                blue = 255;
                break;
            }
            case "Purple": {
                red = 128;
                green = 0;
                blue = 128;
                break;
            }
            case "White": {
                red = 255;
                green = 255;
                blue = 255;
                break;
            }
            case "Grey": {
                red = 128;
                green = 128;
                blue = 128;
                break;
            }
            case "Black": {
                red = 0;
                green = 0;
                blue = 0;
                break;
            }
            default: {
                red = 255;
            }
        }
        return new int[]{red, green, blue};
    }

    public static void saveSettings(List<Option> options) {
        Map<String, Option> map = SettingsManager.toMap(options);
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson(map, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, Option> toMap(List<Option> options) {
        LinkedHashMap<String, Option> map = new LinkedHashMap<String, Option>();
        for (Option option : options) {
            map.put(option.getId(), option);
        }
        return map;
    }

    private static Option loadOption(String key) {
        Option option;
        block8: {
            BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);
            try {
                Type type = new TypeToken<Map<String, Option>>(){}.getType();
                Map map = (Map)GSON.fromJson((Reader)reader, type);
                option = (Option)map.get(key);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            ((Reader)reader).close();
        }
        return option;
    }

    private static Option loadOptionWithDefaults(String id, String name, String description, Object value, Object defaultValue, List<Object> possibleValues) {
        Option loadedOption = SettingsManager.loadOption(id);
        if (loadedOption == null) {
            return new Option(id, name, description, value, defaultValue, possibleValues);
        }
        loadedOption.setPossibleValues(possibleValues);
        loadedOption.setName(name);
        loadedOption.setDescription(description);
        ALL_OPTIONS.add(loadedOption);
        return loadedOption;
    }
}

