/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.bukkit.hook;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.Generated;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.features.TabExpansion;
import me.neznamy.tab.bridge.shared.message.outgoing.RegisterPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.PlaceholderReplacementPattern;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BridgeTabExpansion
extends PlaceholderExpansion
implements TabExpansion {
    private final Map<Player, Map<String, String>> values = new WeakHashMap<Player, Map<String, String>>();
    private final Map<Player, Set<String>> sentRequests = new WeakHashMap<Player, Set<String>>();
    private final String author = "NEZNAMY";
    private final String identifier = "tab";
    private final String version = "6.1.6";

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(@Nullable Player player, @NonNull String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (player == null) {
            return "";
        }
        if (identifier.startsWith("replace_")) {
            String textBefore;
            String text = "%" + identifier.substring(8) + "%";
            do {
                textBefore = text;
                for (String placeholder : this.detectPlaceholders(text)) {
                    PlaceholderReplacementPattern pattern = TABBridge.getInstance().getDataBridge().getReplacements().get(placeholder);
                    if (pattern == null) continue;
                    text = text.replace(placeholder, pattern.findReplacement(PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder)));
                }
            } while (!textBefore.equals(text));
            return text;
        }
        String value = (String)this.values.computeIfAbsent(player, pl -> new HashMap()).get(identifier);
        if (value == null && identifier.startsWith("placeholder_")) {
            BridgePlayer pl2;
            String placeholder = "%" + identifier.substring(12) + "%";
            if (!this.sentRequests.computeIfAbsent(player, pl -> new HashSet()).contains(placeholder) && (pl2 = TABBridge.getInstance().getPlayer(player.getUniqueId())) != null) {
                this.sentRequests.get(player).add(placeholder);
                pl2.sendPluginMessage(new RegisterPlaceholder(placeholder));
            }
        }
        return value;
    }

    @Override
    public void setValue(@NonNull BridgePlayer player, @NonNull String identifier, @NonNull String value) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.values.computeIfAbsent((Player)player.getPlayer(), p -> new HashMap()).put(identifier, value);
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

