/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.message.outgoing.GroupChange;
import me.neznamy.tab.bridge.shared.message.outgoing.OutgoingMessage;
import me.neznamy.tab.bridge.shared.message.outgoing.SetDisguised;
import me.neznamy.tab.bridge.shared.message.outgoing.SetInvisible;
import me.neznamy.tab.bridge.shared.message.outgoing.SetVanished;
import me.neznamy.tab.bridge.shared.message.outgoing.UpdateGameMode;
import me.neznamy.tab.bridge.shared.message.outgoing.WorldChange;
import org.jetbrains.annotations.NotNull;

public abstract class BridgePlayer {
    @NotNull
    private final String name;
    private final UUID uniqueId;
    @NotNull
    private String world;
    private boolean vanished;
    private boolean disguised;
    private boolean invisible;
    private int gameMode;
    private String group = "NONE";

    public BridgePlayer(@NonNull String name, @NonNull UUID uniqueId, @NonNull String world) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.name = name;
        this.uniqueId = uniqueId;
        this.world = world;
    }

    public void setVanished(boolean vanished) {
        if (this.vanished == vanished) {
            return;
        }
        this.vanished = vanished;
        this.sendPluginMessage(new SetVanished(vanished));
    }

    public void setDisguised(boolean disguised) {
        if (this.disguised == disguised) {
            return;
        }
        this.disguised = disguised;
        this.sendPluginMessage(new SetDisguised(disguised));
    }

    public void setInvisible(boolean invisible) {
        if (this.invisible == invisible) {
            return;
        }
        this.invisible = invisible;
        this.sendPluginMessage(new SetInvisible(invisible));
    }

    public void setGroup(@NonNull String group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (this.group.equals(group)) {
            return;
        }
        this.group = group;
        this.sendPluginMessage(new GroupChange(group));
    }

    public void setGameMode(int gameMode) {
        if (this.gameMode == gameMode) {
            return;
        }
        this.gameMode = gameMode;
        this.sendPluginMessage(new UpdateGameMode(gameMode));
    }

    public void setGameModeRaw(int gameMode) {
        this.gameMode = gameMode;
    }

    public void sendPluginMessage(@NonNull OutgoingMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeByte((int)OutgoingMessage.PACKET_IDS.get(message.getClass()).byteValue());
        message.write(out);
        this.sendPluginMessage(out.toByteArray());
    }

    public void refreshWorld() {
        String world = this.getWorld();
        if (this.world.equals(world)) {
            return;
        }
        this.world = world;
        this.sendPluginMessage(new WorldChange(world));
    }

    public abstract void sendPluginMessage(byte[] var1);

    @NotNull
    public abstract String getWorld();

    public abstract boolean hasPermission(@NonNull String var1);

    public abstract boolean checkInvisibility();

    public abstract boolean checkVanish();

    public abstract boolean checkDisguised();

    @NotNull
    public abstract String checkGroup();

    public abstract int checkGameMode();

    @NotNull
    public abstract Object getPlayer();

    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public boolean isVanished() {
        return this.vanished;
    }

    @Generated
    public boolean isDisguised() {
        return this.disguised;
    }

    @Generated
    public boolean isInvisible() {
        return this.invisible;
    }

    @Generated
    public int getGameMode() {
        return this.gameMode;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }
}

