/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared;

import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.message.incoming.ExpansionPlaceholder;
import me.neznamy.tab.bridge.shared.message.incoming.IncomingMessage;
import me.neznamy.tab.bridge.shared.message.incoming.PermissionCheck;
import me.neznamy.tab.bridge.shared.message.incoming.PlaceholderRegister;
import me.neznamy.tab.bridge.shared.message.outgoing.PlayerJoinResponse;
import me.neznamy.tab.bridge.shared.message.outgoing.UpdatePlaceholder;
import me.neznamy.tab.bridge.shared.message.outgoing.UpdateRelationalPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.Placeholder;
import me.neznamy.tab.bridge.shared.placeholder.PlaceholderReplacementPattern;
import me.neznamy.tab.bridge.shared.placeholder.PlayerPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.RelationalPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.ServerPlaceholder;
import org.jetbrains.annotations.NotNull;

public class DataBridge {
    private final Map<UUID, List<byte[]>> messageQueue = new WeakHashMap<UUID, List<byte[]>>();
    private final Map<String, Placeholder> asyncPlaceholders = new ConcurrentHashMap<String, Placeholder>();
    private final Map<String, Placeholder> syncPlaceholders = new ConcurrentHashMap<String, Placeholder>();
    private Placeholder[] syncPlaceholderArray = new Placeholder[0];
    private Placeholder[] asyncPlaceholderArray = new Placeholder[0];
    private Map<String, PlaceholderReplacementPattern> replacements = new HashMap<String, PlaceholderReplacementPattern>();
    private boolean groupForwarding;
    private int refreshCounterSync;
    private int refreshCounterAsync;
    private final Map<String, Function<ByteArrayDataInput, IncomingMessage>> registeredMessages = new HashMap<String, Function<ByteArrayDataInput, IncomingMessage>>(){
        {
            this.put("Permission", PermissionCheck::new);
            this.put("Placeholder", PlaceholderRegister::new);
            this.put("Expansion", ExpansionPlaceholder::new);
        }
    };

    public void startTasks() {
        TABBridge.getInstance().getPlatform().scheduleSyncRepeatingTask(() -> this.updatePlaceholders(this.syncPlaceholderArray, this.refreshCounterSync += 50), 1);
        TABBridge.getInstance().getPlaceholderThread().scheduleAtFixedRate(() -> {
            try {
                this.updatePlaceholders(this.asyncPlaceholderArray, this.refreshCounterAsync += 50);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, 50L, 50L, TimeUnit.MILLISECONDS);
        TABBridge.getInstance().getScheduler().scheduleAtFixedRate(() -> {
            for (BridgePlayer player : TABBridge.getInstance().getOnlinePlayers()) {
                player.setVanished(player.checkVanish());
                player.setDisguised(player.checkDisguised());
                player.setInvisible(player.checkInvisibility());
                if (!this.groupForwarding) continue;
                player.setGroup(player.checkGroup());
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        TABBridge.getInstance().getScheduler().scheduleAtFixedRate(() -> {
            for (BridgePlayer player : TABBridge.getInstance().getOnlinePlayers()) {
                player.setGameMode(player.checkGameMode());
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
    }

    public void processPluginMessage(@NonNull UUID uuid, byte[] bytes, boolean retry) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        Object player = TABBridge.getInstance().getPlatform().getPlayer(uuid);
        if (player == null) {
            this.messageQueue.computeIfAbsent(uuid, p -> new ArrayList()).add(bytes);
            return;
        }
        this.processPluginMessage(player, uuid, bytes, retry);
    }

    public void processPluginMessage(@NonNull Object player, @NonNull UUID uuid, byte[] bytes, boolean retry) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        String subChannel = in.readUTF();
        if (subChannel.equals("PlayerJoin")) {
            in.readInt();
            this.groupForwarding = in.readBoolean();
            int placeholderCount = in.readInt();
            BridgePlayer bp = TABBridge.getInstance().getPlatform().newPlayer(player);
            TABBridge.getInstance().addPlayer(bp);
            for (int i = 0; i < placeholderCount; ++i) {
                this.registerPlaceholder(bp, in.readUTF(), in.readInt());
            }
            this.readReplacements(in);
            int gamemode = bp.checkGameMode();
            bp.setGameModeRaw(gamemode);
            bp.sendPluginMessage(new PlayerJoinResponse(bp.getWorld(), this.groupForwarding ? bp.checkGroup() : null, this.parsePlaceholders(bp), gamemode));
            for (Placeholder placeholder : this.asyncPlaceholderArray) {
                if (!(placeholder instanceof RelationalPlaceholder)) continue;
                RelationalPlaceholder pl = (RelationalPlaceholder)placeholder;
                for (BridgePlayer viewer : TABBridge.getInstance().getOnlinePlayers()) {
                    if (!pl.update(viewer, bp)) continue;
                    viewer.sendPluginMessage(new UpdateRelationalPlaceholder(pl.getIdentifier(), bp.getName(), pl.getLastValue(viewer, bp)));
                }
            }
            this.processQueue(player, uuid);
            return;
        }
        BridgePlayer pl = TABBridge.getInstance().getPlayer(uuid);
        if (pl == null) {
            this.messageQueue.computeIfAbsent(uuid, p -> new ArrayList()).add(bytes);
            return;
        }
        Function<ByteArrayDataInput, IncomingMessage> function = this.registeredMessages.get(subChannel);
        if (function != null) {
            function.apply(in).process(pl);
        }
        if (subChannel.equals("Unload") && !retry) {
            TABBridge.getInstance().removePlayer(pl);
        }
    }

    private void readReplacements(@NonNull ByteArrayDataInput in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        int placeholderCount = in.readInt();
        HashMap<String, PlaceholderReplacementPattern> replacements = new HashMap<String, PlaceholderReplacementPattern>();
        for (int i = 0; i < placeholderCount; ++i) {
            String placeholder = in.readUTF();
            HashMap<Object, Object> rules = new HashMap<Object, Object>();
            int ruleCount = in.readInt();
            for (int j = 0; j < ruleCount; ++j) {
                rules.put(in.readUTF(), in.readUTF());
            }
            replacements.put(placeholder, new PlaceholderReplacementPattern(placeholder, rules));
        }
        this.replacements = replacements;
    }

    public void processQueue(@NonNull Object player, @NonNull UUID uuid) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        List<byte[]> list = this.messageQueue.remove(uuid);
        if (list != null) {
            list.forEach(msg -> this.processPluginMessage(player, uuid, (byte[])msg, true));
        }
    }

    public void registerPlaceholder(@NonNull BridgePlayer player, @NonNull String identifier, int refresh) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (this.syncPlaceholders.containsKey(identifier)) {
            this.syncPlaceholders.get(identifier).setRefresh(refresh);
        } else if (this.asyncPlaceholders.containsKey(identifier)) {
            this.asyncPlaceholders.get(identifier).setRefresh(refresh);
        } else {
            String finalIdentifier;
            boolean sync = false;
            if (identifier.startsWith("%sync:")) {
                finalIdentifier = "%" + identifier.substring(6);
                sync = true;
            } else {
                finalIdentifier = identifier;
            }
            Placeholder placeholder = TABBridge.getInstance().getPlatform().createPlaceholder(identifier, finalIdentifier, refresh);
            if (sync) {
                this.addSyncPlaceholder(placeholder);
            } else {
                this.addAsyncPlaceholder(placeholder);
            }
        }
        if (identifier.startsWith("%sync:")) {
            TABBridge.getInstance().getPlatform().runTask(() -> this.sendInitialValues(this.syncPlaceholders.get(identifier), player));
        } else {
            this.sendInitialValues(this.asyncPlaceholders.get(identifier), player);
        }
    }

    public void addSyncPlaceholder(@NonNull Placeholder placeholder) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        this.syncPlaceholders.put(placeholder.getIdentifier(), placeholder);
        this.syncPlaceholderArray = this.syncPlaceholders.values().toArray(new Placeholder[0]);
    }

    public void addAsyncPlaceholder(@NonNull Placeholder placeholder) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        this.asyncPlaceholders.put(placeholder.getIdentifier(), placeholder);
        this.asyncPlaceholderArray = this.asyncPlaceholders.values().toArray(new Placeholder[0]);
    }

    @NotNull
    public Map<String, Object> parsePlaceholders(@NonNull BridgePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        LinkedHashMap<String, Object> outputs = new LinkedHashMap<String, Object>();
        ArrayList allPlaceholders = Lists.newArrayList((Object[])this.asyncPlaceholderArray);
        allPlaceholders.addAll(this.syncPlaceholders.values());
        for (Placeholder placeholder : allPlaceholders) {
            if (placeholder instanceof ServerPlaceholder) {
                outputs.put(placeholder.getIdentifier(), ((ServerPlaceholder)placeholder).getLastValue());
            }
            if (placeholder instanceof PlayerPlaceholder) {
                outputs.put(placeholder.getIdentifier(), ((PlayerPlaceholder)placeholder).getLastValue(player));
            }
            if (!(placeholder instanceof RelationalPlaceholder)) continue;
            Map relMap = (Map)outputs.computeIfAbsent(placeholder.getIdentifier(), p -> new HashMap());
            for (BridgePlayer target : TABBridge.getInstance().getOnlinePlayers()) {
                relMap.put(target.getName(), ((RelationalPlaceholder)placeholder).getLastValue(player, target));
            }
        }
        return outputs;
    }

    private void updatePlaceholders(@NonNull Placeholder[] placeholders, int counter) {
        if (placeholders == null) {
            throw new NullPointerException("placeholders is marked non-null but is null");
        }
        for (Placeholder placeholder : placeholders) {
            if (placeholder.getRefresh() == -1 || counter % placeholder.getRefresh() != 0) continue;
            if (placeholder instanceof ServerPlaceholder) {
                ServerPlaceholder pl = (ServerPlaceholder)placeholder;
                if (!pl.update()) continue;
                UpdatePlaceholder msg = new UpdatePlaceholder(pl.getIdentifier(), pl.getLastValue());
                for (BridgePlayer player : TABBridge.getInstance().getOnlinePlayers()) {
                    player.sendPluginMessage(msg);
                }
                continue;
            }
            for (BridgePlayer player : TABBridge.getInstance().getOnlinePlayers()) {
                Placeholder pl;
                if (placeholder instanceof PlayerPlaceholder) {
                    pl = (PlayerPlaceholder)placeholder;
                    if (!((PlayerPlaceholder)pl).update(player)) continue;
                    player.sendPluginMessage(new UpdatePlaceholder(pl.getIdentifier(), ((PlayerPlaceholder)pl).getLastValue(player)));
                    continue;
                }
                if (!(placeholder instanceof RelationalPlaceholder)) continue;
                pl = (RelationalPlaceholder)placeholder;
                for (BridgePlayer viewer : TABBridge.getInstance().getOnlinePlayers()) {
                    if (!((RelationalPlaceholder)pl).update(viewer, player)) continue;
                    viewer.sendPluginMessage(new UpdateRelationalPlaceholder(pl.getIdentifier(), player.getName(), ((RelationalPlaceholder)pl).getLastValue(viewer, player)));
                }
            }
        }
    }

    private void sendInitialValues(@NonNull Placeholder placeholder, @NonNull BridgePlayer player) {
        Placeholder pl;
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (placeholder instanceof ServerPlaceholder) {
            pl = (ServerPlaceholder)placeholder;
            player.sendPluginMessage(new UpdatePlaceholder(pl.getIdentifier(), ((ServerPlaceholder)pl).getLastValue()));
        }
        if (placeholder instanceof PlayerPlaceholder) {
            pl = (PlayerPlaceholder)placeholder;
            player.sendPluginMessage(new UpdatePlaceholder(pl.getIdentifier(), ((PlayerPlaceholder)pl).getLastValue(player)));
        }
        if (placeholder instanceof RelationalPlaceholder) {
            pl = (RelationalPlaceholder)placeholder;
            for (BridgePlayer viewer : TABBridge.getInstance().getOnlinePlayers()) {
                viewer.sendPluginMessage(new UpdateRelationalPlaceholder(pl.getIdentifier(), player.getName(), ((RelationalPlaceholder)pl).getLastValue(viewer, player)));
            }
        }
    }

    @Generated
    public Map<String, PlaceholderReplacementPattern> getReplacements() {
        return this.replacements;
    }
}

