/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.DataBridge;
import me.neznamy.tab.bridge.shared.Platform;
import me.neznamy.tab.bridge.shared.features.TabExpansion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TABBridge {
    public static final String CHANNEL_NAME = "tab:bridge-6";
    public static final String PLUGIN_VERSION = "6.1.6";
    private static TABBridge instance;
    private final Platform platform;
    private final DataBridge dataBridge = new DataBridge();
    @Nullable
    private final TabExpansion expansion;
    private final Map<UUID, BridgePlayer> players = new ConcurrentHashMap<UUID, BridgePlayer>();
    private BridgePlayer[] playerArray = new BridgePlayer[0];
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TAB-Bridge Processing Thread").build());
    private final ScheduledExecutorService placeholderThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("TAB-Bridge Placeholder Refreshing Thread").build());

    public void addPlayer(@NonNull BridgePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.players.put(player.getUniqueId(), player);
        this.playerArray = this.players.values().toArray(new BridgePlayer[0]);
    }

    public void removePlayer(@NonNull BridgePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.players.remove(player.getUniqueId());
        this.playerArray = this.players.values().toArray(new BridgePlayer[0]);
    }

    @NotNull
    public BridgePlayer[] getOnlinePlayers() {
        return this.playerArray;
    }

    @Nullable
    public BridgePlayer getPlayer(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.players.get(uuid);
    }

    public void submitTask(@NonNull Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (this.scheduler.isShutdown()) {
            return;
        }
        this.scheduler.submit(() -> {
            try {
                task.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public void unload() {
        this.platform.cancelTasks();
        this.shutdownExecutor();
        if (this.expansion != null) {
            this.expansion.unregister();
        }
    }

    public void shutdownExecutor() {
        this.scheduler.shutdownNow();
        this.placeholderThread.shutdownNow();
    }

    @Generated
    public TABBridge(Platform platform, @Nullable TabExpansion expansion) {
        this.platform = platform;
        this.expansion = expansion;
    }

    @Generated
    public static TABBridge getInstance() {
        return instance;
    }

    @Generated
    public static void setInstance(TABBridge instance) {
        TABBridge.instance = instance;
    }

    @Generated
    public Platform getPlatform() {
        return this.platform;
    }

    @Generated
    public DataBridge getDataBridge() {
        return this.dataBridge;
    }

    @Nullable
    @Generated
    public TabExpansion getExpansion() {
        return this.expansion;
    }

    @Generated
    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Generated
    public ScheduledExecutorService getPlaceholderThread() {
        return this.placeholderThread;
    }
}

