/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import org.jetbrains.annotations.NotNull;

public interface TabExpansion {
    public static final Pattern placeholderPattern = Pattern.compile("%([^%]*)%");

    public boolean unregister();

    public void setValue(@NonNull BridgePlayer var1, @NonNull String var2, @NonNull String var3);

    @NotNull
    default public List<String> detectPlaceholders(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (!text.contains("%")) {
            return Collections.emptyList();
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher m = placeholderPattern.matcher(text);
        while (m.find()) {
            placeholders.add(m.group());
        }
        return placeholders;
    }
}

