/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared.placeholder;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.message.outgoing.PlaceholderError;
import me.neznamy.tab.bridge.shared.placeholder.Placeholder;
import org.jetbrains.annotations.NotNull;

public class PlayerPlaceholder
extends Placeholder {
    @NotNull
    private final Map<BridgePlayer, String> lastValues = Collections.synchronizedMap(new WeakHashMap());
    @NotNull
    private final Function<BridgePlayer, String> function;

    public PlayerPlaceholder(@NonNull String identifier, int refresh, @NonNull Function<BridgePlayer, String> function) {
        super(identifier, refresh);
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
    }

    public boolean update(@NonNull BridgePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        String value = this.request(player);
        if (!this.lastValues.getOrDefault(player, this.identifier).equals(value)) {
            this.lastValues.put(player, value);
            return true;
        }
        return false;
    }

    @NotNull
    private String request(@NonNull BridgePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            String result = this.function.apply(player);
            return Objects.requireNonNull(result, "Placeholder " + this.identifier + " returned null for player " + player.getName());
        }
        catch (Throwable t) {
            player.sendPluginMessage(new PlaceholderError("Player placeholder " + this.identifier + " generated an error when setting for player " + player.getName(), t));
            return "<PlaceholderAPI Error>";
        }
    }

    @NotNull
    public String getLastValue(@NonNull BridgePlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.lastValues.computeIfAbsent(player, this::request);
    }
}

