/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared.placeholder;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.message.outgoing.PlaceholderError;
import me.neznamy.tab.bridge.shared.placeholder.Placeholder;
import org.jetbrains.annotations.NotNull;

public class RelationalPlaceholder
extends Placeholder {
    @NotNull
    private final Map<BridgePlayer, Map<BridgePlayer, String>> lastValues = new WeakHashMap<BridgePlayer, Map<BridgePlayer, String>>();
    @NotNull
    private final BiFunction<BridgePlayer, BridgePlayer, String> function;

    public RelationalPlaceholder(@NonNull String identifier, int refresh, @NonNull BiFunction<BridgePlayer, BridgePlayer, String> function) {
        super(identifier, refresh);
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
    }

    public boolean update(@NonNull BridgePlayer viewer, @NonNull BridgePlayer target) {
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        String value = this.request(viewer, target);
        if (!this.lastValues.computeIfAbsent(viewer, v -> new WeakHashMap()).getOrDefault(target, this.getIdentifier()).equals(value)) {
            this.lastValues.get(viewer).put(target, value);
            return true;
        }
        return false;
    }

    @NotNull
    private String request(@NonNull BridgePlayer viewer, @NonNull BridgePlayer target) {
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try {
            return this.function.apply(viewer, target);
        }
        catch (Throwable t) {
            viewer.sendPluginMessage(new PlaceholderError("Relational placeholder " + this.identifier + " generated an error when setting for viewer " + viewer.getName() + " and target " + target.getName(), t));
            return "<PlaceholderAPI Error>";
        }
    }

    @NotNull
    public String getLastValue(@NonNull BridgePlayer viewer, @NonNull BridgePlayer target) {
        if (viewer == null) {
            throw new NullPointerException("viewer is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return this.lastValues.computeIfAbsent(viewer, v -> new WeakHashMap()).computeIfAbsent(target, t -> this.request(viewer, target));
    }
}

