/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared.placeholder;

import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.message.outgoing.PlaceholderError;
import me.neznamy.tab.bridge.shared.placeholder.Placeholder;
import org.jetbrains.annotations.NotNull;

public class ServerPlaceholder
extends Placeholder {
    @NotNull
    private String lastValue;
    @NotNull
    private final Supplier<String> function;

    public ServerPlaceholder(@NonNull String identifier, int refresh, @NonNull Supplier<String> function) {
        super(identifier, refresh);
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
        this.lastValue = this.request();
    }

    public boolean update() {
        String value = this.request();
        if (!this.lastValue.equals(value)) {
            this.lastValue = value;
            return true;
        }
        return false;
    }

    @NotNull
    private String request() {
        try {
            return this.function.get();
        }
        catch (Throwable t) {
            BridgePlayer[] players = TABBridge.getInstance().getOnlinePlayers();
            if (players.length > 0) {
                players[0].sendPluginMessage(new PlaceholderError("Server placeholder " + this.identifier + " generated an error", t));
            }
            return "<PlaceholderAPI Error>";
        }
    }

    @NotNull
    @Generated
    public String getLastValue() {
        return this.lastValue;
    }
}

