/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.bukkit;

import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.bukkit.BukkitBridgePlayer;
import me.neznamy.tab.bridge.bukkit.BukkitPlatform;
import me.neznamy.tab.bridge.bukkit.BukkitPluginMessageListener;
import me.neznamy.tab.bridge.bukkit.hook.BridgeTabExpansion;
import me.neznamy.tab.bridge.libs.org.bstats.bukkit.Metrics;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.message.outgoing.WorldChange;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BukkitBridge
extends JavaPlugin
implements Listener {
    private static BukkitBridge instance;

    public void onEnable() {
        instance = this;
        BridgeTabExpansion expansion = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI") ? new BridgeTabExpansion() : null;
        BukkitPlatform platform = new BukkitPlatform(this);
        TABBridge.setInstance(new TABBridge(platform, expansion));
        platform.startTasks();
        if (expansion != null) {
            expansion.register();
        }
        BukkitPluginMessageListener pluginMessageListener = PluginMessageListener.class.getMethods().length > 1 ? (PluginMessageListener)Class.forName("me.neznamy.tab.bridge.bukkit.paper.PaperPluginMessageListener").getConstructor(new Class[0]).newInstance(new Object[0]) : new BukkitPluginMessageListener();
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this, "tab:bridge-6", (PluginMessageListener)pluginMessageListener);
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "tab:bridge-6");
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        TABBridge.getInstance().getDataBridge().startTasks();
        new Metrics((Plugin)this, 20810);
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        TABBridge.getInstance().unload();
    }

    @EventHandler
    public void onJoin(@NonNull PlayerJoinEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        TABBridge.getInstance().submitTask(() -> TABBridge.getInstance().getDataBridge().processQueue(e.getPlayer(), e.getPlayer().getUniqueId()));
    }

    @EventHandler
    public void onQuit(@NonNull PlayerQuitEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        TABBridge.getInstance().submitTask(() -> {
            BukkitBridgePlayer p = (BukkitBridgePlayer)TABBridge.getInstance().getPlayer(e.getPlayer().getUniqueId());
            if (p == null) {
                return;
            }
            TABBridge.getInstance().removePlayer(p);
        });
    }

    @EventHandler
    public void onWorldChange(@NonNull PlayerChangedWorldEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        BridgePlayer p = TABBridge.getInstance().getPlayer(e.getPlayer().getUniqueId());
        if (p == null) {
            return;
        }
        p.sendPluginMessage(new WorldChange(e.getPlayer().getWorld().getName()));
    }

    @EventHandler
    public void onChannelRegister(@NonNull PlayerRegisterChannelEvent e) {
        if (e == null) {
            throw new NullPointerException("e is marked non-null but is null");
        }
        if (!e.getChannel().equals("tab:bridge-6")) {
            return;
        }
        BukkitBridgePlayer player = (BukkitBridgePlayer)TABBridge.getInstance().getPlayer(e.getPlayer().getUniqueId());
        if (player != null) {
            player.sendQueuedMessages();
        }
    }

    @Generated
    public static BukkitBridge getInstance() {
        return instance;
    }
}

