/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.bukkit;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.bukkit.BukkitBridge;
import me.neznamy.tab.bridge.bukkit.hook.LibsDisguisesHook;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.hook.LuckPermsHook;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitBridgePlayer
extends BridgePlayer {
    private static final boolean vault = Bukkit.getPluginManager().isPluginEnabled("Vault");
    @NotNull
    private final Player player;
    @Nullable
    private Permission permission;
    private boolean channelRegistered;
    private final List<byte[]> queuedMessages = new ArrayList<byte[]>();

    public BukkitBridgePlayer(@NonNull Player player) {
        super(player.getName(), player.getUniqueId(), player.getWorld().getName());
        RegisteredServiceProvider rsp;
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.player = player;
        this.channelRegistered = this.getListeningPluginChannels().contains("tab:bridge-6");
        if (vault && (rsp = Bukkit.getServicesManager().getRegistration(Permission.class)) != null) {
            this.permission = (Permission)rsp.getProvider();
        }
    }

    @NotNull
    private Set<String> getListeningPluginChannels() {
        try {
            return this.player.getListeningPluginChannels();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("[TAB-Bridge] An error was thrown by Bukkit when getting player's channels. Trying again.");
            return this.getListeningPluginChannels();
        }
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        if (!this.channelRegistered) {
            this.queuedMessages.add(message);
            return;
        }
        this.player.sendPluginMessage((Plugin)BukkitBridge.getInstance(), "tab:bridge-6", message);
    }

    @Override
    @NotNull
    public String getWorld() {
        return this.player.getWorld().getName();
    }

    @Override
    public boolean hasPermission(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission is marked non-null but is null");
        }
        return this.player.hasPermission(permission);
    }

    @Override
    public boolean checkInvisibility() {
        return this.player.hasPotionEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    public boolean checkVanish() {
        for (MetadataValue v : this.player.getMetadata("vanished")) {
            if (!v.asBoolean()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkDisguised() {
        return LibsDisguisesHook.isDisguised(this.player);
    }

    @Override
    @NotNull
    public String checkGroup() {
        if (LuckPermsHook.getInstance().isInstalled()) {
            return LuckPermsHook.getInstance().getGroupFunction().apply(this);
        }
        if (vault) {
            if (this.permission == null || this.permission.getName().equals("SuperPerms")) {
                return "No permission plugin found";
            }
            return this.permission.getPrimaryGroup(this.player);
        }
        return "Vault not found";
    }

    @Override
    public int checkGameMode() {
        return this.player.getGameMode().getValue();
    }

    public void sendQueuedMessages() {
        this.channelRegistered = true;
        for (byte[] message : this.queuedMessages) {
            this.sendPluginMessage(message);
        }
        this.queuedMessages.clear();
    }

    @NotNull
    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    @Generated
    public Permission getPermission() {
        return this.permission;
    }

    @Generated
    public boolean isChannelRegistered() {
        return this.channelRegistered;
    }

    @Generated
    public List<byte[]> getQueuedMessages() {
        return this.queuedMessages;
    }
}

