/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.bukkit;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.neznamy.tab.bridge.bukkit.BukkitBridgePlayer;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.Platform;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.placeholder.Placeholder;
import me.neznamy.tab.bridge.shared.placeholder.PlayerPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.RelationalPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.ServerPlaceholder;
import me.neznamy.tab.bridge.shared.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitPlatform
implements Platform {
    private final boolean placeholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    private final boolean folia = ReflectionUtils.classExists("io.papermc.paper.threadedregions.RegionizedServer");
    private final JavaPlugin plugin;

    public void startTasks() {
        if (this.folia) {
            TABBridge.getInstance().getScheduler().scheduleAtFixedRate(() -> {
                for (BridgePlayer player : TABBridge.getInstance().getOnlinePlayers()) {
                    player.refreshWorld();
                }
            }, 50L, 50L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void scheduleSyncRepeatingTask(@NonNull Runnable task, int intervalTicks) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (this.folia) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, task, (long)intervalTicks, (long)intervalTicks);
    }

    @Override
    public void runTask(@NonNull Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        if (this.folia) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, task);
    }

    @Override
    public void cancelTasks() {
        if (this.folia) {
            return;
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this.plugin);
    }

    @Override
    @Nullable
    public Object getPlayer(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return Bukkit.getPlayer((UUID)uniqueId);
    }

    @Override
    @NotNull
    public BridgePlayer newPlayer(@NonNull Object player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new BukkitBridgePlayer((Player)player);
    }

    @Override
    @NotNull
    public Placeholder createPlaceholder(@NonNull String publicIdentifier, @NonNull String privateIdentifier, int refresh) {
        if (publicIdentifier == null) {
            throw new NullPointerException("publicIdentifier is marked non-null but is null");
        }
        if (privateIdentifier == null) {
            throw new NullPointerException("privateIdentifier is marked non-null but is null");
        }
        if (!this.placeholderAPI) {
            if (privateIdentifier.startsWith("%rel_")) {
                return new RelationalPlaceholder(publicIdentifier, -1, (viewer, target) -> "<PlaceholderAPI is not installed>");
            }
            return new ServerPlaceholder(publicIdentifier, -1, () -> "<PlaceholderAPI is not installed>");
        }
        if (privateIdentifier.startsWith("%server_")) {
            return new ServerPlaceholder(publicIdentifier, refresh, () -> this.parseWithNestedPlaceholders(null, privateIdentifier));
        }
        if (privateIdentifier.startsWith("%rel_")) {
            return new RelationalPlaceholder(publicIdentifier, refresh, (viewer, target) -> PlaceholderAPI.setRelationalPlaceholders((Player)((BukkitBridgePlayer)viewer).getPlayer(), (Player)((BukkitBridgePlayer)target).getPlayer(), (String)privateIdentifier));
        }
        return new PlayerPlaceholder(publicIdentifier, refresh, p -> this.parseWithNestedPlaceholders(((BukkitBridgePlayer)p).getPlayer(), privateIdentifier));
    }

    @NotNull
    private String parseWithNestedPlaceholders(@Nullable Player player, @NonNull String identifier) {
        String textBefore;
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        String text = identifier;
        while (!(textBefore = text).equals(text = PlaceholderAPI.setPlaceholders((Player)player, (String)text))) {
        }
        return text;
    }

    @Generated
    public BukkitPlatform(JavaPlugin plugin) {
        this.plugin = plugin;
    }
}

