/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.bukkit.hook;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.features.TabExpansion;
import me.neznamy.tab.bridge.shared.message.outgoing.RegisterPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.PlaceholderReplacementPattern;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BridgeTabExpansion
extends PlaceholderExpansion
implements TabExpansion {
    private final Map<BridgePlayer, Map<String, String>> values = Collections.synchronizedMap(new WeakHashMap());
    private final Map<BridgePlayer, Set<String>> sentRequests = new WeakHashMap<BridgePlayer, Set<String>>();
    private final String author = "NEZNAMY";
    private final String identifier = "tab";
    private final String version = "6.1.8";

    public boolean persist() {
        return true;
    }

    public synchronized String onPlaceholderRequest(@Nullable Player player, @NonNull String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (player == null) {
            return "";
        }
        if (identifier.startsWith("replace_")) {
            String textBefore;
            String text = "%" + identifier.substring(8) + "%";
            do {
                textBefore = text;
                for (String placeholder : this.detectPlaceholders(text)) {
                    PlaceholderReplacementPattern pattern = TABBridge.getInstance().getDataBridge().getReplacements().get(placeholder);
                    if (pattern == null) continue;
                    text = text.replace(placeholder, pattern.findReplacement(PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder)));
                }
            } while (!textBefore.equals(text));
            return text;
        }
        BridgePlayer bridgePlayer = TABBridge.getInstance().getPlayer(player.getUniqueId());
        if (bridgePlayer == null) {
            return "<Player is not loaded yet>";
        }
        String value = (String)this.values.computeIfAbsent(bridgePlayer, pl -> new ConcurrentHashMap()).get(identifier);
        if (value == null && identifier.startsWith("placeholder_")) {
            String placeholder = "%" + identifier.substring(12) + "%";
            if (!this.sentRequests.computeIfAbsent(bridgePlayer, pl -> new HashSet()).contains(placeholder)) {
                this.sentRequests.get(bridgePlayer).add(placeholder);
                bridgePlayer.sendPluginMessage(new RegisterPlaceholder(placeholder));
            }
        }
        return value;
    }

    @Override
    public synchronized void setValue(@NonNull BridgePlayer player, @NonNull String identifier, @NonNull String value) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.values.computeIfAbsent(player, p -> new ConcurrentHashMap()).put(identifier, value);
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

