/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.fabric;

import lombok.Generated;
import me.neznamy.tab.bridge.fabric.FabricBridgePlayer;
import me.neznamy.tab.bridge.fabric.FabricPlatform;
import me.neznamy.tab.bridge.fabric.VersionLoader;
import me.neznamy.tab.bridge.fabric.hook.FabricTabExpansion;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.message.outgoing.WorldChange;
import me.neznamy.tab.bridge.shared.util.ReflectionUtils;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5268;
import org.jetbrains.annotations.NotNull;

public class FabricBridge
implements DedicatedServerModInitializer {
    private static FabricBridge instance;
    private final VersionLoader versionLoader = (VersionLoader)Class.forName("me.neznamy.tab.bridge.fabric." + this.getImplPackage() + ".VersionLoaderImpl").getConstructor(new Class[0]).newInstance(new Object[0]);

    @NotNull
    private String getImplPackage() {
        int serverVersion = class_155.method_31372();
        if (serverVersion >= 773) {
            return "v1_21_9";
        }
        if (serverVersion >= 766) {
            return "v1_21_8";
        }
        if (serverVersion >= 763) {
            return "v1_20_4";
        }
        if (serverVersion >= 759) {
            return "v1_19_4";
        }
        return "v1_18_2";
    }

    public void onInitializeServer() {
        instance = this;
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.versionLoader.registerListeners();
            FabricTabExpansion expansion = ReflectionUtils.classExists("eu.pb4.placeholders.api.PlaceholderHandler") ? new FabricTabExpansion(this.versionLoader) : null;
            TABBridge.setInstance(new TABBridge(new FabricPlatform(this.versionLoader, server), expansion));
            TABBridge.getInstance().getDataBridge().startTasks();
        });
        ServerPlayConnectionEvents.JOIN.register((connection, sender, server) -> TABBridge.getInstance().submitTask(() -> TABBridge.getInstance().getDataBridge().processQueue(connection.field_14140, connection.field_14140.method_5667())));
        ServerPlayConnectionEvents.DISCONNECT.register((connection, server) -> TABBridge.getInstance().submitTask(() -> {
            FabricBridgePlayer p = (FabricBridgePlayer)TABBridge.getInstance().getPlayer(connection.field_14140.method_5667());
            if (p == null) {
                return;
            }
            TABBridge.getInstance().removePlayer(p);
        }));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            FabricBridgePlayer player = (FabricBridgePlayer)TABBridge.getInstance().getPlayer(oldPlayer.method_5667());
            if (player != null) {
                player.setPlayer(newPlayer);
            }
            this.worldChange(newPlayer, this.versionLoader.getLevel(newPlayer));
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> this.worldChange(player, (class_1937)destination));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> TABBridge.getInstance().unload());
    }

    private void worldChange(@NotNull class_3222 player, @NotNull class_1937 destination) {
        BridgePlayer p = TABBridge.getInstance().getPlayer(player.method_5667());
        if (p == null) {
            return;
        }
        p.sendPluginMessage(new WorldChange(FabricBridge.getLevelName(destination)));
    }

    @NotNull
    public static String getLevelName(@NotNull class_1937 level) {
        String path = level.method_27983().method_29177().method_12832();
        String string = ((class_5268)level.method_8401()).method_150();
        return string + (String)(switch (path) {
            case "overworld" -> "";
            case "the_nether" -> "_nether";
            default -> "_" + path;
        });
    }

    @Generated
    public static FabricBridge getInstance() {
        return instance;
    }

    @Generated
    public VersionLoader getVersionLoader() {
        return this.versionLoader;
    }
}

