/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.fabric;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.fabric.FabricBridgePlayer;
import me.neznamy.tab.bridge.fabric.VersionLoader;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.Platform;
import me.neznamy.tab.bridge.shared.placeholder.Placeholder;
import me.neznamy.tab.bridge.shared.placeholder.PlayerPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.RelationalPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.ServerPlaceholder;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricPlatform
implements Platform {
    private final boolean placeholderAPI = FabricLoader.getInstance().isModLoaded("placeholder-api");
    private final VersionLoader version;
    private final MinecraftServer server;

    @Override
    public void scheduleSyncRepeatingTask(@NonNull Runnable task, int intervalTicks) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
    }

    @Override
    public void runTask(@NonNull Runnable task) {
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
    }

    @Override
    public void cancelTasks() {
    }

    @Override
    @Nullable
    public Object getPlayer(@NonNull UUID uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return this.server.method_3760().method_14602(uniqueId);
    }

    @Override
    @NotNull
    public BridgePlayer newPlayer(@NonNull Object player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return new FabricBridgePlayer((class_3222)player);
    }

    @Override
    @NotNull
    public Placeholder createPlaceholder(@NonNull String publicIdentifier, @NonNull String privateIdentifier, int refresh) {
        if (publicIdentifier == null) {
            throw new NullPointerException("publicIdentifier is marked non-null but is null");
        }
        if (privateIdentifier == null) {
            throw new NullPointerException("privateIdentifier is marked non-null but is null");
        }
        if (!this.placeholderAPI) {
            if (privateIdentifier.startsWith("%rel_")) {
                return new RelationalPlaceholder(publicIdentifier, -1, (viewer, target) -> "<PlaceholderAPI is not installed>");
            }
            return new ServerPlaceholder(publicIdentifier, -1, () -> "<PlaceholderAPI is not installed>");
        }
        if (privateIdentifier.startsWith("%rel_")) {
            return new RelationalPlaceholder(publicIdentifier, refresh, (viewer, target) -> "<Relational placeholders are not supported>");
        }
        return new PlayerPlaceholder(publicIdentifier, refresh, p -> this.parseWithNestedPlaceholders(((FabricBridgePlayer)p).getPlayer(), privateIdentifier));
    }

    @NotNull
    private String parseWithNestedPlaceholders(@NotNull class_3222 player, @NonNull String identifier) {
        String textBefore;
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        String text = identifier;
        while (!(textBefore = text).equals(text = Placeholders.parseText((class_2561)this.version.newTextComponent(text), (PlaceholderContext)PlaceholderContext.of((class_3222)player)).getString())) {
        }
        return text;
    }

    @Generated
    public FabricPlatform(VersionLoader version, MinecraftServer server) {
        this.version = version;
        this.server = server;
    }
}

