/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.fabric.hook;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.Placeholders;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.Generated;
import lombok.NonNull;
import me.neznamy.tab.bridge.fabric.VersionLoader;
import me.neznamy.tab.bridge.shared.BridgePlayer;
import me.neznamy.tab.bridge.shared.TABBridge;
import me.neznamy.tab.bridge.shared.features.TabExpansion;
import me.neznamy.tab.bridge.shared.message.outgoing.RegisterPlaceholder;
import me.neznamy.tab.bridge.shared.placeholder.PlaceholderReplacementPattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class FabricTabExpansion
implements TabExpansion {
    private final Map<BridgePlayer, Map<String, String>> values = new WeakHashMap<BridgePlayer, Map<String, String>>();
    private final Map<BridgePlayer, Set<String>> sentRequests = new WeakHashMap<BridgePlayer, Set<String>>();

    public FabricTabExpansion(@NonNull VersionLoader version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        List<String> placeholders = Arrays.asList("tabprefix", "tabsuffix", "tagprefix", "tagsuffix", "customtabname", "tabprefix_raw", "tabsuffix_raw", "tagprefix_raw", "tagsuffix_raw", "customtabname_raw", "scoreboard_name", "scoreboard_visible", "bossbar_visible", "nametag_visibility");
        for (String placeholder : placeholders) {
            this.registerPlaceholder(placeholder, (ctx, arg) -> {
                if (!ctx.hasPlayer()) {
                    return PlaceholderResult.invalid((String)"No player!");
                }
                BridgePlayer player = TABBridge.getInstance().getPlayer(ctx.player().method_5667());
                return PlaceholderResult.value((String)this.values.get(player).get(placeholder));
            });
        }
        this.registerPlaceholder("replace", (ctx, arg) -> {
            String textBefore;
            if (!ctx.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            if (arg == null) {
                return PlaceholderResult.invalid((String)"No placeholder!");
            }
            Object text = "%" + arg.substring(8) + "%";
            do {
                textBefore = text;
                for (String placeholder : this.detectPlaceholders((String)text)) {
                    PlaceholderReplacementPattern pattern = TABBridge.getInstance().getDataBridge().getReplacements().get(placeholder);
                    if (pattern == null) continue;
                    text = ((String)text).replace(placeholder, pattern.findReplacement(Placeholders.parseText((class_2561)version.newTextComponent(placeholder), (PlaceholderContext)PlaceholderContext.of((class_3222)ctx.player())).getString()));
                }
            } while (!textBefore.equals(text));
            return PlaceholderResult.value((String)text);
        });
        this.registerPlaceholder("placeholder", (ctx, arg) -> {
            BridgePlayer pl2;
            if (!ctx.hasPlayer()) {
                return PlaceholderResult.invalid((String)"No player!");
            }
            if (arg == null) {
                return PlaceholderResult.invalid((String)"No placeholder!");
            }
            BridgePlayer player = TABBridge.getInstance().getPlayer(ctx.player().method_5667());
            String placeholder = "%" + arg + "%";
            if (!this.sentRequests.computeIfAbsent(player, pl -> new HashSet()).contains(placeholder) && (pl2 = TABBridge.getInstance().getPlayer(player.getUniqueId())) != null) {
                this.sentRequests.get(player).add(placeholder);
                pl2.sendPluginMessage(new RegisterPlaceholder(placeholder));
            }
            return PlaceholderResult.value((String)this.values.get(player).get(arg));
        });
    }

    private void registerPlaceholder(String identifier, PlaceholderHandler handler) {
        Placeholders.register((class_2960)class_2960.method_12829((String)("tab:" + identifier)), (PlaceholderHandler)handler);
    }

    @Override
    public void setValue(@NotNull BridgePlayer player, @NotNull String identifier, @NotNull String value) {
        this.values.computeIfAbsent(player, p -> new HashMap()).put(identifier, value);
    }

    @Override
    public boolean unregister() {
        return false;
    }

    @Generated
    public Map<BridgePlayer, Map<String, String>> getValues() {
        return this.values;
    }

    @Generated
    public Map<BridgePlayer, Set<String>> getSentRequests() {
        return this.sentRequests;
    }
}

