/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.fabric.v1_21_8;

import com.mojang.authlib.GameProfile;
import lombok.NonNull;
import me.neznamy.tab.bridge.fabric.VersionLoader;
import me.neznamy.tab.bridge.shared.TABBridge;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class VersionLoaderImpl
implements VersionLoader {
    @Override
    public void registerListeners() {
        PayloadTypeRegistry.playC2S().register(TabCustomPacketPayload.TYPE, TabCustomPacketPayload.codec(Integer.MAX_VALUE));
        PayloadTypeRegistry.configurationC2S().register(TabCustomPacketPayload.TYPE, TabCustomPacketPayload.codec(Integer.MAX_VALUE));
        PayloadTypeRegistry.playS2C().register(TabCustomPacketPayload.TYPE, TabCustomPacketPayload.codec(Integer.MAX_VALUE));
        PayloadTypeRegistry.configurationS2C().register(TabCustomPacketPayload.TYPE, TabCustomPacketPayload.codec(Integer.MAX_VALUE));
        ServerPlayNetworking.registerGlobalReceiver(TabCustomPacketPayload.TYPE, TabCustomPacketPayload::handle);
        ServerConfigurationNetworking.registerGlobalReceiver(TabCustomPacketPayload.TYPE, TabCustomPacketPayload::handle);
    }

    @Override
    public void sendCustomPayload(@NonNull class_3222 player, byte @NonNull [] message) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new TabCustomPacketPayload(message));
    }

    @Override
    @NotNull
    public class_1937 getLevel(@NonNull class_3222 player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return player.method_51469();
    }

    @Override
    @NotNull
    public class_2561 newTextComponent(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return class_2561.method_43470((String)text);
    }

    @Override
    @NotNull
    public String getName(@NonNull GameProfile profile) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        return profile.getName();
    }

    public record TabCustomPacketPayload(byte[] data) implements class_8710
    {
        public static final class_8710.class_9154<TabCustomPacketPayload> TYPE = new class_8710.class_9154(VersionLoader.ID);

        public static <T extends class_2540> class_9139<T, TabCustomPacketPayload> codec(int maxSize) {
            return class_8710.method_56484((value, output) -> output.method_52983(value.data), buffer -> {
                int i = buffer.readableBytes();
                if (i >= 0 && i <= maxSize) {
                    byte[] data = new byte[i];
                    buffer.method_52979(data);
                    return new TabCustomPacketPayload(data);
                }
                throw new IllegalArgumentException("Payload may not be larger than " + maxSize + " bytes");
            });
        }

        @NotNull
        public class_8710.class_9154<TabCustomPacketPayload> method_56479() {
            return TYPE;
        }

        public void handle(@NonNull ServerPlayNetworking.Context context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            TABBridge.getInstance().submitTask(() -> TABBridge.getInstance().getDataBridge().processPluginMessage(context.player(), context.player().method_5667(), this.data, false));
        }

        public void handle(@NonNull ServerConfigurationNetworking.Context context) {
            if (context == null) {
                throw new NullPointerException("context is marked non-null but is null");
            }
            TABBridge.getInstance().submitTask(() -> TABBridge.getInstance().getDataBridge().processPluginMessage(context.networkHandler().method_52404().getId(), this.data, false));
        }
    }
}

