/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.bridge.shared.placeholder;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class PlaceholderReplacementPattern {
    @NotNull
    private final Map<String, String> replacements = new HashMap<String, String>();
    @NotNull
    private final Map<float[], String> numberIntervals = new HashMap<float[], String>();

    public PlaceholderReplacementPattern(@NonNull String identifier, @NonNull Map<Object, Object> map) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue()).replace(identifier, "%value%");
            this.replacements.put(key, value);
            if ("true".equals(key)) {
                this.replacements.put("yes", value);
                this.replacements.put("Yes", value);
                continue;
            }
            if ("false".equals(key)) {
                this.replacements.put("no", value);
                this.replacements.put("No", value);
                continue;
            }
            if (!key.contains("-")) continue;
            try {
                this.numberIntervals.put(new float[]{Float.parseFloat(key.split("-")[0]), Float.parseFloat(key.split("-")[1])}, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.numberIntervals.put(new float[]{Float.parseFloat(key.split("~")[0]), Float.parseFloat(key.split("~")[1])}, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @NotNull
    public String findReplacement(@NonNull String output) {
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        String replacement = this.findReplacement0(output);
        if (replacement.contains("%value%")) {
            replacement = replacement.replace("%value%", output);
        }
        return replacement;
    }

    @NotNull
    private String findReplacement0(@NonNull String output) {
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        if (this.replacements.isEmpty()) {
            return output;
        }
        if (this.replacements.containsKey(output)) {
            return this.replacements.get(output);
        }
        if (!this.numberIntervals.isEmpty()) {
            try {
                String cleanValue = output.contains(",") ? output.replace(",", "") : output;
                float value = Float.parseFloat(cleanValue);
                for (float[] interval : this.numberIntervals.keySet()) {
                    if (!(interval[0] <= value) || !(value <= interval[1])) continue;
                    return this.numberIntervals.get(interval);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.replacements.containsKey("else")) {
            return this.replacements.get("else");
        }
        return output;
    }
}

