/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.command.calculations;

import com.mojang.brigadier.context.CommandContext;
import java.text.DecimalFormat;
import net.cyvfabric.CyvFabric;
import net.cyvfabric.util.CyvCommand;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_310;

public class CommandOptimizeSensitivity
extends CyvCommand {
    public CommandOptimizeSensitivity() {
        super("optimizesensitivity");
        this.usage = "<angle>";
        this.helpString = "Optimize current sensitivity to be able to turn given degree in a whole number of pixels.";
        this.aliases.add("os");
        this.aliases.add("optimizesens");
        this.aliases.add("optimisesens");
        this.aliases.add("optimisesensitivity");
    }

    @Override
    public void run(CommandContext<FabricClientCommandSource> context, String[] args) {
        try {
            double angle = Math.abs(Float.parseFloat(args[0]));
            double currentSens = (Double)class_310.method_1551().field_1690.method_42495().method_41753();
            double currentPx = angle / 1.2 / Math.pow(currentSens * 0.6 + 0.2, 3.0);
            double newSens = (Math.cbrt(angle / (1.2 * (double)Math.round(currentPx))) - 0.2) / 0.6;
            if (currentSens > 1.0 || currentSens < 0.0) {
                CyvFabric.sendChatMessage("Sensitivity optimising unavailable for sensitivities above 200% or below 0%.");
                return;
            }
            if (Math.round(currentPx) == 0L) {
                CyvFabric.sendChatMessage("Angle is too low to optimize for.");
            } else {
                class_310.method_1551().field_1690.method_42495().method_41748((Object)newSens);
                class_310.method_1551().field_1690.method_1640();
                double percentage = 200.0 * newSens;
                DecimalFormat df = CyvFabric.df;
                CyvFabric.sendChatMessage("Sensitivity optimized to " + df.format(percentage) + "%\nPixels of turning: " + Math.round(currentPx));
            }
        }
        catch (Exception e) {
            CyvFabric.sendChatMessage("Please input a valid turning angle to optimize for.");
        }
    }
}

