/*
 * Decompiled with CFR 0.152.
 */
package net.cyvfabric.gui;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.cyvfabric.config.CyvClientColorHelper;
import net.cyvfabric.gui.GuiMPK;
import net.cyvfabric.hud.HUDManager;
import net.cyvfabric.hud.structure.DraggableHUDElement;
import net.cyvfabric.hud.structure.IRenderer;
import net.cyvfabric.hud.structure.ScreenPosition;
import net.cyvfabric.util.CyvGui;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class GuiHUDPositions
extends CyvGui {
    protected final HashMap<DraggableHUDElement, ScreenPosition> renderers = new HashMap();
    protected Optional<DraggableHUDElement> selectedRenderer = Optional.empty();
    protected double prevX;
    protected double prevY;
    protected final boolean fromLabels;

    public GuiHUDPositions(boolean fromLabels) {
        super("HUD Position");
        List<DraggableHUDElement> registeredRenderers = HUDManager.registeredRenderers;
        this.fromLabels = fromLabels;
        for (DraggableHUDElement renderer : registeredRenderers) {
            if (!renderer.isEnabled) continue;
            ScreenPosition pos = renderer.load();
            if (pos == null) {
                pos = renderer.getDefaultPosition();
            }
            this.adjustBounds(renderer, pos);
            this.renderers.put(renderer, pos);
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.method_52752(context);
        context.method_49601(0, 0, this.field_22789, this.field_22790, Long.valueOf(CyvClientColorHelper.color1.drawColor).intValue());
        for (DraggableHUDElement renderer : this.renderers.keySet()) {
            ScreenPosition pos = this.renderers.get(renderer);
            if (!renderer.isDraggable) {
                pos = renderer.getDefaultPosition();
            }
            renderer.renderDummy(context, pos);
            int color = Long.valueOf(CyvClientColorHelper.color1.drawColor).intValue();
            if (!renderer.isVisible) {
                color = -5592406;
            }
            context.method_49601(pos.getAbsoluteX(), pos.getAbsoluteY(), renderer.getWidth(), renderer.getHeight(), color);
        }
    }

    public boolean method_25400(char typedChar, int keyCode) {
        if (keyCode == 256) {
            this.renderers.entrySet().forEach(entry -> ((DraggableHUDElement)entry.getKey()).save((ScreenPosition)entry.getValue()));
            if (this.fromLabels) {
                class_310.method_1551().method_1507((class_437)new GuiMPK());
            } else {
                this.method_25419();
            }
            return true;
        }
        if (keyCode == 265) {
            if (this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
                this.moveSelectedRenderBy(0, -1);
                return true;
            }
        } else if (keyCode == 263) {
            if (this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
                this.moveSelectedRenderBy(-1, 0);
                return true;
            }
        } else if (keyCode == 264) {
            if (this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
                this.moveSelectedRenderBy(0, 1);
                return true;
            }
        } else if (keyCode == 262 && this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
            this.moveSelectedRenderBy(1, 0);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.selectedRenderer.isPresent()) {
            if (this.selectedRenderer.get().isDraggable) {
                this.prevX += deltaX;
                this.prevY += deltaY;
                this.moveSelectedRenderBy((int)this.prevX, (int)this.prevY);
                this.prevX -= (double)((int)this.prevX);
                this.prevY -= (double)((int)this.prevY);
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double x, double y, int mouseButton) {
        this.prevX = 0.0;
        this.prevY = 0.0;
        this.loadMouseOver((int)x, (int)y);
        if (mouseButton == 1) {
            if (!this.selectedRenderer.isPresent()) {
                return false;
            }
            DraggableHUDElement modRender = this.selectedRenderer.get();
            modRender.isVisible = !modRender.isVisible;
            return true;
        }
        return false;
    }

    private void loadMouseOver(int x, int y) {
        this.selectedRenderer = this.renderers.keySet().stream().filter(new MouseOverFinder(x, y)).findFirst();
    }

    private void moveSelectedRenderBy(int offsetX, int offsetY) {
        IRenderer renderer = this.selectedRenderer.get();
        ScreenPosition pos = this.renderers.get(renderer);
        pos.setAbsolute(pos.getAbsoluteX() + offsetX, pos.getAbsoluteY() + offsetY);
        this.adjustBounds(renderer, pos);
    }

    public void method_25432() {
        for (IRenderer iRenderer : this.renderers.keySet()) {
            iRenderer.save(this.renderers.get(iRenderer));
        }
    }

    private void adjustBounds(IRenderer renderer, ScreenPosition pos) {
        class_1041 res = class_310.method_1551().method_22683();
        int screenWidth = res.method_4486();
        int screenHeight = res.method_4502();
        int absoluteX = Math.max(0, Math.min(pos.getAbsoluteX(), Math.max(screenWidth - renderer.getWidth(), 0)));
        int absoluteY = Math.max(0, Math.min(pos.getAbsoluteY(), Math.max(screenHeight - renderer.getHeight(), 0)));
        pos.setAbsolute(absoluteX, absoluteY);
    }

    private class MouseOverFinder
    implements Predicate<IRenderer> {
        private int mouseX;
        private int mouseY;

        public MouseOverFinder(int x, int y) {
            this.mouseX = x;
            this.mouseY = y;
        }

        @Override
        public boolean test(IRenderer renderer) {
            ScreenPosition pos = GuiHUDPositions.this.renderers.get(renderer);
            int absoluteX = pos.getAbsoluteX();
            int absoluteY = pos.getAbsoluteY();
            return this.mouseX >= absoluteX && this.mouseX <= absoluteX + renderer.getWidth() && this.mouseY >= absoluteY && this.mouseY <= absoluteY + renderer.getHeight();
        }
    }
}

