/*
 * Decompiled with CFR 0.152.
 */
package mcpk;

import java.text.DecimalFormat;
import java.util.ArrayList;
import mcpk.utils.Arguments;
import mcpk.utils.MathHelper;

public class Player {
    public static byte df = (byte)16;
    public int tick = 0;
    public double xOf = 0.0;
    public double zOf = 0.0;
    public double highestZ = 0.0;
    public double lowestZ = 0.0;
    public double highestX = 0.0;
    public double lowestX = 0.0;
    public double finalX;
    public double finalZ;
    public ArrayList<Double> xCoords = new ArrayList();
    public ArrayList<Double> zCoords = new ArrayList();
    public double x = 0.0;
    public double z = 0.0;
    public double vx = 0.0;
    public double vz = 0.0;
    public double slip = 0.0;
    public double last_slip = 0.0;
    public double multiplier = 0.0;

    public void move(Arguments args) {
        int duration = (Integer)args.get("duration");
        boolean airborne = (Boolean)args.get("airborne");
        boolean sprinting = (Boolean)args.get("sprinting");
        boolean sneaking = (Boolean)args.get("sneaking");
        boolean jumping = (Boolean)args.get("jumping");
        float facing = ((Float)args.get("facing")).floatValue();
        boolean blocking = (Double)args.get("blocking") == 1.0;
        boolean soulsand = (Double)args.get("soulsand") == 1.0;
        int swiftness = ((Double)args.get("swiftness")).intValue();
        int slowness = ((Double)args.get("slowness")).intValue();
        for (int i = 1; i <= Math.abs(duration); ++i) {
            float distance;
            if (jumping) {
                if (!this.xCoords.contains(this.xOf)) {
                    this.xCoords.add(this.xOf);
                    this.xCoords.add(this.xOf);
                }
                if (!this.zCoords.contains(this.zOf)) {
                    this.zCoords.add(this.zOf);
                    this.zCoords.add(this.zOf);
                }
            }
            ++this.tick;
            this.multiplier = 1.0;
            float forward = ((Integer)args.get("forward")).intValue();
            float strafing = ((Integer)args.get("strafing")).intValue();
            float boost = 0.2f;
            this.slip = airborne ? 1.0 : (double)((Double)args.get("slip")).floatValue();
            if (this.last_slip == 0.0) {
                this.last_slip = this.slip;
            }
            if (forward < 0.0f) {
                boost *= -1.0f;
            }
            this.z += this.vz;
            this.x += this.vx;
            this.zOf += this.vz;
            this.xOf += this.vx;
            this.vx *= (double)0.91f * this.last_slip;
            this.vz *= (double)0.91f * this.last_slip;
            if (Math.abs(this.vz) < 0.005) {
                this.vz = 0.0;
            }
            if (Math.abs(this.vx) < 0.005) {
                this.vx = 0.0;
            }
            float accel = 0.0f;
            double drag = (double)0.91f * this.slip;
            if (airborne) {
                accel = 0.02f;
                if (sprinting) {
                    accel = (float)((double)accel + (double)accel * 0.3);
                }
            } else {
                accel = 0.1f;
                accel = (float)((double)accel * (0.16277135908603668 / (drag * drag * drag)));
                if (swiftness > 0) {
                    accel = (float)((double)accel * (1.0 + (double)(0.2f * (float)swiftness)));
                }
                if (slowness > 0) {
                    accel = (float)((double)accel * Math.max(1.0 + (double)(-0.15f * (float)slowness), 0.0));
                }
                if (sprinting) {
                    accel = (float)((double)accel * 1.300000011920929);
                }
            }
            if (sprinting && jumping) {
                float angle = facing * ((float)Math.PI / 180);
                this.vz += (double)(boost * MathHelper.cos(angle));
                this.vx -= (double)(boost * MathHelper.sin(angle));
            }
            if (blocking) {
                forward *= 0.2f;
                strafing *= 0.2f;
            }
            if (sneaking) {
                forward = (float)((double)forward * 0.3);
                strafing = (float)((double)strafing * 0.3);
            }
            if ((distance = (strafing *= 0.98f) * strafing + (forward *= 0.98f) * forward) >= 1.0E-4f) {
                if ((distance = (float)Math.sqrt(distance)) < 1.0f) {
                    distance = 1.0f;
                }
                distance = accel / distance;
                float angle = facing * (float)Math.PI / 180.0f;
                this.vx += (double)((strafing *= distance) * MathHelper.cos(angle) - (forward *= distance) * MathHelper.sin(angle));
                this.vz += (double)(forward * MathHelper.cos(angle) + strafing * MathHelper.sin(angle));
            }
            this.last_slip = this.slip;
            if (airborne) continue;
            this.updateMM();
        }
    }

    void updateMM() {
        this.xCoords.add(this.xOf);
        this.zCoords.add(this.zOf);
    }

    public void updateBounds() {
        this.xCoords.sort((c1, c2) -> Double.compare(c1, c2));
        this.zCoords.sort((c1, c2) -> Double.compare(c1, c2));
        this.xCoords.remove(this.xCoords.size() - 1);
        this.zCoords.remove(this.zCoords.size() - 1);
        this.zCoords.remove(0);
        this.xCoords.remove(0);
        if (!this.xCoords.contains(this.finalX)) {
            this.xCoords.add(this.finalX);
        }
        if (!this.zCoords.contains(this.finalZ)) {
            this.zCoords.add(this.finalZ);
        }
        this.xCoords.sort((c1, c2) -> Double.compare(c1, c2));
        this.zCoords.sort((c1, c2) -> Double.compare(c1, c2));
        this.lowestZ = this.zCoords.get(0);
        this.highestZ = this.zCoords.get(this.zCoords.size() - 1);
        this.lowestX = this.xCoords.get(0);
        this.highestX = this.xCoords.get(this.xCoords.size() - 1);
    }

    public void print() {
        DecimalFormat formatting = new DecimalFormat("#");
        formatting.setMaximumFractionDigits(df);
        this.updateBounds();
        System.out.println("z: " + formatting.format(this.z));
        System.out.println("vz: " + formatting.format(this.vz));
        System.out.println("zmm: " + formatting.format(this.highestZ - this.lowestZ));
        System.out.println("x: " + formatting.format(this.x));
        System.out.println("vx: " + formatting.format(this.vx));
        System.out.println("xmm: " + formatting.format(this.highestX - this.lowestX));
        System.out.println("vector: " + formatting.format(Math.hypot(this.vz, this.vx)));
        System.out.println("angle: " + Math.atan2(-this.vx, this.vz) * 180.0 / Math.PI);
    }
}

