/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.command;

import java.util.ArrayList;
import net.cyvforge.CyvForge;
import net.cyvforge.config.CyvClientColorHelper;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.event.CommandInitializer;
import net.cyvforge.util.defaults.CyvCommand;
import net.minecraft.command.ICommandSender;

public class CommandHelp
extends CyvCommand {
    public CommandHelp() {
        super("help");
        this.usage = "[subcommand]";
        this.helpString = "Get the subcommand help menu for the " + this.parent + " command.";
    }

    @Override
    public void run(ICommandSender sender, String[] args) {
        ArrayList<String> helpText;
        ArrayList<CyvCommand> subCommands;
        String commandName;
        String commandPath;
        if (this.parent == null) {
            commandPath = "/cyv help";
            commandName = "cyv";
            subCommands = CommandInitializer.cyvCommands;
        } else {
            commandPath = "/cyv " + this.parent.name + " help";
            commandName = this.parent.name;
            subCommands = this.parent.subCommands;
        }
        if (args.length == 0 && !subCommands.isEmpty()) {
            helpText = new ArrayList<String>();
            helpText.add(CyvClientColorHelper.color1.getChatFormatting() + commandName + " help menu:\u00a7r");
            String chatColor2 = CyvClientConfig.getBoolean("whiteChat", false) ? CyvClientColorHelper.colors.get(12).getChatFormatting() : CyvClientColorHelper.color2.getChatFormatting();
            for (CyvCommand c : subCommands) {
                helpText.add(CyvClientColorHelper.color1.getChatFormatting() + c.name + ": " + chatColor2 + c.helpString);
            }
        } else {
            CyvCommand targetCommand;
            block12: {
                targetCommand = null;
                if (args.length > 0) {
                    for (CyvCommand cmd : subCommands) {
                        if (!cmd.name.toLowerCase().equals(args[0])) {
                            for (String s : cmd.aliases) {
                                if (!s.toLowerCase().equals(args[0])) continue;
                                targetCommand = cmd;
                                break block12;
                            }
                            continue;
                        }
                        targetCommand = cmd;
                        break;
                    }
                } else {
                    targetCommand = this.parent;
                }
            }
            if (targetCommand == null) {
                CyvForge.sendChatMessage("Command not found. Use " + commandPath + " for a list of commands.");
                return;
            }
            ArrayList<String> commandNames = new ArrayList<String>();
            commandNames.add(targetCommand.name);
            if (targetCommand.aliases != null) {
                commandNames.addAll(targetCommand.aliases);
            }
            CyvForge.sendChatMessage("Command: /" + args[0] + "\nAliases: " + String.join((CharSequence)", ", commandNames) + "\nUsage: " + targetCommand.usage + "\n" + targetCommand.getDetailedHelp() + "\n" + CyvClientColorHelper.color1.getChatFormatting() + "\u00a7oNote: Use " + commandPath + " to list subcommands.");
            return;
        }
        helpText.add(CyvClientColorHelper.color1.getChatFormatting() + "\u00a7oNote: Use " + commandPath + " [command] for details");
        CyvForge.sendChatMessage(String.join((CharSequence)"\n", helpText));
    }
}

