/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.command.calculations;

import java.text.DecimalFormat;
import net.cyvforge.CyvForge;
import net.cyvforge.util.defaults.CyvCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;

public class CommandOptimizeSensitivity
extends CyvCommand {
    public CommandOptimizeSensitivity() {
        super("optimizesensitivity");
        this.usage = "<angle>";
        this.helpString = "Optimize current sensitivity to be able to turn given degree in a whole number of pixels.";
        this.aliases.add("os");
        this.aliases.add("optimizesens");
        this.aliases.add("optimisesens");
        this.aliases.add("optimisesensitivity");
    }

    @Override
    public void run(ICommandSender sender, String[] args) {
        try {
            double angle = Math.abs(Float.parseFloat(args[0]));
            float currentSens = Minecraft.func_71410_x().field_71474_y.field_74341_c;
            double currentPx = angle / 1.2 / Math.pow((double)currentSens * 0.6 + 0.2, 3.0);
            double newSens = (Math.cbrt(angle / (1.2 * (double)Math.round(currentPx))) - 0.2) / 0.6;
            if (newSens > 1.0) {
                newSens = (Math.cbrt(angle / (1.2 * Math.ceil(currentPx))) - 0.2) / 0.6;
            } else if (newSens < 0.0) {
                newSens = (Math.cbrt(angle / (1.2 * Math.floor(currentPx))) - 0.2) / 0.6;
            }
            if (currentSens > 1.0f || currentSens < 0.0f) {
                CyvForge.sendChatMessage("Sensitivity optimising unavailable for sensitivities above 200% or below 0%.");
                return;
            }
            if (Math.round(currentPx) == 0L) {
                CyvForge.sendChatMessage("Angle is too low to optimize for.");
            } else {
                Minecraft.func_71410_x().field_71474_y.field_74341_c = (float)newSens;
                Minecraft.func_71410_x().field_71474_y.func_74303_b();
                double percentage = 200.0 * newSens;
                DecimalFormat df = CyvForge.df;
                CyvForge.sendChatMessage("Sensitivity optimized to " + df.format(percentage) + "%\nPixels of turning: " + Math.round(currentPx));
            }
        }
        catch (Exception e) {
            CyvForge.sendChatMessage("Please input a valid turning angle to optimize for.");
        }
    }
}

