/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.command.checkpoint;

import java.text.DecimalFormat;
import java.util.Arrays;
import net.cyvforge.CyvForge;
import net.cyvforge.util.defaults.CyvCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemArmorStand;
import net.minecraft.item.ItemBed;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBoat;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemEditableBook;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemEnderEye;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemExpBottle;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemFireworkCharge;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemHangingEntity;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemSaddle;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemSign;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;

public class CommandCheckpoint
extends CyvCommand {
    public CommandCheckpoint() {
        super("checkpoint");
        this.hasArgs = true;
        this.usage = "[x] [y] [z] [yaw] [pitch] [optional custom name]";
        this.helpString = "Convert an item into a checkpoint item with custom coords binded to it. If no coordinate provided, defaults to your current position.";
        this.aliases.add("cp");
        this.aliases.add("setcheckpoint");
        this.aliases.add("setcp");
    }

    @Override
    public void run(ICommandSender sender, String[] args) {
        ItemStack item;
        if (!MinecraftServer.func_71276_C().func_71264_H()) {
            CyvForge.sendChatMessage("Checkpoint teleporter items cannot be created in multiplayer.");
            return;
        }
        try {
            item = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
            if (this.isBannedItem(item.func_77973_b())) {
                CyvForge.sendChatMessage("This item cannot be converted to a checkpoint item.");
                return;
            }
        }
        catch (Exception e) {
            CyvForge.sendChatMessage("Hold an item to convert to a checkpoint item.");
            return;
        }
        try {
            EntityPlayerSP player;
            NBTTagCompound nbt = new NBTTagCompound();
            if (args.length == 0) {
                player = Minecraft.func_71410_x().field_71439_g;
                DecimalFormat df = CyvForge.df;
                nbt.func_74780_a("coordX", Double.parseDouble(df.format(player.field_70165_t)));
                nbt.func_74780_a("coordY", Double.parseDouble(df.format(player.field_70163_u)));
                nbt.func_74780_a("coordZ", Double.parseDouble(df.format(player.field_70161_v)));
                nbt.func_74776_a("coordYaw", Float.parseFloat(df.format(player.field_70177_z)));
                nbt.func_74776_a("coordPitch", Float.parseFloat(df.format(player.field_70125_A)));
                NBTTagList lore = new NBTTagList();
                lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eCheckpoint Teleport Item"));
                lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eCoords: \u00a7b" + df.format(player.field_70165_t) + " / " + df.format(player.field_70163_u) + " / " + df.format(player.field_70161_v) + " (" + df.format(player.field_70177_z) + " / " + df.format(player.field_70125_A) + ")"));
                NBTTagCompound display = new NBTTagCompound();
                display.func_74782_a("Lore", (NBTBase)lore);
                nbt.func_74782_a("display", (NBTBase)display);
            } else {
                nbt.func_74780_a("coordX", Double.parseDouble(args[0]));
                nbt.func_74780_a("coordY", Double.parseDouble(args[1]));
                nbt.func_74780_a("coordZ", Double.parseDouble(args[2]));
                nbt.func_74776_a("coordYaw", Float.parseFloat(args[3]));
                nbt.func_74776_a("coordPitch", Float.parseFloat(args[4]));
                NBTTagList lore = new NBTTagList();
                lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eCheckpoint Teleport Item"));
                lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eCoords: \u00a7b" + args[0] + " / " + args[1] + " / " + args[2] + " (" + args[3] + " / " + args[4] + ")"));
                NBTTagCompound display = new NBTTagCompound();
                display.func_74782_a("Lore", (NBTBase)lore);
                nbt.func_74782_a("display", (NBTBase)display);
            }
            nbt.func_74757_a("isCP", true);
            player = CommandBase.func_82359_c((ICommandSender)Minecraft.func_71410_x().field_71439_g, (String)Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            player.func_70694_bm().func_77982_d(nbt);
            if (args.length > 5) {
                CharSequence[] customName = Arrays.copyOfRange(args, 5, args.length);
                String joinedCustomName = String.join((CharSequence)" ", customName);
                player.func_70694_bm().func_151001_c("\u00a7c" + joinedCustomName);
            } else {
                player.func_70694_bm().func_151001_c("\u00a7cCheckpoint Item");
            }
        }
        catch (Exception e) {
            CyvForge.sendChatMessage("Please enter valid coords.");
            return;
        }
        try {
            CyvForge.sendChatMessage("Checkpoint Teleporter coords of " + item.func_82833_r() + "\u00a7f set to " + args[0] + " " + args[1] + " " + args[2] + " " + args[3] + " " + args[4] + ".");
        }
        catch (Exception e) {
            CyvForge.sendChatMessage("Checkpoint Teleporter coords of " + item.func_82833_r() + "\u00a7f set.");
        }
    }

    public boolean isBannedItem(Item item) {
        boolean isBanned = item instanceof ItemArmor;
        isBanned = isBanned || item instanceof ItemArmorStand;
        isBanned = isBanned || item instanceof ItemBed;
        isBanned = isBanned || item instanceof ItemBlock;
        isBanned = isBanned || item instanceof ItemBoat;
        isBanned = isBanned || item instanceof ItemBow;
        isBanned = isBanned || item instanceof ItemBucket;
        isBanned = isBanned || item instanceof ItemBucketMilk;
        isBanned = isBanned || item instanceof ItemDoor;
        isBanned = isBanned || item instanceof ItemEditableBook;
        isBanned = isBanned || item instanceof ItemEgg;
        isBanned = isBanned || item instanceof ItemEnderEye;
        isBanned = isBanned || item instanceof ItemEnderPearl;
        isBanned = isBanned || item instanceof ItemExpBottle;
        isBanned = isBanned || item instanceof ItemFireball;
        isBanned = isBanned || item instanceof ItemFirework;
        isBanned = isBanned || item instanceof ItemFireworkCharge;
        isBanned = isBanned || item instanceof ItemFishingRod;
        isBanned = isBanned || item instanceof ItemFlintAndSteel;
        isBanned = isBanned || item instanceof ItemFood;
        isBanned = isBanned || item instanceof ItemGlassBottle;
        isBanned = isBanned || item instanceof ItemHangingEntity;
        isBanned = isBanned || item instanceof ItemHoe;
        isBanned = isBanned || item instanceof ItemLead;
        isBanned = isBanned || item instanceof ItemMapBase;
        isBanned = isBanned || item instanceof ItemMinecart;
        isBanned = isBanned || item instanceof ItemMonsterPlacer;
        isBanned = isBanned || item instanceof ItemPotion;
        isBanned = isBanned || item instanceof ItemRecord;
        isBanned = isBanned || item instanceof ItemRedstone;
        isBanned = isBanned || item instanceof ItemReed;
        isBanned = isBanned || item instanceof ItemSaddle;
        isBanned = isBanned || item instanceof ItemSeeds;
        isBanned = isBanned || item instanceof ItemSign;
        isBanned = isBanned || item instanceof ItemSkull;
        isBanned = isBanned || item instanceof ItemSnowball;
        isBanned = isBanned || item instanceof ItemSword;
        isBanned = isBanned || item instanceof ItemWritableBook;
        return isBanned;
    }
}

