/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.command.checkpoint;

import java.text.DecimalFormat;
import java.util.Arrays;
import net.cyvforge.CyvForge;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.util.defaults.CyvCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;

public class CommandGiveCheckpointGenerator
extends CyvCommand {
    public CommandGiveCheckpointGenerator() {
        super("getcheckpointgenerator");
        this.hasArgs = true;
        this.usage = "[x] [y] [z] [yaw] [pitch] [optional custom name]";
        this.helpString = "Give the player a custom command block capable of creating a checkpoint item. If no coordinate provided, defaults to your current position.";
        this.aliases.add("getcpgenerator");
        this.aliases.add("getcpgen");
    }

    @Override
    public void run(ICommandSender sender, String[] args) {
        if (!MinecraftServer.func_71276_C().func_71264_H()) {
            CyvForge.sendChatMessage("Checkpoint generators cannot be created in multiplayer.");
            return;
        }
        try {
            String name;
            String coordPitch;
            String coordYaw;
            String coordZ;
            String coordY;
            String coordX;
            EntityPlayerMP player = CommandBase.func_82359_c((ICommandSender)Minecraft.func_71410_x().field_71439_g, (String)Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            String itemName = "dye";
            String itemData = "" + CyvClientConfig.getInt("generatorDyeColor", 1);
            String slot = "" + CyvClientConfig.getInt("generatorItemSlot", 0);
            if (args.length == 0) {
                DecimalFormat df = CyvForge.df;
                coordX = df.format(player.field_70165_t);
                coordY = df.format(player.field_70163_u);
                coordZ = df.format(player.field_70161_v);
                coordYaw = df.format(player.field_70177_z);
                coordPitch = df.format(player.field_70125_A);
            } else {
                coordX = args[0];
                coordY = args[1];
                coordZ = args[2];
                coordYaw = args[3];
                coordPitch = args[4];
            }
            if (args.length > 5) {
                CharSequence[] customName = Arrays.copyOfRange(args, 5, args.length);
                String joinedCustomName = String.join((CharSequence)" ", customName);
                name = "\u00a7c" + joinedCustomName;
            } else {
                name = "\u00a7cCheckpoint Item";
            }
            String command = "replaceitem entity @p slot.hotbar." + slot + " " + itemName + " 1 " + itemData + " {display:{Name:\"" + name + "\u00a7r" + "\",Lore:[0:\"" + "\u00a7e" + "Checkpoint Teleport Item" + "\u00a7r" + "\",1:\"" + "\u00a7e" + "Coords: " + "\u00a7b" + coordX + " / " + coordY + " / " + coordZ + " (" + coordYaw + " / " + coordPitch + ")" + "\u00a7r" + "\"]},isCP:true,coordX:" + coordX + ",coordY:" + coordY + ",coordZ:" + coordZ + ",coordYaw:" + coordYaw + ",coordPitch:" + coordPitch + "}";
            Item item = CommandBase.func_147179_f((ICommandSender)Minecraft.func_71410_x().field_71439_g, (String)"command_block");
            ItemStack itemStack = new ItemStack(item, 1, 0);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("BlockEntityTag", (NBTBase)new NBTTagCompound());
            nbtTagCompound.func_74775_l("BlockEntityTag").func_74778_a("Command", command);
            nbtTagCompound.func_74782_a("display", (NBTBase)new NBTTagCompound());
            nbtTagCompound.func_74775_l("display").func_74778_a("Name", "\u00a7cCheckpoint Generator");
            NBTTagList lore = new NBTTagList();
            lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eCheckpoint Generator Block"));
            lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eCoords: \u00a7b" + coordX + " / " + coordY + " / " + coordZ + " (" + coordYaw + " / " + coordPitch + ")"));
            lore.func_74742_a((NBTBase)new NBTTagString("\u00a7eName: " + name));
            nbtTagCompound.func_74775_l("display").func_74782_a("Lore", (NBTBase)lore);
            itemStack.func_77982_d(nbtTagCompound);
            EntityItem entityItem = player.func_71019_a(itemStack, false);
            entityItem.func_174868_q();
            entityItem.func_145797_a(player.func_70005_c_());
        }
        catch (Exception e) {
            CyvForge.sendChatMessage("Please enter valid coords.");
            return;
        }
        CyvForge.sendChatMessage("Checkpoint Generator Command Block successfully given.");
    }
}

