/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import net.cyvforge.CyvForge;
import net.cyvforge.hud.HUDManager;
import net.cyvforge.hud.structure.DraggableHUDElement;

public class CyvClientConfig {
    public HashMap<String, ConfigValue<?>> configFields = new LinkedHashMap();

    public void init() {
        this.configFields.put("color1", new ConfigValue<String>("aqua"));
        this.configFields.put("color2", new ConfigValue<String>("white"));
        this.configFields.put("theme", new ConfigValue<String>("CYVISPIRIA"));
        this.configFields.put("whiteChat", new ConfigValue<Boolean>(false));
        this.configFields.put("df", new ConfigValue<Integer>(5));
        this.configFields.put("trimZeroes", new ConfigValue<Boolean>(true));
        this.configFields.put("showMilliseconds", new ConfigValue<Boolean>(true));
        this.configFields.put("sendLbChatOffset", new ConfigValue<Boolean>(false));
        this.configFields.put("sendMmChatOffset", new ConfigValue<Boolean>(false));
        this.configFields.put("highlightLanding", new ConfigValue<Boolean>(false));
        this.configFields.put("highlightLandingCond", new ConfigValue<Boolean>(false));
        this.configFields.put("momentumPbCancelling", new ConfigValue<Boolean>(false));
        this.configFields.put("showFacingAxis", new ConfigValue<Boolean>(false));
        this.configFields.put("turnHUDAngleMin", new ConfigValue<Integer>(1));
        this.configFields.put("turnHUDAngleMax", new ConfigValue<Integer>(12));
        this.configFields.put("currentMacro", new ConfigValue<String>("macro"));
        this.configFields.put("smoothMacro", new ConfigValue<Boolean>(false));
        this.configFields.put("inertiaEnabled", new ConfigValue<Boolean>(false));
        this.configFields.put("inertiaTick", new ConfigValue<Integer>(4));
        this.configFields.put("inertiaMin", new ConfigValue<Double>(-0.02));
        this.configFields.put("inertiaMax", new ConfigValue<Double>(0.02));
        this.configFields.put("inertiaAxis", new ConfigValue<Character>(Character.valueOf('x')));
        this.configFields.put("inertiaGroundType", new ConfigValue<String>("normal"));
        this.configFields.put("positionCheckerEnabled", new ConfigValue<Boolean>(false));
        this.configFields.put("positionCheckerTick", new ConfigValue<Integer>(7));
        this.configFields.put("positionCheckerMinX", new ConfigValue<Double>(-10000.0));
        this.configFields.put("positionCheckerMaxX", new ConfigValue<Double>(10000.0));
        this.configFields.put("positionCheckerMinZ", new ConfigValue<Double>(-10000.0));
        this.configFields.put("positionCheckerMaxZ", new ConfigValue<Double>(10000.0));
        this.configFields.put("positionCheckerZNeo", new ConfigValue<Boolean>(false));
        this.configFields.put("singleplayerCheckpointsEnabled", new ConfigValue<Boolean>(true));
        this.configFields.put("generatorDyeColor", new ConfigValue<Integer>(1));
        this.configFields.put("generatorItemSlot", new ConfigValue<Integer>(0));
        for (DraggableHUDElement mod : HUDManager.registeredRenderers) {
            String name = mod.getName();
            mod.getConfigFields().forEach((property, configField) -> this.configFields.put(name + "_" + property, (ConfigValue<?>)configField));
        }
    }

    public static void set(String k, Object value) {
        try {
            CyvForge.config.configFields.get(k).set(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getInt(String k, int defaultValue) {
        try {
            return Integer.valueOf(CyvForge.config.configFields.get((Object)k).value.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static long getLong(String k, long defaultValue) {
        try {
            return Long.valueOf(CyvForge.config.configFields.get((Object)k).value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double getDouble(String k, double defaultValue) {
        try {
            return Double.valueOf(CyvForge.config.configFields.get((Object)k).value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(String k, boolean defaultValue) {
        try {
            return Boolean.valueOf(CyvForge.config.configFields.get((Object)k).value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static char getChar(String k, char defaultValue) {
        try {
            return CyvForge.config.configFields.get((Object)k).value.toString().toCharArray()[0];
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(String k, String defaultValue) {
        try {
            return CyvForge.config.configFields.get((Object)k).value.toString();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static enum Type {
        UNKNOWN,
        INTEGER,
        LONG,
        DOUBLE,
        BOOLEAN,
        CHARACTER,
        STRING;

    }

    public static class ConfigValue<T> {
        public T value;
        public T defaultValue;
        public Type type;

        public ConfigValue(T value) {
            this.value = value;
            this.defaultValue = value;
            this.type = value instanceof Integer ? Type.INTEGER : (value instanceof Long ? Type.LONG : (value instanceof Double ? Type.DOUBLE : (value instanceof Boolean ? Type.BOOLEAN : (value instanceof Character ? Type.CHARACTER : (value instanceof String ? Type.STRING : Type.UNKNOWN)))));
        }

        public void set(Object value) {
            try {
                this.value = value;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

