/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.cyvforge.config.CyvClientColorHelper;
import net.cyvforge.gui.GuiMPK;
import net.cyvforge.hud.HUDManager;
import net.cyvforge.hud.structure.DraggableHUDElement;
import net.cyvforge.hud.structure.IRenderer;
import net.cyvforge.hud.structure.ScreenPosition;
import net.cyvforge.util.GuiUtils;
import net.cyvforge.util.defaults.CyvGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;

public class GuiHUDPositions
extends CyvGui {
    protected final HashMap<DraggableHUDElement, ScreenPosition> renderers = new HashMap();
    protected Optional<DraggableHUDElement> selectedRenderer = Optional.empty();
    protected int prevX;
    protected int prevY;
    protected final boolean fromLabels;

    public GuiHUDPositions(boolean fromLabels) {
        super("HUD Position");
        List<DraggableHUDElement> registeredRenderers = HUDManager.registeredRenderers;
        this.fromLabels = fromLabels;
        for (DraggableHUDElement renderer : registeredRenderers) {
            if (!renderer.isEnabled) continue;
            ScreenPosition pos = renderer.load();
            if (pos == null) {
                pos = renderer.getDefaultPosition();
            }
            this.adjustBounds(renderer, pos);
            this.renderers.put(renderer, pos);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        float zBackup = this.field_73735_i;
        this.field_73735_i = 200.0f;
        int borderColor = (int)CyvClientColorHelper.color1.getDrawColor();
        GuiUtils.drawRectOutline(0, 0, this.field_146294_l - 1, this.field_146295_m - 1, borderColor);
        for (DraggableHUDElement renderer : this.renderers.keySet()) {
            ScreenPosition pos = this.renderers.get(renderer);
            if (!renderer.isDraggable) {
                pos = renderer.getDefaultPosition();
            }
            renderer.renderDummy(pos);
            int color = (int)CyvClientColorHelper.color1.getDrawColor();
            if (!renderer.isVisible) {
                color = -5592406;
            }
            GuiUtils.drawRectOutline(pos.getAbsoluteX(), pos.getAbsoluteY(), pos.getAbsoluteX() + renderer.getWidth(), pos.getAbsoluteY() + renderer.getHeight(), color);
        }
        this.field_73735_i = zBackup;
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.renderers.entrySet().forEach(entry -> ((DraggableHUDElement)entry.getKey()).save((ScreenPosition)entry.getValue()));
            if (this.fromLabels) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMPK());
            } else {
                Minecraft.func_71410_x().func_147108_a(null);
            }
            return;
        }
        if (keyCode == 200) {
            if (this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
                this.moveSelectedRenderBy(0, -1);
                return;
            }
        } else if (keyCode == 203) {
            if (this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
                this.moveSelectedRenderBy(-1, 0);
                return;
            }
        } else if (keyCode == 208) {
            if (this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
                this.moveSelectedRenderBy(0, 1);
                return;
            }
        } else if (keyCode == 205 && this.selectedRenderer.isPresent() && this.selectedRenderer.get().isDraggable) {
            this.moveSelectedRenderBy(1, 0);
            return;
        }
    }

    @Override
    public void func_146273_a(int x, int y, int mouseButton, long time) {
        if (mouseButton == 0) {
            if (this.selectedRenderer.isPresent()) {
                this.moveSelectedRenderBy(x - this.prevX, y - this.prevY);
            }
            this.prevX = x;
            this.prevY = y;
        }
    }

    public void func_73864_a(int x, int y, int mouseButton) throws IOException {
        this.prevX = x;
        this.prevY = y;
        this.loadMouseOver(x, y);
        if (mouseButton == 1) {
            if (!this.selectedRenderer.isPresent()) {
                return;
            }
            DraggableHUDElement modRender = this.selectedRenderer.get();
            modRender.isVisible = !modRender.isVisible;
        }
    }

    private void loadMouseOver(int x, int y) {
        this.selectedRenderer = this.renderers.keySet().stream().filter(new MouseOverFinder(x, y)).findFirst();
    }

    private void moveSelectedRenderBy(int offsetX, int offsetY) {
        IRenderer renderer = this.selectedRenderer.get();
        ScreenPosition pos = this.renderers.get(renderer);
        pos.setAbsolute(pos.getAbsoluteX() + offsetX, pos.getAbsoluteY() + offsetY);
        this.adjustBounds(renderer, pos);
    }

    @Override
    public void func_146281_b() {
        for (IRenderer iRenderer : this.renderers.keySet()) {
            iRenderer.save(this.renderers.get(iRenderer));
        }
    }

    private void adjustBounds(IRenderer renderer, ScreenPosition pos) {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int screenWidth = res.func_78326_a();
        int screenHeight = res.func_78328_b();
        int absoluteX = Math.max(0, Math.min(pos.getAbsoluteX(), Math.max(screenWidth - renderer.getWidth(), 0)));
        int absoluteY = Math.max(0, Math.min(pos.getAbsoluteY(), Math.max(screenHeight - renderer.getHeight(), 0)));
        pos.setAbsolute(absoluteX, absoluteY);
    }

    private class MouseOverFinder
    implements Predicate<IRenderer> {
        private int mouseX;
        private int mouseY;

        public MouseOverFinder(int x, int y) {
            this.mouseX = x;
            this.mouseY = y;
        }

        @Override
        public boolean test(IRenderer renderer) {
            ScreenPosition pos = GuiHUDPositions.this.renderers.get(renderer);
            int absoluteX = pos.getAbsoluteX();
            int absoluteY = pos.getAbsoluteY();
            return this.mouseX >= absoluteX && this.mouseX <= absoluteX + renderer.getWidth() && this.mouseY >= absoluteY && this.mouseY <= absoluteY + renderer.getHeight();
        }
    }
}

