/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.cyvforge.CyvForge;
import net.cyvforge.config.ColorTheme;
import net.cyvforge.config.CyvClientColorHelper;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.gui.GuiMPK;
import net.cyvforge.gui.config.ConfigPanel;
import net.cyvforge.gui.config.panels.ConfigPanelDecimalEntry;
import net.cyvforge.gui.config.panels.ConfigPanelEmptySpace;
import net.cyvforge.gui.config.panels.ConfigPanelIntegerSlider;
import net.cyvforge.gui.config.panels.ConfigPanelOptionSwitcher;
import net.cyvforge.gui.config.panels.ConfigPanelToggle;
import net.cyvforge.util.GuiUtils;
import net.cyvforge.util.defaults.CyvGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiModConfig
extends CyvGui {
    public int sizeX = 350;
    public int sizeY = 175;
    ArrayList<ConfigPanel> panels = new ArrayList();
    ConfigPanel selectedPanel;
    ScaledResolution sr;
    SubButton backButton;
    ColorTheme theme;
    float vScroll = 0.0f;
    float scroll = 0.0f;
    int maxScroll = 0;
    boolean scrollClicked = false;
    protected final boolean fromLabels;

    public GuiModConfig(boolean fromLabels) {
        super("Mod Config");
        this.field_146297_k = Minecraft.func_71410_x();
        this.sr = new ScaledResolution(this.field_146297_k);
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.fromLabels = fromLabels;
        this.backButton = new SubButton("Back", this.sr.func_78326_a() / 2 - this.sizeX / 2 - 4, this.sr.func_78328_b() / 2 - this.sizeY / 2 - 21);
        this.theme = CyvForge.theme;
        this.updatePanels();
        this.maxScroll = (int)Math.max(0.0, (double)(this.field_146289_q.field_78288_b * 2) * Math.ceil(this.panels.size()) - (double)(this.sizeY - 20));
        if (this.scroll > (float)this.maxScroll) {
            this.scroll = this.maxScroll;
        }
        if (this.scroll < 0.0f) {
            this.scroll = 0.0f;
        }
    }

    @Override
    public void func_73866_w_() {
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        this.field_146297_k.func_147108_a(null);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.theme = CyvForge.theme;
        GuiUtils.drawRoundedRect(this.sr.func_78326_a() / 2 - this.sizeX / 2 - 4, this.sr.func_78328_b() / 2 - this.sizeY / 2 - 4, this.sr.func_78326_a() / 2 + this.sizeX / 2 + 14, this.sr.func_78328_b() / 2 + this.sizeY / 2 + 4, 10.0f, this.theme.background1);
        this.backButton.draw(mouseX, mouseY);
        int centerx = this.sr.func_78326_a() * this.sr.func_78325_e() / 2;
        int centery = this.sr.func_78328_b() * this.sr.func_78325_e() / 2;
        int scaleFactor = this.sr.func_78325_e();
        GL11.glScissor((int)(centerx - this.sizeX * scaleFactor / 2), (int)(centery - this.sizeY * scaleFactor / 2), (int)(this.sizeX * scaleFactor), (int)(this.sizeY * scaleFactor));
        GL11.glEnable((int)3089);
        for (ConfigPanel p : this.panels) {
            p.draw(mouseX, mouseY + (int)this.scroll, (int)this.scroll);
        }
        GL11.glDisable((int)3089);
        int scrollbarHeight = (int)((double)(this.sizeY - 8) / (0.01 * (double)this.maxScroll + 1.0));
        if (this.scroll > (float)this.maxScroll) {
            this.scroll = this.maxScroll;
        }
        if (this.scroll < 0.0f) {
            this.scroll = 0.0f;
        }
        int top = this.sr.func_78328_b() / 2 - this.sizeY / 2 + 4;
        int bottom = this.sr.func_78328_b() / 2 + this.sizeY / 2 - 4 - scrollbarHeight;
        int amount = (int)((float)top + (float)(bottom - top) * (this.scroll / (float)this.maxScroll));
        if (this.maxScroll == 0) {
            amount = top;
        }
        int color = this.theme.border2;
        if (mouseX > this.sr.func_78326_a() / 2 + this.sizeX / 2 + 2 && mouseX < this.sr.func_78326_a() / 2 + this.sizeX / 2 + 8 && mouseY > amount && mouseY < amount + scrollbarHeight) {
            color = this.theme.border1;
        }
        GuiUtils.drawRoundedRect(this.sr.func_78326_a() / 2 + this.sizeX / 2 + 2, amount, this.sr.func_78326_a() / 2 + this.sizeX / 2 + 8, amount + scrollbarHeight, 3.0f, color);
    }

    @Override
    public void func_73876_c() {
        if (this.selectedPanel != null) {
            this.selectedPanel.update();
        }
        this.scroll += this.vScroll;
        this.vScroll = (float)((double)this.vScroll * 0.75);
        if (this.scroll > (float)this.maxScroll) {
            this.scroll = this.maxScroll;
        }
        if (this.scroll < 0.0f) {
            this.scroll = 0.0f;
        }
    }

    private void updatePanels() {
        this.panels.clear();
        this.scroll = 0.0f;
        this.panels.add(new ConfigPanelOptionSwitcher<String>(this.panels, "color1", "Color 1", CyvClientColorHelper.colorStrings, this){

            @Override
            public void onValueChange() {
                CyvClientColorHelper.setColor1(CyvClientConfig.getString("color1", "aqua"));
            }
        });
        this.panels.add(new ConfigPanelOptionSwitcher<String>(this.panels, "color2", "Color 2", CyvClientColorHelper.colorStrings, this){

            @Override
            public void onValueChange() {
                CyvClientColorHelper.setColor2(CyvClientConfig.getString("color2", "aqua"));
            }
        });
        this.panels.add(new ConfigPanelOptionSwitcher<String>(this.panels, "theme", "Color Theme", ColorTheme.getThemes(), this){

            @Override
            public void onValueChange() {
                CyvForge.theme = ColorTheme.valueOf(CyvClientConfig.getString("theme", "CYVISPIRIA"));
            }
        });
        this.panels.add(new ConfigPanelToggle(this.panels, "whiteChat", "Color2 always white in chat", this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "df", "Decimal Precision", 1, 16, this){

            @Override
            public void onValueChange() {
                CyvForge.df.setMaximumFractionDigits(CyvClientConfig.getInt("df", 5));
            }
        });
        this.panels.add(new ConfigPanelToggle(this.panels, "trimZeroes", "Trim Zeroes", this){

            @Override
            public void onValueChange() {
                if (CyvClientConfig.getBoolean("trimZeroes", true)) {
                    CyvForge.df.setMinimumFractionDigits(0);
                } else {
                    CyvForge.df.setMinimumFractionDigits(CyvClientConfig.getInt("df", 5));
                }
            }
        });
        this.panels.add(new ConfigPanelEmptySpace(this.panels, this));
        this.panels.add(new ConfigPanelToggle(this.panels, "showMilliseconds", "Show Millisecond Timings", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "sendLbChatOffset", "Send Landing Offset", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "sendMmChatOffset", "Send Momentum Offset", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "highlightLanding", "Highlight Landing Blocks", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "highlightLandingCond", "Highlight Landing Conditions", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "momentumPbCancelling", "Momentum PB Cancelling", this));
        this.panels.add(new ConfigPanelEmptySpace(this.panels, this));
        this.panels.add(new ConfigPanelToggle(this.panels, "showFacingAxis", "Show Facing Axis", this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "turnHUDAngleMin", "Turn HUD Angle Min", 1, 12, this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "turnHUDAngleMax", "Turn HUD Angle Max", 1, 12, this));
        this.panels.add(new ConfigPanelEmptySpace(this.panels, this));
        this.panels.add(new ConfigPanelToggle(this.panels, "smoothMacro", "Smooth Macro", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "inertiaEnabled", "Inertia Listener Enabled", this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "inertiaTick", "Air tick", 1, 12, this));
        this.panels.add(new ConfigPanelDecimalEntry(this.panels, "inertiaMin", "Min Speed", this));
        this.panels.add(new ConfigPanelDecimalEntry(this.panels, "inertiaMax", "Max Speed", this));
        this.panels.add(new ConfigPanelOptionSwitcher<Character>(this.panels, "inertiaAxis", "Inertia Axis", new Character[]{Character.valueOf('x'), Character.valueOf('z')}, this));
        this.panels.add(new ConfigPanelOptionSwitcher<String>(this.panels, "inertiaGroundType", "Ground Type", new String[]{"normal", "ice", "slime"}, this));
        this.panels.add(new ConfigPanelEmptySpace(this.panels, this));
        this.panels.add(new ConfigPanelToggle(this.panels, "positionCheckerEnabled", "Position Checker Enabled", this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "positionCheckerTick", "Air tick", 1, 12, this));
        this.panels.add(new ConfigPanelDecimalEntry(this.panels, "positionCheckerMinX", "Min X", this));
        this.panels.add(new ConfigPanelDecimalEntry(this.panels, "positionCheckerMaxX", "Max X", this));
        this.panels.add(new ConfigPanelDecimalEntry(this.panels, "positionCheckerMinZ", "Min Z", this));
        this.panels.add(new ConfigPanelDecimalEntry(this.panels, "positionCheckerMaxZ", "Max Z", this));
        this.panels.add(new ConfigPanelToggle(this.panels, "positionCheckerZNeo", "Z Neo Mode", this));
        this.panels.add(new ConfigPanelEmptySpace(this.panels, this));
        this.panels.add(new ConfigPanelToggle(this.panels, "singleplayerCheckpointsEnabled", "Custom Checkpoints Enabled", this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "generatorDyeColor", "Generator Dye Color", 0, 15, this));
        this.panels.add(new ConfigPanelIntegerSlider(this.panels, "generatorItemSlot", "Generator Hotbar Slot", 0, 8, this));
        this.maxScroll = (int)Math.max(0.0, (double)(this.field_146289_q.field_78288_b * 2) * Math.ceil(this.panels.size()) - (double)(this.sizeY - 20));
        if (this.scroll > (float)this.maxScroll) {
            this.scroll = this.maxScroll;
        }
        if (this.scroll < 0.0f) {
            this.scroll = 0.0f;
        }
    }

    @Override
    public void func_146273_a(int x, int y, int mouseButton, long time) {
        if (this.scrollClicked) {
            int scrollbarHeight = (int)((double)(this.sizeY - 8) / (0.01 * (double)this.maxScroll + 1.0));
            int top = this.sr.func_78328_b() / 2 - this.sizeY / 2 + 4;
            int bottom = this.sr.func_78328_b() / 2 + this.sizeY / 2 - 4 - scrollbarHeight;
            this.scroll = (int)((float)(y - (this.sr.func_78328_b() / 2 - this.sizeY / 2) - scrollbarHeight / 2) / (float)(bottom - top) * (float)this.maxScroll);
            if (this.scroll > (float)this.maxScroll) {
                this.scroll = this.maxScroll;
            }
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
            }
        }
        if (this.selectedPanel != null) {
            this.selectedPanel.mouseDragged(x, y);
        }
    }

    public void func_146274_d() {
        try {
            super.func_146274_d();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int eventDWheel = Mouse.getDWheel();
        if (!(this.scrollClicked && Mouse.isButtonDown((int)0) || eventDWheel == 0)) {
            this.vScroll = (float)((double)this.vScroll - (double)eventDWheel * 0.03);
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int scrollbarHeight = (int)((double)(this.sizeY - 8) / (0.01 * (double)this.maxScroll + 1.0));
        int top = this.sr.func_78328_b() / 2 - this.sizeY / 2 + 4;
        int bottom = this.sr.func_78328_b() / 2 + this.sizeY / 2 - 4 - scrollbarHeight;
        int amount = (int)((float)top + (float)(bottom - top) * (this.scroll / (float)this.maxScroll));
        if (mouseX > this.sr.func_78326_a() / 2 + this.sizeX / 2 + 2 && mouseX < this.sr.func_78326_a() / 2 + this.sizeX / 2 + 8 && mouseY > amount && mouseY < amount + scrollbarHeight) {
            this.scrollClicked = true;
            return;
        }
        this.scrollClicked = false;
        if (this.backButton.clicked(mouseX, mouseY, mouseButton)) {
            if (this.fromLabels) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMPK());
            } else {
                Minecraft.func_71410_x().func_147108_a(null);
            }
            return;
        }
        if (mouseX < this.sr.func_78326_a() / 2 - this.sizeX / 2 - 4 || mouseX > this.sr.func_78326_a() / 2 + this.sizeX / 2 + 14 || mouseY < this.sr.func_78328_b() / 2 - this.sizeY / 2 - 4 || mouseY > this.sr.func_78328_b() / 2 + this.sizeY / 2 + 4) {
            this.selectedPanel = null;
            return;
        }
        for (ConfigPanel p : this.panels) {
            if (!p.mouseInBounds(mouseX, mouseY + (int)this.scroll)) continue;
            if (this.selectedPanel != null) {
                this.selectedPanel.unselect();
            }
            p.mouseClicked(mouseX, mouseY + (int)this.scroll, mouseButton);
            this.selectedPanel = p;
            p.select();
            return;
        }
        this.selectedPanel = null;
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            if (this.fromLabels) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMPK());
            } else {
                Minecraft.func_71410_x().func_147108_a(null);
            }
            return;
        }
        if (this.selectedPanel != null) {
            this.selectedPanel.keyTyped(typedChar, keyCode);
        }
    }

    @Override
    public void func_146281_b() {
        for (ConfigPanel p : this.panels) {
            p.save();
        }
        this.updatePanels();
    }

    class SubButton {
        String text;
        int x;
        int y;
        int sizeX = 80;
        int sizeY = 15;

        SubButton(String text, int x, int y) {
            this.text = text;
            this.x = x;
            this.y = y;
        }

        void draw(int mouseX, int mouseY) {
            boolean mouseDown = mouseX > this.x && mouseX < this.x + this.sizeX && mouseY > this.y && mouseY < this.y + this.sizeY;
            GuiUtils.drawRoundedRect(this.x, this.y, this.x + this.sizeX, this.y + this.sizeY, 5.0f, mouseDown ? GuiModConfig.this.theme.highlight : GuiModConfig.this.theme.background1);
            GuiUtils.drawCenteredString(this.text, this.x + this.sizeX / 2, this.y + this.sizeY / 2 - ((GuiModConfig)GuiModConfig.this).field_146289_q.field_78288_b / 2, -1, true);
        }

        boolean clicked(double mouseX, double mouseY, int mouseButton) {
            return mouseX > (double)this.x && mouseX < (double)(this.x + this.sizeX) && mouseY > (double)this.y && mouseY < (double)(this.y + this.sizeY) && mouseButton == 0;
        }
    }
}

