/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.gui.config.panels;

import java.util.ArrayList;
import net.cyvforge.CyvForge;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.gui.GuiModConfig;
import net.cyvforge.gui.config.ConfigPanel;
import net.cyvforge.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;

public class ConfigPanelIntegerSlider
implements ConfigPanel {
    public int sliderValue;
    public String configOption;
    public String displayString;
    public final int minValue;
    private final int maxValue;
    public final int index;
    public GuiModConfig screenIn;
    private int xPosition;
    private int yPosition;
    private int sizeX;
    private int sizeY;

    public ConfigPanelIntegerSlider(ArrayList<ConfigPanel> array, String configOption, String displayString, int minValue, int maxValue, GuiModConfig screenIn) {
        this.index = array.size();
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.displayString = displayString;
        this.configOption = configOption;
        this.screenIn = screenIn;
        ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
        this.sizeX = screenIn.sizeX - 20;
        this.sizeY = Minecraft.func_71410_x().field_71466_p.field_78288_b * 3 / 2;
        this.xPosition = sr.func_78326_a() / 2 - screenIn.sizeX / 2 + 10;
        this.yPosition = sr.func_78328_b() / 2 - screenIn.sizeY / 2 + 10 + this.index * Minecraft.func_71410_x().field_71466_p.field_78288_b * 2;
        this.sliderValue = CyvClientConfig.getInt(configOption, 0);
        MathHelper.func_76125_a((int)this.sliderValue, (int)minValue, (int)maxValue);
    }

    @Override
    public void draw(int mouseX, int mouseY, int scroll) {
        GuiUtils.drawString(this.displayString, this.xPosition, this.yPosition + this.sizeY / 2 - Minecraft.func_71410_x().field_71466_p.field_78288_b / 2 + 1 - scroll, -1, true);
        GuiUtils.drawRoundedRect(this.xPosition + this.sizeX / 2, this.yPosition - scroll, this.xPosition + this.sizeX, this.yPosition + this.sizeY - scroll, 3.0f, this.mouseInBounds(mouseX, mouseY) ? CyvForge.theme.shade1 : CyvForge.theme.shade2);
        GuiUtils.drawRoundedRect(this.xPosition + this.sizeX / 2 + this.sizeX / 2 * (this.sliderValue - this.minValue) / (this.maxValue - this.minValue) - 3, this.yPosition - 1 - scroll, this.xPosition + this.sizeX / 2 + this.sizeX / 2 * (this.sliderValue - this.minValue) / (this.maxValue - this.minValue) + 3, this.yPosition + this.sizeY + 1 - scroll, 1.0f, CyvForge.theme.mainBase());
        GuiUtils.drawCenteredString(" " + this.sliderValue, this.xPosition + this.sizeX * 3 / 4, this.yPosition + this.sizeY / 2 - Minecraft.func_71410_x().field_71466_p.field_78288_b / 2 + 1 - scroll, -1, true);
    }

    @Override
    public void mouseDragged(int mouseX, int mouseY) {
        this.sliderValue = (int)((float)(mouseX + 2 - (this.xPosition + this.sizeX / 2)) / (float)(this.sizeX / 2) * (float)(this.maxValue - this.minValue)) + this.minValue;
        this.sliderValue = (int)MathHelper.func_151237_a((double)this.sliderValue, (double)this.minValue, (double)this.maxValue);
        CyvClientConfig.set(this.configOption, this.sliderValue);
        this.onValueChange();
    }

    @Override
    public boolean mouseInBounds(int mouseX, int mouseY) {
        return mouseX > this.xPosition + this.sizeX / 2 && mouseY > this.yPosition && mouseX < this.xPosition + this.sizeX && mouseY < this.yPosition + this.sizeY;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
    }

    @Override
    public void save() {
        CyvClientConfig.set(this.configOption, this.sliderValue);
    }
}

