/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.hud.nonlabels;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.cyvforge.config.CyvClientColorHelper;
import net.cyvforge.event.events.ParkourTickListener;
import net.cyvforge.hud.structure.DraggableHUDElement;
import net.cyvforge.hud.structure.ScreenPosition;
import net.cyvforge.util.GuiUtils;
import net.minecraft.client.settings.KeyBinding;

public class KeystrokesHUD
extends DraggableHUDElement {
    public List<Key> keys;
    public int size = 66;

    @Override
    public ScreenPosition getDefaultPosition() {
        return new ScreenPosition(250, 0);
    }

    @Override
    public String getName() {
        return "keystrokes";
    }

    @Override
    public String getDisplayName() {
        return "Keystrokes";
    }

    @Override
    public int getWidth() {
        return this.size;
    }

    @Override
    public int getHeight() {
        return (int)((double)this.getWidth() * 1.05);
    }

    @Override
    public void render(ScreenPosition pos) {
        if (this.keys == null || this.keys.isEmpty()) {
            this.refreshKeys();
        }
        for (Key key : this.keys) {
            String displayString = key.name;
            float scale = 1.0f;
            GuiUtils.drawRoundedRect(pos.getAbsoluteX() + key.x, pos.getAbsoluteY() + key.y, pos.getAbsoluteX() + key.x + key.width, pos.getAbsoluteY() + key.y + key.height, 2.0f, key.isDown() ? new Color(255, 255, 255, 102).getRGB() : new Color(20, 20, 20, 102).getRGB());
            GuiUtils.drawCenteredString(displayString, pos.getAbsoluteX() + key.x + key.width / 2, pos.getAbsoluteY() + key.y + key.height / 2 - (int)((float)this.mc.field_71466_p.field_78288_b * ((float)this.size * scale / 66.0f) / 2.0f) + 1, key.isDown() ? (int)CyvClientColorHelper.color1.getDrawColor() : Color.white.getRGB(), true);
        }
    }

    @Override
    public void renderDummy(ScreenPosition pos) {
        if (!this.isVisible) {
            return;
        }
        this.render(pos);
    }

    void refreshKeys() {
        int sq = this.getWidth() / 3;
        int srl = this.getWidth() / 2;
        int srh = this.getWidth() / 5;
        int spc = this.getWidth() / 5;
        this.keys = new ArrayList<Key>();
        this.keys.add(new Key("W", this.mc.field_71474_y.field_74351_w, sq + 1, 1, sq - 2, sq - 2, 0));
        this.keys.add(new Key("A", this.mc.field_71474_y.field_74370_x, 1, sq + 1, sq - 2, sq - 2, 1));
        this.keys.add(new Key("S", this.mc.field_71474_y.field_74368_y, sq + 1, sq + 1, sq - 2, sq - 2, 2));
        this.keys.add(new Key("D", this.mc.field_71474_y.field_74366_z, 2 * sq + 1, sq + 1, sq - 2, sq - 2, 3));
        this.keys.add(new Key("-----", this.mc.field_71474_y.field_74314_A, 1, 2 * sq + srh + 1, this.getWidth() - 2, spc - 2, 4));
        this.keys.add(new Key("Spr", this.mc.field_71474_y.field_151444_V, 1, 2 * sq + 1, srl - 2, srh - 2, 5));
        this.keys.add(new Key("Snk", this.mc.field_71474_y.field_74311_E, srl + 1, 2 * sq + 1, srl - 2, srh - 2, 6));
    }

    private static class Key {
        public final String name;
        public final KeyBinding keyBind;
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        int index = -1;

        public Key(String name, KeyBinding keyBind, int x, int y, int width, int height) {
            this(name, keyBind, x, y, width, height, -1);
        }

        public Key(String name, KeyBinding keyBind, int x, int y, int width, int height, int index) {
            this.name = name;
            this.keyBind = keyBind;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.index = index;
        }

        public boolean isDown() {
            if (this.index == -1) {
                return this.keyBind.func_151468_f();
            }
            if (this.index == 5 || this.index == 6) {
                return ParkourTickListener.lastTick.keys[this.index];
            }
            return ParkourTickListener.lastTick.keys[this.index];
        }
    }
}

