/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.hud.nonlabels;

import java.text.DecimalFormat;
import net.cyvforge.CyvForge;
import net.cyvforge.config.CyvClientColorHelper;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.event.events.ParkourTickListener;
import net.cyvforge.hud.structure.DraggableHUDElement;
import net.cyvforge.hud.structure.ScreenPosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class TurnHUD
extends DraggableHUDElement {
    FontRenderer font;

    public TurnHUD() {
        this.font = Minecraft.func_71410_x().field_71466_p;
    }

    @Override
    public String getName() {
        return "turnHUD";
    }

    @Override
    public String getDisplayName() {
        return "Turning HUD";
    }

    @Override
    public boolean enabledByDefault() {
        return false;
    }

    @Override
    public ScreenPosition getDefaultPosition() {
        return new ScreenPosition(250, 100);
    }

    @Override
    public int getWidth() {
        return this.getLabelWidth("12", true);
    }

    @Override
    public int getHeight() {
        int rows = Math.max(1, Math.min(CyvClientConfig.getInt("turnHUDAngles", 12), 12));
        return 10 * rows;
    }

    @Override
    public void render(ScreenPosition pos) {
        long color1 = CyvClientColorHelper.color1.getDrawColor();
        long color2 = CyvClientColorHelper.color2.getDrawColor();
        DecimalFormat df = CyvForge.df;
        int a = Math.max(1, Math.min(CyvClientConfig.getInt("turnHUDAngleMin", 1), 12));
        int b = Math.max(1, Math.min(CyvClientConfig.getInt("turnHUDAngleMax", 12), 12));
        for (int i = Math.min(a, b) - 1; i < Math.max(a, b); ++i) {
            String angle = df.format(ParkourTickListener.formatYaw(ParkourTickListener.turningAngles[i]));
            this.drawString(i + 1 + ": ", pos.getAbsoluteX() + 1, pos.getAbsoluteY() + 1 + i * 10, color1);
            this.drawString(angle + "\u00b0", pos.getAbsoluteX() + 1 + this.font.func_78256_a(i + 1 + ": "), pos.getAbsoluteY() + 1 + i * 10, color2);
        }
    }

    @Override
    public void renderDummy(ScreenPosition pos) {
        int i;
        if (!this.isVisible) {
            return;
        }
        long color1 = CyvClientColorHelper.color1.getDrawColor();
        long color2 = CyvClientColorHelper.color2.getDrawColor();
        int a = Math.max(1, Math.min(CyvClientConfig.getInt("turnHUDAngleMin", 12), 12));
        int b = Math.max(1, Math.min(CyvClientConfig.getInt("turnHUDAngleMax", 12), 12));
        StringBuilder str = new StringBuilder("0.");
        for (i = 0; i < CyvClientConfig.getInt("df", 5); ++i) {
            str.append("0");
        }
        for (i = Math.min(a, b) - 1; i < Math.max(a, b); ++i) {
            this.drawString(i + 1 + ": ", pos.getAbsoluteX() + 1, pos.getAbsoluteY() + 1 + i * 10, color1);
            this.drawString(str + "\u00b0", pos.getAbsoluteX() + 1 + this.font.func_78256_a(i + 1 + ": "), pos.getAbsoluteY() + 1 + i * 10, color2);
        }
    }

    public int getLabelWidth(String s, boolean angle) {
        this.font = Minecraft.func_71410_x().field_71466_p;
        StringBuilder str = angle ? new StringBuilder(s + ": 000.") : new StringBuilder(s + ": 000000.");
        for (int i = 0; i < CyvClientConfig.getInt("df", 5); ++i) {
            str.append("0");
        }
        if (angle) {
            str.append("\u00b0");
        }
        return this.font.func_78256_a(str.toString());
    }

    public int getLabelHeight() {
        return 9;
    }
}

