/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.hud.structure;

import java.util.LinkedHashMap;
import net.cyvforge.config.CyvClientConfig;
import net.cyvforge.hud.structure.IRenderer;
import net.cyvforge.hud.structure.ScreenPosition;
import net.cyvforge.util.GuiUtils;
import net.minecraft.client.Minecraft;

public abstract class DraggableHUDElement
implements IRenderer {
    protected final Minecraft mc = Minecraft.func_71410_x();
    public ScreenPosition position;
    public boolean isVisible = true;
    public boolean isDraggable = true;
    public boolean isEnabled = true;

    public DraggableHUDElement() {
        this.setEnabled(this.isEnabled);
        this.position = this.getDefaultPosition();
    }

    public final int getLineOffset(ScreenPosition pos, int lineNum) {
        return pos.getAbsoluteY() + this.getLineOffset(lineNum);
    }

    private int getLineOffset(int lineNum) {
        return this.mc.field_71466_p.field_78288_b * 3 * lineNum;
    }

    public abstract ScreenPosition getDefaultPosition();

    public LinkedHashMap<String, CyvClientConfig.ConfigValue<?>> getConfigFields() {
        LinkedHashMap fields = new LinkedHashMap();
        fields.put("enabled", new CyvClientConfig.ConfigValue<Boolean>(this.enabledByDefault()));
        fields.put("posx", new CyvClientConfig.ConfigValue<Integer>(this.getDefaultPosition().getAbsoluteX()));
        fields.put("posy", new CyvClientConfig.ConfigValue<Integer>(this.getDefaultPosition().getAbsoluteY()));
        fields.put("visible", new CyvClientConfig.ConfigValue<Boolean>(true));
        return fields;
    }

    public void readConfigFields() {
        try {
            this.isEnabled = CyvClientConfig.getBoolean(this.getName() + "_enabled", this.isEnabled);
            int x = CyvClientConfig.getInt(this.getName() + "_posx", this.getDefaultPosition().getAbsoluteX());
            int y = CyvClientConfig.getInt(this.getName() + "_posy", this.getDefaultPosition().getAbsoluteY());
            this.isVisible = CyvClientConfig.getBoolean(this.getName() + "_visible", this.isVisible);
            this.position = new ScreenPosition(x, y);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.position = this.getDefaultPosition();
        }
    }

    public void saveConfigFields() {
        CyvClientConfig.set(this.getName() + "_enabled", this.isEnabled);
        CyvClientConfig.set(this.getName() + "_visible", this.isVisible);
        CyvClientConfig.set(this.getName() + "_posx", this.position.getAbsoluteX());
        CyvClientConfig.set(this.getName() + "_posy", this.position.getAbsoluteY());
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    @Override
    public void save(ScreenPosition pos) {
        this.position = pos;
    }

    @Override
    public ScreenPosition load() {
        return this.position;
    }

    public abstract String getName();

    public abstract String getDisplayName();

    public boolean enabledByDefault() {
        return true;
    }

    protected void drawString(Object string, int x, int y, long color) {
        this.drawString(string, x, y, color, true);
    }

    protected void drawString(Object string, int x, int y, long color, boolean shadow) {
        long drawColor = this.isVisible ? color : -5592406L;
        GuiUtils.drawString(string.toString(), x, y, Long.valueOf(drawColor).intValue(), shadow);
    }
}

