/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.util;

import java.awt.Color;
import net.cyvforge.util.MathUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class GuiUtils
extends Gui {
    public static GuiUtils instance;
    private static final Minecraft mc;

    public GuiUtils() {
        instance = this;
    }

    public static int drawString(String text, float x, float y, int color, boolean shadow) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return GuiUtils.mc.field_71466_p.func_175065_a(text, x, y, color, shadow);
    }

    public static int drawString(String text, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return GuiUtils.drawString(text, x, y, 0xFFFFFF);
    }

    public static int drawString(String text, int x, int y, boolean shadow) {
        return GuiUtils.drawString(text, x, y, 0xFFFFFF, shadow);
    }

    public static int drawString(String text, int x, int y, int color) {
        return GuiUtils.drawString(text, x, y, color, false);
    }

    public static int drawString(String text, int x, int y, int color, boolean shadow) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        String[] lines = text.split("\n");
        if (lines.length > 1) {
            int j = 0;
            for (int i = 0; i < lines.length; ++i) {
                j += GuiUtils.mc.field_71466_p.func_175065_a(lines[i], (float)x, (float)(y + i * (GuiUtils.mc.field_71466_p.field_78288_b + 2)), color, shadow);
            }
            return j;
        }
        return GuiUtils.mc.field_71466_p.func_175065_a(text, (float)x, (float)y, color, shadow);
    }

    public static int drawScaledString(String text, int x, int y, boolean shadow, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int i = GuiUtils.drawString(text, (int)((float)x / scale), (int)((float)y / scale), shadow);
        GlStateManager.func_179139_a((double)Math.pow(scale, -1.0), (double)Math.pow(scale, -1.0), (double)1.0);
        GlStateManager.func_179121_F();
        return i;
    }

    public static int drawScaledString(String text, int x, int y, boolean shadow, int color, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        int i = GuiUtils.drawString(text, (int)((float)x / scale), (int)((float)y / scale), color, shadow);
        GlStateManager.func_179139_a((double)Math.pow(scale, -1.0), (double)Math.pow(scale, -1.0), (double)1.0);
        GlStateManager.func_179121_F();
        return i;
    }

    public static void drawChromaString(String textIn, int xIn, int y, boolean shadow) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int j = 0; j < textIn.split("\n").length; ++j) {
            int x = xIn;
            for (char c : textIn.split("\n")[j].toCharArray()) {
                long l = System.currentTimeMillis() - (long)x * 10L - ((long)y - (long)j * 10L) * 10L;
                float speed = 2000.0f;
                int color = Color.HSBtoRGB((float)(l % (long)((int)speed)) / speed, 0.8f, 0.8f);
                GuiUtils.drawString(String.valueOf(c), x, y + j * (GuiUtils.mc.field_71466_p.field_78288_b + 2), color, shadow);
                x += GuiUtils.mc.field_71466_p.func_78256_a(String.valueOf(c));
            }
        }
    }

    public static void drawStringInLimitedArea(String str, int x, int x2, int y, boolean shadow, int color) {
        String[] originalString = str.split(" ");
        StringBuilder finalString = new StringBuilder();
        int length = 0;
        int offset = 0;
        for (String s : originalString) {
            if (x + (length += GuiUtils.mc.field_71466_p.func_78256_a(s + " ")) > x2) {
                finalString.append("\n");
                length = 0;
            }
            finalString.append(s);
            finalString.append(" ");
        }
        for (String s : finalString.toString().split("\n")) {
            GuiUtils.drawString(s, x, y + offset, color, shadow);
            offset += GuiUtils.mc.field_71466_p.field_78288_b + 3;
        }
    }

    public static int drawCenteredString(String text, int x, int y) {
        return GuiUtils.drawString(text, x - GuiUtils.mc.field_71466_p.func_78256_a(text) / 2, y);
    }

    public static int drawCenteredString(String text, int x, int y, int color) {
        return GuiUtils.drawString(text, x - GuiUtils.mc.field_71466_p.func_78256_a(text) / 2, y, color);
    }

    public static int drawCenteredString(String text, int x, int y, int color, boolean shadow) {
        return GuiUtils.drawString(text, x - GuiUtils.mc.field_71466_p.func_78256_a(text) / 2, y, color, shadow);
    }

    public static int drawScaledCenteredString(String text, int x, int y, boolean shadow, float scale) {
        return GuiUtils.drawScaledString(text, x - (int)((float)GuiUtils.mc.field_71466_p.func_78256_a(text) * scale / 2.0f), y, shadow, scale);
    }

    public static int drawScaledCenteredString(String text, int x, int y, boolean shadow, int color, float scale) {
        return GuiUtils.drawScaledString(text, x - (int)((float)GuiUtils.mc.field_71466_p.func_78256_a(text) * scale / 2.0f), y, shadow, color, scale);
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, float zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)zLevel).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)zLevel).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)zLevel).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV, float zLevel) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + (float)maxV), (double)zLevel).func_181673_a((double)((float)(minU + 0) * f), (double)((float)(minV + maxV) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + (float)maxV), (double)zLevel).func_181673_a((double)((float)(minU + maxU) * f), (double)((float)(minV + maxV) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + (float)maxU), (double)(yCoord + 0.0f), (double)zLevel).func_181673_a((double)((float)(minU + maxU) * f), (double)((float)(minV + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)zLevel).func_181673_a((double)((float)(minU + 0) * f), (double)((float)(minV + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn, float zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), (double)zLevel).func_181673_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)zLevel).func_181673_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), (double)zLevel).func_181673_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        worldrenderer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), (double)zLevel).func_181673_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRectOutline(int x, int y, int x2, int y2, int color) {
        GuiUtils.drawHorizontalLineS(x, x2, y, color);
        GuiUtils.drawHorizontalLineS(x, x2, y2, color);
        GuiUtils.drawVerticalLineS(x, y2, y, color);
        GuiUtils.drawVerticalLineS(x2, y2, y, color);
    }

    public static void drawHorizontalLineS(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        GuiUtils.func_73734_a((int)startX, (int)y, (int)(endX + 1), (int)(y + 1), (int)color);
    }

    public static void drawVerticalLineS(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int i = startY;
            startY = endY;
            endY = i;
        }
        GuiUtils.func_73734_a((int)x, (int)(startY + 1), (int)(x + 1), (int)endY, (int)color);
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawRoundedRect(int paramInt1, int paramInt2, int paramInt3, int paramInt4, float radius, int color) {
        float f1 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)f2, (float)f3, (float)f4, (float)f1);
        GuiUtils.drawRoundedRect(paramInt1, paramInt2, paramInt3, paramInt4, radius);
    }

    public static void drawRoundedRect(float x1, float y1, float x2, float y2, float radius, int color) {
        float f1 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)f2, (float)f3, (float)f4, (float)f1);
        GuiUtils.drawRoundedRect(x1, y1, x2, y2, radius);
    }

    private static void drawRoundedRect(float x1, float y1, float x2, float y2, float radius) {
        float f4;
        int j;
        int i = 18;
        float f1 = 90.0f / (float)i;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179142_g();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBegin((int)5);
        GL11.glVertex2f((float)(x1 + radius), (float)y1);
        GL11.glVertex2f((float)(x1 + radius), (float)y2);
        GL11.glVertex2f((float)(x2 - radius), (float)y1);
        GL11.glVertex2f((float)(x2 - radius), (float)y2);
        GL11.glEnd();
        GL11.glBegin((int)5);
        GL11.glVertex2f((float)x1, (float)(y1 + radius));
        GL11.glVertex2f((float)(x1 + radius), (float)(y1 + radius));
        GL11.glVertex2f((float)x1, (float)(y2 - radius));
        GL11.glVertex2f((float)(x1 + radius), (float)(y2 - radius));
        GL11.glEnd();
        GL11.glBegin((int)5);
        GL11.glVertex2f((float)x2, (float)(y1 + radius));
        GL11.glVertex2f((float)(x2 - radius), (float)(y1 + radius));
        GL11.glVertex2f((float)x2, (float)(y2 - radius));
        GL11.glVertex2f((float)(x2 - radius), (float)(y2 - radius));
        GL11.glEnd();
        GL11.glBegin((int)6);
        float f2 = x2 - radius;
        float f3 = y1 + radius;
        GL11.glVertex2f((float)f2, (float)f3);
        for (j = 0; j <= i; ++j) {
            f4 = (float)j * f1;
            GL11.glVertex2f((float)((float)((double)f2 + (double)radius * Math.cos(Math.toRadians(f4)))), (float)((float)((double)f3 - (double)radius * Math.sin(Math.toRadians(f4)))));
        }
        GL11.glEnd();
        GL11.glBegin((int)6);
        f2 = x1 + radius;
        f3 = y1 + radius;
        GL11.glVertex2f((float)f2, (float)f3);
        for (j = 0; j <= i; ++j) {
            f4 = (float)j * f1;
            GL11.glVertex2f((float)((float)((double)f2 - (double)radius * Math.cos(Math.toRadians(f4)))), (float)((float)((double)f3 - (double)radius * Math.sin(Math.toRadians(f4)))));
        }
        GL11.glEnd();
        GL11.glBegin((int)6);
        f2 = x1 + radius;
        f3 = y2 - radius;
        GL11.glVertex2f((float)f2, (float)f3);
        for (j = 0; j <= i; ++j) {
            f4 = (float)j * f1;
            GL11.glVertex2f((float)((float)((double)f2 - (double)radius * Math.cos(Math.toRadians(f4)))), (float)((float)((double)f3 + (double)radius * Math.sin(Math.toRadians(f4)))));
        }
        GL11.glEnd();
        GL11.glBegin((int)6);
        f2 = x2 - radius;
        f3 = y2 - radius;
        GL11.glVertex2f((float)f2, (float)f3);
        for (j = 0; j <= i; ++j) {
            f4 = (float)j * f1;
            GL11.glVertex2f((float)((float)((double)f2 + (double)radius * Math.cos(Math.toRadians(f4)))), (float)((float)((double)f3 + (double)radius * Math.sin(Math.toRadians(f4)))));
        }
        GL11.glEnd();
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179119_h();
        GlStateManager.func_179098_w();
    }

    public static void drawRoundedOutline(int x, int y, int x2, int y2, float radius, float width, int color) {
        float f1 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(color >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)f2, (float)f3, (float)f4, (float)f1);
        GuiUtils.drawRoundedOutline(x, y, x2, y2, radius, width);
    }

    private static void drawRoundedOutline(float x, float y, float x2, float y2, float radius, float width) {
        int m;
        int k;
        int i = 18;
        int j = 90 / i;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        GlStateManager.func_179142_g();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        if (width != 1.0f) {
            GL11.glLineWidth((float)width);
        }
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)(x + radius), (float)y);
        GL11.glVertex2f((float)(x2 - radius), (float)y);
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)x2, (float)(y + radius));
        GL11.glVertex2f((float)x2, (float)(y2 - radius));
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)(x2 - radius), (float)(y2 - 0.1f));
        GL11.glVertex2f((float)(x + radius), (float)(y2 - 0.1f));
        GL11.glEnd();
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)(x + 0.1f), (float)(y2 - radius));
        GL11.glVertex2f((float)(x + 0.1f), (float)(y + radius));
        GL11.glEnd();
        float f1 = x2 - radius;
        float f2 = y + radius;
        GL11.glBegin((int)3);
        for (k = 0; k <= i; ++k) {
            m = 90 - k * j;
            GL11.glVertex2f((float)((float)((double)f1 + (double)radius * MathUtils.getRightAngle(m))), (float)((float)((double)f2 - (double)radius * MathUtils.getAngle(m))));
        }
        GL11.glEnd();
        f1 = x2 - radius;
        f2 = y2 - radius;
        GL11.glBegin((int)3);
        for (k = 0; k <= i; ++k) {
            m = k * j + 270;
            GL11.glVertex2f((float)((float)((double)f1 + (double)radius * MathUtils.getRightAngle(m))), (float)((float)((double)f2 - (double)radius * MathUtils.getAngle(m))));
        }
        GL11.glEnd();
        GL11.glBegin((int)3);
        f1 = x + radius;
        f2 = y2 - radius;
        for (k = 0; k <= i; ++k) {
            m = k * j + 90;
            GL11.glVertex2f((float)((float)((double)f1 + (double)radius * MathUtils.getRightAngle(m))), (float)((float)((double)f2 + (double)radius * MathUtils.getAngle(m))));
        }
        GL11.glEnd();
        GL11.glBegin((int)3);
        f1 = x + radius;
        f2 = y + radius;
        for (k = 0; k <= i; ++k) {
            m = 270 - k * j;
            GL11.glVertex2f((float)((float)((double)f1 + (double)radius * MathUtils.getRightAngle(m))), (float)((float)((double)f2 + (double)radius * MathUtils.getAngle(m))));
        }
        GL11.glEnd();
        if (width != 1.0f) {
            GL11.glLineWidth((float)1.0f);
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179119_h();
        GlStateManager.func_179098_w();
    }

    public static void drawCircle(float x, float y, float radius, float thickness, Color color, boolean smooth) {
        GuiUtils.drawPartialCircle(x, y, radius, 0, 360, thickness, color, smooth);
    }

    public static void drawPartialCircle(int x, int y, float radius, int startAngle, int endAngle, float thickness, Color color, boolean smooth) {
        GuiUtils.drawPartialCircle(x, y, radius, startAngle, endAngle, thickness, color, smooth);
    }

    public static void drawPartialCircle(float x, float y, float radius, int startAngle, int endAngle, float thickness, Color colour, boolean smooth) {
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        if (startAngle > endAngle) {
            int temp = startAngle;
            startAngle = endAngle;
            endAngle = temp;
        }
        if (startAngle < 0) {
            startAngle = 0;
        }
        if (endAngle > 360) {
            endAngle = 360;
        }
        if (smooth) {
            GL11.glEnable((int)2848);
        } else {
            GL11.glDisable((int)2848);
        }
        GL11.glLineWidth((float)thickness);
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getAlpha() / 255.0f));
        GL11.glBegin((int)3);
        float ratio = (float)Math.PI / 180;
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            GL11.glVertex2f((float)(x + (float)Math.cos(radians) * radius), (float)(y + (float)Math.sin(radians) * radius));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawFilledRect(float x1, float y1, float x2, float y2, int colour, boolean smooth) {
        GuiUtils.drawFilledShape(new float[]{x1, y1, x1, y2, x2, y2, x2, y1}, new Color(colour, true), smooth);
    }

    public static void drawFilledShape(float[] points, Color colour, boolean smooth) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        if (smooth) {
            GL11.glEnable((int)2848);
        } else {
            GL11.glDisable((int)2848);
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getAlpha() / 255.0f));
        GL11.glBegin((int)9);
        for (int i = 0; i < points.length; i += 2) {
            GL11.glVertex2f((float)points[i], (float)points[i + 1]);
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void drawLine(float x, float x1, float y, float thickness, int colour, boolean smooth) {
        GuiUtils.drawLines(new float[]{x, y, x1, y}, thickness, new Color(colour, true), smooth);
    }

    public static void drawVerticalLine(float x, float y, float y1, float thickness, int colour, boolean smooth) {
        GuiUtils.drawLines(new float[]{x, y, x, y1}, thickness, new Color(colour, true), smooth);
    }

    public static void drawLines(float[] points, float thickness, Color colour, boolean smooth) {
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        if (smooth) {
            GL11.glEnable((int)2848);
        } else {
            GL11.glDisable((int)2848);
        }
        GL11.glLineWidth((float)thickness);
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getAlpha() / 255.0f));
        GL11.glBegin((int)1);
        for (int i = 0; i < points.length; i += 2) {
            GL11.glVertex2f((float)points[i], (float)points[i + 1]);
        }
        GL11.glEnd();
        GL11.glEnable((int)2848);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    static {
        mc = Minecraft.func_71410_x();
    }
}

