/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.function.Function;

public class MathEvaluator {
    private static MathEvaluator instance;
    private final Map<String, Integer> PRECEDENCE = new HashMap<String, Integer>();
    private final Map<String, Function<Double, Double>> FUNCTIONS = new HashMap<String, Function<Double, Double>>();
    private final Set<String> RIGHT_ASSOCIATIVE = new HashSet<String>();

    public static MathEvaluator getInstance() {
        if (instance == null) {
            instance = new MathEvaluator();
        }
        return instance;
    }

    private MathEvaluator() {
        this.PRECEDENCE.put("+", 1);
        this.PRECEDENCE.put("-", 1);
        this.PRECEDENCE.put("*", 2);
        this.PRECEDENCE.put("/", 2);
        this.PRECEDENCE.put("^", 3);
        this.PRECEDENCE.put("u-", 4);
        this.RIGHT_ASSOCIATIVE.add("^");
        this.RIGHT_ASSOCIATIVE.add("u-");
        this.FUNCTIONS.put("sin", Math::sin);
        this.FUNCTIONS.put("cos", Math::cos);
        this.FUNCTIONS.put("tan", Math::tan);
        this.FUNCTIONS.put("sec", v -> 1.0 / Math.cos(v));
        this.FUNCTIONS.put("csc", v -> 1.0 / Math.sin(v));
        this.FUNCTIONS.put("cot", v -> 1.0 / Math.tan(v));
        this.FUNCTIONS.put("arcsin", Math::asin);
        this.FUNCTIONS.put("arccos", Math::acos);
        this.FUNCTIONS.put("arctan", Math::atan);
        this.FUNCTIONS.put("arcsec", v -> Math.acos(1.0 / v));
        this.FUNCTIONS.put("arccsc", v -> Math.asin(1.0 / v));
        this.FUNCTIONS.put("arccot", v -> Math.atan(1.0 / v));
        this.FUNCTIONS.put("asin", Math::asin);
        this.FUNCTIONS.put("acos", Math::acos);
        this.FUNCTIONS.put("atan", Math::atan);
        this.FUNCTIONS.put("asec", v -> Math.acos(1.0 / v));
        this.FUNCTIONS.put("acsc", v -> Math.asin(1.0 / v));
        this.FUNCTIONS.put("acot", v -> Math.atan(1.0 / v));
        this.FUNCTIONS.put("sqrt", Math::sqrt);
        this.FUNCTIONS.put("cbrt", Math::cbrt);
        this.FUNCTIONS.put("log", Math::log10);
        this.FUNCTIONS.put("ln", Math::log);
        this.FUNCTIONS.put("abs", Math::abs);
    }

    public double eval(String expr) {
        List<String> rpn = this.toRPN(expr);
        return this.evalRPN(rpn);
    }

    private List<String> toRPN(String expr) {
        ArrayList<String> output = new ArrayList<String>();
        Stack<String> stack = new Stack<String>();
        StringTokenizer tokenizer = new StringTokenizer(expr, "+-*/^() ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            if (this.isNumber(token) || this.isConstant(token)) {
                output.add(token);
                continue;
            }
            if (this.FUNCTIONS.containsKey(token.toLowerCase())) {
                stack.push(token);
                continue;
            }
            if (this.isOperator(token)) {
                if (token.equals("-") && (output.isEmpty() || this.isOperator(MathEvaluator.lastToken(stack, output)) || MathEvaluator.lastToken(stack, output).equals("("))) {
                    token = "u-";
                }
                while (!stack.isEmpty() && this.isOperator((String)stack.peek())) {
                    String top = stack.peek();
                    if ((!this.isLeftAssociative(token) || this.PRECEDENCE.get(token) > this.PRECEDENCE.get(top)) && (!this.isRightAssociative(token) || this.PRECEDENCE.get(token) >= this.PRECEDENCE.get(top))) break;
                    output.add(stack.pop());
                }
                stack.push(token);
                continue;
            }
            if (token.equals("(")) {
                stack.push(token);
                continue;
            }
            if (token.equals(")")) {
                while (!stack.isEmpty() && !stack.peek().equals("(")) {
                    output.add(stack.pop());
                }
                if (!stack.isEmpty() && stack.peek().equals("(")) {
                    stack.pop();
                }
                if (stack.isEmpty() || !this.FUNCTIONS.containsKey(stack.peek().toLowerCase())) continue;
                output.add(stack.pop());
                continue;
            }
            throw new RuntimeException("Unknown token: " + token);
        }
        while (!stack.isEmpty()) {
            output.add((String)stack.pop());
        }
        return output;
    }

    private double evalRPN(List<String> tokens) {
        Stack<Double> stack = new Stack<Double>();
        for (String token : tokens) {
            double a;
            if (this.isNumber(token)) {
                stack.push(Double.parseDouble(token));
                continue;
            }
            if (this.isConstant(token)) {
                stack.push(this.getConstant(token));
                continue;
            }
            if (this.isOperator(token)) {
                if (token.equals("u-")) {
                    a = (Double)stack.pop();
                    stack.push(-a);
                    continue;
                }
                double b = (Double)stack.pop();
                double a2 = (Double)stack.pop();
                switch (token) {
                    case "+": {
                        stack.push(a2 + b);
                        break;
                    }
                    case "-": {
                        stack.push(a2 - b);
                        break;
                    }
                    case "*": {
                        stack.push(a2 * b);
                        break;
                    }
                    case "/": {
                        stack.push(a2 / b);
                        break;
                    }
                    case "^": {
                        stack.push(Math.pow(a2, b));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown operator: " + token);
                    }
                }
                continue;
            }
            if (this.FUNCTIONS.containsKey(token.toLowerCase())) {
                a = (Double)stack.pop();
                stack.push(this.FUNCTIONS.get(token.toLowerCase()).apply(a));
                continue;
            }
            throw new RuntimeException("Unknown element in RPN: " + token);
        }
        return (Double)stack.pop();
    }

    private static String lastToken(Stack<String> stack, List<String> output) {
        if (!output.isEmpty()) {
            return output.get(output.size() - 1);
        }
        if (!stack.isEmpty()) {
            return stack.peek();
        }
        return "(";
    }

    private boolean isNumber(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isOperator(String s) {
        return this.PRECEDENCE.containsKey(s);
    }

    private boolean isLeftAssociative(String op) {
        return !this.RIGHT_ASSOCIATIVE.contains(op);
    }

    private boolean isRightAssociative(String op) {
        return this.RIGHT_ASSOCIATIVE.contains(op);
    }

    private boolean isConstant(String s) {
        return s.equalsIgnoreCase("pi") || s.equalsIgnoreCase("e");
    }

    private double getConstant(String s) {
        if (s.equalsIgnoreCase("pi")) {
            return Math.PI;
        }
        if (s.equalsIgnoreCase("e")) {
            return Math.E;
        }
        throw new RuntimeException("Unknown constant: " + s);
    }
}

