/*
 * Decompiled with CFR 0.152.
 */
package net.cyvforge.util.parkour;

import java.util.ArrayList;
import net.cyvforge.CyvForge;
import net.cyvforge.util.parkour.LandingAxis;
import net.cyvforge.util.parkour.LandingMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockVine;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class LandingBlock {
    public BlockPos pos;
    public AxisAlignedBB[] bb;
    public LandingMode mode;
    public LandingAxis axis;
    public boolean isBox;
    public boolean neoAndNormal;
    public Double pb;
    public Double pbX;
    public Double pbZ;
    public Double lastOffsetX;
    public Double lastOffsetZ;
    public Double lastPb;
    public Double xMaxWall;
    public Double xMinWall;
    public Double zMaxWall;
    public Double zMinWall;
    public double xMinCond;
    public double xMaxCond;
    public double zMinCond;
    public double zMaxCond;

    public LandingBlock(BlockPos pos, LandingMode mode, LandingAxis axis, boolean isBox) {
        this.pos = pos;
        this.mode = mode;
        this.axis = axis;
        this.isBox = isBox;
        this.calculateBounds();
        this.calculateWalls();
        this.xMinCond = this.smallestX() - 1.0;
        this.xMaxCond = this.largestX() + 1.0;
        this.zMinCond = this.smallestZ() - 1.0;
        this.zMaxCond = this.largestZ() + 1.0;
    }

    public LandingBlock(AxisAlignedBB bounds) {
        this.pos = new BlockPos(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c);
        this.mode = LandingMode.landing;
        this.axis = LandingAxis.both;
        this.isBox = false;
        this.bb = new AxisAlignedBB[]{bounds};
        this.xMinCond = this.smallestX() - 1.0;
        this.xMaxCond = this.largestX() + 1.0;
        this.zMinCond = this.smallestZ() - 1.0;
        this.zMaxCond = this.largestZ() + 1.0;
    }

    private void calculateBounds() {
        if (this.pos == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        IBlockState blockState = world.func_180495_p(this.pos);
        Block block = blockState.func_177230_c();
        if (this.isBox && (block instanceof BlockLadder || block instanceof BlockVine)) {
            AxisAlignedBB playerHitbox = mc.field_71439_g.func_174813_aQ();
            double playerX = playerHitbox.field_72336_d - playerHitbox.field_72340_a;
            double playerZ = playerHitbox.field_72334_f - playerHitbox.field_72339_c;
            AxisAlignedBB box = new AxisAlignedBB(playerX / 2.0 + (double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), playerZ / 2.0 + (double)this.pos.func_177952_p(), 1.0 - playerX / 2.0 + (double)this.pos.func_177958_n(), (double)(1 + this.pos.func_177956_o()), 1.0 - playerZ / 2.0 + (double)this.pos.func_177952_p());
            this.bb = new AxisAlignedBB[]{box};
            return;
        }
        this.bb = CyvForge.getHitbox(this.pos, (World)world).toArray(new AxisAlignedBB[0]);
    }

    public double smallestX() {
        Double v = null;
        for (AxisAlignedBB bb : this.bb) {
            if (v != null && !(v > bb.field_72340_a)) continue;
            v = bb.field_72340_a;
        }
        return v;
    }

    public double smallestY() {
        Double v = null;
        for (AxisAlignedBB bb : this.bb) {
            if (v != null && !(v > bb.field_72338_b)) continue;
            v = bb.field_72338_b;
        }
        return v;
    }

    public double smallestZ() {
        Double v = null;
        for (AxisAlignedBB bb : this.bb) {
            if (v != null && !(v > bb.field_72339_c)) continue;
            v = bb.field_72339_c;
        }
        return v;
    }

    public double largestX() {
        Double v = null;
        for (AxisAlignedBB bb : this.bb) {
            if (v != null && !(v < bb.field_72336_d)) continue;
            v = bb.field_72336_d;
        }
        return v;
    }

    public double largestY() {
        Double v = null;
        for (AxisAlignedBB bb : this.bb) {
            if (v != null && !(v < bb.field_72337_e)) continue;
            v = bb.field_72337_e;
        }
        return v;
    }

    public double largestZ() {
        Double v = null;
        for (AxisAlignedBB bb : this.bb) {
            if (v != null && !(v < bb.field_72334_f)) continue;
            v = bb.field_72334_f;
        }
        return v;
    }

    public void adjustCond(double x1, double x2, double z1, double z2) {
        if (x1 > x2) {
            this.xMaxCond = x1;
            this.xMinCond = x2;
        } else {
            this.xMaxCond = x2;
            this.xMinCond = x1;
        }
        if (z1 > z2) {
            this.zMaxCond = z1;
            this.zMinCond = z2;
        } else {
            this.zMaxCond = z2;
            this.zMinCond = z1;
        }
    }

    public void calculateWalls() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        AxisAlignedBB playerHitbox = Minecraft.func_71410_x().field_71439_g.func_174813_aQ();
        BlockPos tempPos = this.pos;
        if (this.mode == LandingMode.enter) {
            tempPos = tempPos.func_177977_b();
        }
        this.xMinWall = null;
        this.xMaxWall = null;
        this.zMinWall = null;
        this.zMaxWall = null;
        for (AxisAlignedBB box : this.bb) {
            double currentWall;
            double offset;
            ArrayList<AxisAlignedBB> wallBoxes = new ArrayList<AxisAlignedBB>();
            BlockPos currentWallPos = null;
            currentWallPos = tempPos.func_177978_c();
            for (double i = 0.0; i < playerHitbox.field_72337_e - playerHitbox.field_72338_b; i += 1.0) {
                currentWallPos = currentWallPos.func_177984_a();
                wallBoxes.addAll(CyvForge.getHitbox(currentWallPos, (World)world));
            }
            for (AxisAlignedBB wall : wallBoxes) {
                if (wall.field_72336_d - wall.field_72340_a < box.field_72336_d - box.field_72340_a || !((offset = box.field_72339_c - (currentWall = wall.field_72334_f) - (playerHitbox.field_72334_f - playerHitbox.field_72339_c)) < 0.0) || this.zMinWall != null && !(currentWall > this.zMinWall)) continue;
                this.zMinWall = currentWall;
            }
            wallBoxes.clear();
            currentWallPos = tempPos.func_177968_d();
            for (double i = 0.0; i < playerHitbox.field_72337_e - playerHitbox.field_72338_b; i += 1.0) {
                currentWallPos = currentWallPos.func_177984_a();
                wallBoxes.addAll(CyvForge.getHitbox(currentWallPos, (World)world));
            }
            for (AxisAlignedBB wall : wallBoxes) {
                if (wall.field_72336_d - wall.field_72340_a < box.field_72336_d - box.field_72340_a || !((offset = (currentWall = wall.field_72339_c) - box.field_72334_f - (playerHitbox.field_72334_f - playerHitbox.field_72339_c)) < 0.0) || this.zMaxWall != null && !(currentWall > this.zMaxWall)) continue;
                this.zMaxWall = currentWall;
            }
            wallBoxes.clear();
            currentWallPos = tempPos.func_177976_e();
            for (double i = 0.0; i < playerHitbox.field_72337_e - playerHitbox.field_72338_b; i += 1.0) {
                currentWallPos = currentWallPos.func_177984_a();
                wallBoxes.addAll(CyvForge.getHitbox(currentWallPos, (World)world));
            }
            for (AxisAlignedBB wall : wallBoxes) {
                if (wall.field_72334_f - wall.field_72339_c < box.field_72334_f - box.field_72339_c || !((offset = box.field_72340_a - (currentWall = wall.field_72336_d) - (playerHitbox.field_72336_d - playerHitbox.field_72340_a)) < 0.0) || this.xMinWall != null && !(currentWall > this.xMinWall)) continue;
                this.xMinWall = currentWall;
            }
            wallBoxes.clear();
            currentWallPos = tempPos.func_177974_f();
            for (double i = 0.0; i < playerHitbox.field_72337_e - playerHitbox.field_72338_b; i += 1.0) {
                currentWallPos = currentWallPos.func_177984_a();
                wallBoxes.addAll(CyvForge.getHitbox(currentWallPos, (World)world));
            }
            for (AxisAlignedBB wall : wallBoxes) {
                if (wall.field_72334_f - wall.field_72339_c < box.field_72334_f - box.field_72339_c || !((offset = (currentWall = wall.field_72340_a) - box.field_72336_d - (playerHitbox.field_72336_d - playerHitbox.field_72340_a)) < 0.0) || this.xMaxWall != null && !(currentWall > this.xMaxWall)) continue;
                this.xMaxWall = currentWall;
            }
        }
    }

    public void resetWalls() {
        this.xMinWall = null;
        this.xMaxWall = null;
        this.zMinWall = null;
        this.zMaxWall = null;
    }
}

